/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collection;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.integration.computer.BaseComputerHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.ComputerMethodFactory;
import mekanism.common.integration.computer.MethodData;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.MethodFactory;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

@MethodFactory(target=TileEntityQuantumEntangloporter.class)
public class TileEntityQuantumEntangloporter$ComputerHandler
extends ComputerMethodFactory<TileEntityQuantumEntangloporter> {
    private final String[] NAMES_name = new String[]{"name"};
    private final Class[] TYPES_473e3684 = new Class[]{String.class};

    public TileEntityQuantumEntangloporter$ComputerHandler() {
        this.register(MethodData.builder("hasFrequency", TileEntityQuantumEntangloporter$ComputerHandler::hasFrequency_0).returnType(Boolean.TYPE));
        this.register(MethodData.builder("getTransferLoss", TileEntityQuantumEntangloporter$ComputerHandler::getTransferLoss_0).returnType(Double.TYPE).methodDescription("May not be accurate if there is no frequency"));
        this.register(MethodData.builder("getEnvironmentalLoss", TileEntityQuantumEntangloporter$ComputerHandler::getEnvironmentalLoss_0).returnType(Double.TYPE).methodDescription("May not be accurate if there is no frequency"));
        this.register(MethodData.builder("getFrequencies", TileEntityQuantumEntangloporter$ComputerHandler::getFrequencies_0).returnType(Collection.class).returnExtra(InventoryFrequency.class).methodDescription("Lists public frequencies"));
        this.register(MethodData.builder("getFrequency", TileEntityQuantumEntangloporter$ComputerHandler::getFrequency_0).returnType(InventoryFrequency.class).methodDescription("Requires a frequency to be selected"));
        this.register(MethodData.builder("setFrequency", TileEntityQuantumEntangloporter$ComputerHandler::setFrequency_1).methodDescription("Requires a public frequency to exist").requiresPublicSecurity().arguments(this.NAMES_name, this.TYPES_473e3684));
        this.register(MethodData.builder("createFrequency", TileEntityQuantumEntangloporter$ComputerHandler::createFrequency_1).methodDescription("Requires frequency to not already exist and for it to be public so that it can make it as the player who owns the block. Also sets the frequency after creation").requiresPublicSecurity().arguments(this.NAMES_name, this.TYPES_473e3684));
        this.register(MethodData.builder("getBufferItem", TileEntityQuantumEntangloporter$ComputerHandler::getBufferItem_0).returnType(ItemStack.class));
        this.register(MethodData.builder("getBufferFluid", TileEntityQuantumEntangloporter$ComputerHandler::getBufferFluidTank$getBufferFluid).returnType(FluidStack.class).methodDescription("Get the contents of the fluid buffer."));
        this.register(MethodData.builder("getBufferFluidCapacity", TileEntityQuantumEntangloporter$ComputerHandler::getBufferFluidTank$getBufferFluidCapacity).returnType(Integer.TYPE).methodDescription("Get the capacity of the fluid buffer."));
        this.register(MethodData.builder("getBufferFluidNeeded", TileEntityQuantumEntangloporter$ComputerHandler::getBufferFluidTank$getBufferFluidNeeded).returnType(Integer.TYPE).methodDescription("Get the amount needed to fill the fluid buffer."));
        this.register(MethodData.builder("getBufferFluidFilledPercentage", TileEntityQuantumEntangloporter$ComputerHandler::getBufferFluidTank$getBufferFluidFilledPercentage).returnType(Double.TYPE).methodDescription("Get the filled percentage of the fluid buffer."));
        this.register(MethodData.builder("getBufferChemical", TileEntityQuantumEntangloporter$ComputerHandler::getBufferChemicalTank$getBufferChemical).returnType(ChemicalStack.class).methodDescription("Get the contents of the chemical buffer."));
        this.register(MethodData.builder("getBufferChemicalCapacity", TileEntityQuantumEntangloporter$ComputerHandler::getBufferChemicalTank$getBufferChemicalCapacity).returnType(Long.TYPE).methodDescription("Get the capacity of the chemical buffer."));
        this.register(MethodData.builder("getBufferChemicalNeeded", TileEntityQuantumEntangloporter$ComputerHandler::getBufferChemicalTank$getBufferChemicalNeeded).returnType(Long.TYPE).methodDescription("Get the amount needed to fill the chemical buffer."));
        this.register(MethodData.builder("getBufferChemicalFilledPercentage", TileEntityQuantumEntangloporter$ComputerHandler::getBufferChemicalTank$getBufferChemicalFilledPercentage).returnType(Double.TYPE).methodDescription("Get the filled percentage of the chemical buffer."));
        this.register(MethodData.builder("getTemperature", TileEntityQuantumEntangloporter$ComputerHandler::getTemperature_0).returnType(Double.TYPE).methodDescription("Requires a frequency to be selected"));
    }

    public static Object hasFrequency_0(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.hasFrequency());
    }

    public static Object getTransferLoss_0(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getLastTransferLoss());
    }

    public static Object getEnvironmentalLoss_0(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getLastEnvironmentLoss());
    }

    public static Object getFrequencies_0(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getFrequencies(), helper::convert);
    }

    public static Object getFrequency_0(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getFrequency());
    }

    public static Object setFrequency_1(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        subject.setFrequency(helper.getString(0));
        return helper.voidResult();
    }

    public static Object createFrequency_1(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        subject.createFrequency(helper.getString(0));
        return helper.voidResult();
    }

    public static Object getBufferItem_0(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getBufferItem());
    }

    public static Object getBufferFluidTank$getBufferFluid(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerFluidTankWrapper.getStack(subject.getBufferFluidTank()));
    }

    public static Object getBufferFluidTank$getBufferFluidCapacity(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerFluidTankWrapper.getCapacity(subject.getBufferFluidTank()));
    }

    public static Object getBufferFluidTank$getBufferFluidNeeded(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerFluidTankWrapper.getNeeded(subject.getBufferFluidTank()));
    }

    public static Object getBufferFluidTank$getBufferFluidFilledPercentage(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerFluidTankWrapper.getFilledPercentage(subject.getBufferFluidTank()));
    }

    public static Object getBufferChemicalTank$getBufferChemical(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.getStack(subject.getBufferChemicalTank()));
    }

    public static Object getBufferChemicalTank$getBufferChemicalCapacity(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.getCapacity(subject.getBufferChemicalTank()));
    }

    public static Object getBufferChemicalTank$getBufferChemicalNeeded(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.getNeeded(subject.getBufferChemicalTank()));
    }

    public static Object getBufferChemicalTank$getBufferChemicalFilledPercentage(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.getFilledPercentage(subject.getBufferChemicalTank()));
    }

    public static Object getTemperature_0(TileEntityQuantumEntangloporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getTemperature());
    }
}

