/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityPersonalStorage
extends TileEntityMekanism {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            TileEntityPersonalStorage.this.onOpen(level, pos, state);
        }

        protected void onClose(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            TileEntityPersonalStorage.this.onClose(level, pos, state);
        }

        protected void openerCountChanged(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, int oldCount, int openCount) {
            level.blockEvent(pos, state.getBlock(), 1, openCount);
        }

        protected boolean isOwnContainer(@NotNull Player player) {
            MekanismTileContainer container;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            return abstractContainerMenu instanceof MekanismTileContainer && (container = (MekanismTileContainer)abstractContainerMenu).getTileEntity() == TileEntityPersonalStorage.this;
        }
    };

    protected TileEntityPersonalStorage(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this.facingSupplier);
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInteract = (stack, automationType) -> automationType == AutomationType.MANUAL || ISecurityUtils.INSTANCE.getEffectiveSecurityMode(this, this.isRemote()) == SecurityMode.PUBLIC;
        PersonalStorageManager.createSlots(builder::addSlot, canInteract, listener);
        return builder.build();
    }

    @Override
    public void open(Player player) {
        super.open(player);
        if (!this.isRemoved() && !player.isSpectator() && this.level != null) {
            this.openersCounter.incrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public void close(Player player) {
        super.close(player);
        if (!this.isRemoved() && !player.isSpectator() && this.level != null) {
            this.openersCounter.decrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.isRemoved() && this.level != null) {
            this.openersCounter.recheckOpeners(this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    protected abstract void onOpen(@NotNull Level var1, @NotNull BlockPos var2, @NotNull BlockState var3);

    protected abstract void onClose(@NotNull Level var1, @NotNull BlockPos var2, @NotNull BlockState var3);

    protected abstract ResourceLocation getStat();

    @Override
    public InteractionResult openGui(Player player) {
        InteractionResult result = super.openGui(player);
        if (result.consumesAction() && !this.isRemote()) {
            player.awardStat(Stats.CUSTOM.get((Object)this.getStat()));
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return result;
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        AbstractPersonalStorageItemInventory storageItemInventory;
        UUID owner;
        super.applyImplicitComponents(input);
        if (!this.isRemote() && (owner = (UUID)input.get(MekanismDataComponents.OWNER)) != null && (storageItemInventory = (AbstractPersonalStorageItemInventory)PersonalStorageManager.getInventoryForUnchecked((UUID)input.get(MekanismDataComponents.PERSONAL_STORAGE_ID), owner).orElse(null)) != null) {
            List<IInventorySlot> inventorySlots = storageItemInventory.getInventorySlots(null);
            for (int i = 0; i < inventorySlots.size(); ++i) {
                this.setStackInSlot(i, inventorySlots.get(i).getStack().copy());
            }
        }
    }
}

