/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockEnergyCube;
import mekanism.common.block.basic.BlockBin;
import mekanism.common.block.basic.BlockFluidTank;
import mekanism.common.block.prefab.BlockFactoryMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.item.block.ItemBlockChemicalTank;
import mekanism.common.item.block.ItemBlockEnergyCube;
import mekanism.common.item.block.machine.ItemBlockFactory;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityIndustrialAlarm;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityModificationStation;
import mekanism.common.tile.TileEntityPersonalBarrel;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntityRadioactiveWasteBarrel;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.factory.TileEntityCombiningFactory;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.factory.TileEntityItemStackChemicalToItemStackFactory;
import mekanism.common.tile.factory.TileEntityItemStackToItemStackFactory;
import mekanism.common.tile.factory.TileEntitySawingFactory;
import mekanism.common.tile.laser.TileEntityLaser;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.laser.TileEntityLaserTractorBeam;
import mekanism.common.tile.machine.TileEntityAntiprotonicNucleosynthesizer;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import mekanism.common.tile.machine.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.machine.TileEntityChemicalInfuser;
import mekanism.common.tile.machine.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.machine.TileEntityChemicalOxidizer;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.tile.machine.TileEntityCombiner;
import mekanism.common.tile.machine.TileEntityCrusher;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import mekanism.common.tile.machine.TileEntityElectricPump;
import mekanism.common.tile.machine.TileEntityElectrolyticSeparator;
import mekanism.common.tile.machine.TileEntityEnergizedSmelter;
import mekanism.common.tile.machine.TileEntityEnrichmentChamber;
import mekanism.common.tile.machine.TileEntityFluidicPlenisher;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.machine.TileEntityFuelwoodHeater;
import mekanism.common.tile.machine.TileEntityIsotopicCentrifuge;
import mekanism.common.tile.machine.TileEntityMetallurgicInfuser;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.machine.TileEntityOsmiumCompressor;
import mekanism.common.tile.machine.TileEntityPaintingMachine;
import mekanism.common.tile.machine.TileEntityPigmentExtractor;
import mekanism.common.tile.machine.TileEntityPigmentMixer;
import mekanism.common.tile.machine.TileEntityPrecisionSawmill;
import mekanism.common.tile.machine.TileEntityPressurizedReactionChamber;
import mekanism.common.tile.machine.TileEntityPurificationChamber;
import mekanism.common.tile.machine.TileEntityResistiveHeater;
import mekanism.common.tile.machine.TileEntityRotaryCondensentrator;
import mekanism.common.tile.machine.TileEntitySeismicVibrator;
import mekanism.common.tile.machine.TileEntitySolarNeutronActivator;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.tile.multiblock.TileEntityBoilerValve;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.tile.multiblock.TileEntityDynamicValve;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionPort;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import mekanism.common.tile.multiblock.TileEntitySPSCasing;
import mekanism.common.tile.multiblock.TileEntitySPSPort;
import mekanism.common.tile.multiblock.TileEntityStructuralGlass;
import mekanism.common.tile.multiblock.TileEntitySuperchargedCoil;
import mekanism.common.tile.multiblock.TileEntitySuperheatingElement;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationValve;
import mekanism.common.tile.qio.TileEntityQIODashboard;
import mekanism.common.tile.qio.TileEntityQIODriveArray;
import mekanism.common.tile.qio.TileEntityQIOExporter;
import mekanism.common.tile.qio.TileEntityQIOImporter;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityRestrictiveTransporter;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MekanismTileEntityTypes {
    public static final TileEntityTypeDeferredRegister TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekanism");
    private static final Table<FactoryTier, FactoryType, TileEntityTypeRegistryObject<? extends TileEntityFactory<?>>> FACTORIES = HashBasedTable.create();
    public static final TileEntityTypeRegistryObject<TileEntityBoundingBlock> BOUNDING_BLOCK;
    public static final TileEntityTypeRegistryObject<TileEntityBoilerCasing> BOILER_CASING;
    public static final TileEntityTypeRegistryObject<TileEntityBoilerValve> BOILER_VALVE;
    public static final TileEntityTypeRegistryObject<TileEntityCardboardBox> CARDBOARD_BOX;
    public static final TileEntityTypeRegistryObject<TileEntityChargepad> CHARGEPAD;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalCrystallizer> CHEMICAL_CRYSTALLIZER;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalDissolutionChamber> CHEMICAL_DISSOLUTION_CHAMBER;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalInfuser> CHEMICAL_INFUSER;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalInjectionChamber> CHEMICAL_INJECTION_CHAMBER;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalOxidizer> CHEMICAL_OXIDIZER;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalWasher> CHEMICAL_WASHER;
    public static final TileEntityTypeRegistryObject<TileEntityCombiner> COMBINER;
    public static final TileEntityTypeRegistryObject<TileEntityCrusher> CRUSHER;
    public static final TileEntityTypeRegistryObject<TileEntityDigitalMiner> DIGITAL_MINER;
    public static final TileEntityTypeRegistryObject<TileEntityDynamicTank> DYNAMIC_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityDynamicValve> DYNAMIC_VALVE;
    public static final TileEntityTypeRegistryObject<TileEntityElectricPump> ELECTRIC_PUMP;
    public static final TileEntityTypeRegistryObject<TileEntityElectrolyticSeparator> ELECTROLYTIC_SEPARATOR;
    public static final TileEntityTypeRegistryObject<TileEntityEnergizedSmelter> ENERGIZED_SMELTER;
    public static final TileEntityTypeRegistryObject<TileEntityEnrichmentChamber> ENRICHMENT_CHAMBER;
    public static final TileEntityTypeRegistryObject<TileEntityFluidicPlenisher> FLUIDIC_PLENISHER;
    public static final TileEntityTypeRegistryObject<TileEntityFormulaicAssemblicator> FORMULAIC_ASSEMBLICATOR;
    public static final TileEntityTypeRegistryObject<TileEntityFuelwoodHeater> FUELWOOD_HEATER;
    public static final TileEntityTypeRegistryObject<TileEntityInductionCasing> INDUCTION_CASING;
    public static final TileEntityTypeRegistryObject<TileEntityInductionPort> INDUCTION_PORT;
    public static final TileEntityTypeRegistryObject<TileEntityLaser> LASER;
    public static final TileEntityTypeRegistryObject<TileEntityLaserAmplifier> LASER_AMPLIFIER;
    public static final TileEntityTypeRegistryObject<TileEntityLaserTractorBeam> LASER_TRACTOR_BEAM;
    public static final TileEntityTypeRegistryObject<TileEntityLogisticalSorter> LOGISTICAL_SORTER;
    public static final TileEntityTypeRegistryObject<TileEntityMetallurgicInfuser> METALLURGIC_INFUSER;
    public static final TileEntityTypeRegistryObject<TileEntityOredictionificator> OREDICTIONIFICATOR;
    public static final TileEntityTypeRegistryObject<TileEntityOsmiumCompressor> OSMIUM_COMPRESSOR;
    public static final TileEntityTypeRegistryObject<TileEntityPersonalBarrel> PERSONAL_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityPersonalChest> PERSONAL_CHEST;
    public static final TileEntityTypeRegistryObject<TileEntityPrecisionSawmill> PRECISION_SAWMILL;
    public static final TileEntityTypeRegistryObject<TileEntityPressureDisperser> PRESSURE_DISPERSER;
    public static final TileEntityTypeRegistryObject<TileEntityPressurizedReactionChamber> PRESSURIZED_REACTION_CHAMBER;
    public static final TileEntityTypeRegistryObject<TileEntityPurificationChamber> PURIFICATION_CHAMBER;
    public static final TileEntityTypeRegistryObject<TileEntityQuantumEntangloporter> QUANTUM_ENTANGLOPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityResistiveHeater> RESISTIVE_HEATER;
    public static final TileEntityTypeRegistryObject<TileEntityModificationStation> MODIFICATION_STATION;
    public static final TileEntityTypeRegistryObject<TileEntityIsotopicCentrifuge> ISOTOPIC_CENTRIFUGE;
    public static final TileEntityTypeRegistryObject<TileEntityNutritionalLiquifier> NUTRITIONAL_LIQUIFIER;
    public static final TileEntityTypeRegistryObject<TileEntityRotaryCondensentrator> ROTARY_CONDENSENTRATOR;
    public static final TileEntityTypeRegistryObject<TileEntitySecurityDesk> SECURITY_DESK;
    public static final TileEntityTypeRegistryObject<TileEntitySeismicVibrator> SEISMIC_VIBRATOR;
    public static final TileEntityTypeRegistryObject<TileEntitySolarNeutronActivator> SOLAR_NEUTRON_ACTIVATOR;
    public static final TileEntityTypeRegistryObject<TileEntityStructuralGlass> STRUCTURAL_GLASS;
    public static final TileEntityTypeRegistryObject<TileEntitySuperheatingElement> SUPERHEATING_ELEMENT;
    public static final TileEntityTypeRegistryObject<TileEntityTeleporter> TELEPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityThermalEvaporationBlock> THERMAL_EVAPORATION_BLOCK;
    public static final TileEntityTypeRegistryObject<TileEntityThermalEvaporationController> THERMAL_EVAPORATION_CONTROLLER;
    public static final TileEntityTypeRegistryObject<TileEntityThermalEvaporationValve> THERMAL_EVAPORATION_VALVE;
    public static final TileEntityTypeRegistryObject<TileEntityRadioactiveWasteBarrel> RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityIndustrialAlarm> INDUSTRIAL_ALARM;
    public static final TileEntityTypeRegistryObject<TileEntityAntiprotonicNucleosynthesizer> ANTIPROTONIC_NUCLEOSYNTHESIZER;
    public static final TileEntityTypeRegistryObject<TileEntityPigmentExtractor> PIGMENT_EXTRACTOR;
    public static final TileEntityTypeRegistryObject<TileEntityPigmentMixer> PIGMENT_MIXER;
    public static final TileEntityTypeRegistryObject<TileEntityPaintingMachine> PAINTING_MACHINE;
    public static final TileEntityTypeRegistryObject<TileEntitySPSCasing> SPS_CASING;
    public static final TileEntityTypeRegistryObject<TileEntitySPSPort> SPS_PORT;
    public static final TileEntityTypeRegistryObject<TileEntitySuperchargedCoil> SUPERCHARGED_COIL;
    public static final TileEntityTypeRegistryObject<TileEntityDimensionalStabilizer> DIMENSIONAL_STABILIZER;
    public static final TileEntityTypeRegistryObject<TileEntityQIODriveArray> QIO_DRIVE_ARRAY;
    public static final TileEntityTypeRegistryObject<TileEntityQIODashboard> QIO_DASHBOARD;
    public static final TileEntityTypeRegistryObject<TileEntityQIOImporter> QIO_IMPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityQIOExporter> QIO_EXPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityQIORedstoneAdapter> QIO_REDSTONE_ADAPTER;
    public static final TileEntityTypeRegistryObject<TileEntityDiversionTransporter> DIVERSION_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityRestrictiveTransporter> RESTRICTIVE_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityLogisticalTransporter> BASIC_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityLogisticalTransporter> ADVANCED_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityLogisticalTransporter> ELITE_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityLogisticalTransporter> ULTIMATE_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityMechanicalPipe> BASIC_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<TileEntityMechanicalPipe> ADVANCED_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<TileEntityMechanicalPipe> ELITE_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<TileEntityMechanicalPipe> ULTIMATE_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<TileEntityPressurizedTube> BASIC_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<TileEntityPressurizedTube> ADVANCED_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<TileEntityPressurizedTube> ELITE_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<TileEntityPressurizedTube> ULTIMATE_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<TileEntityThermodynamicConductor> BASIC_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityThermodynamicConductor> ADVANCED_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityThermodynamicConductor> ELITE_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityThermodynamicConductor> ULTIMATE_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityUniversalCable> BASIC_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<TileEntityUniversalCable> ADVANCED_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<TileEntityUniversalCable> ELITE_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<TileEntityUniversalCable> ULTIMATE_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<TileEntityEnergyCube> BASIC_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityEnergyCube> ADVANCED_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityEnergyCube> ELITE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityEnergyCube> ULTIMATE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityEnergyCube> CREATIVE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalTank> BASIC_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalTank> ADVANCED_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalTank> ELITE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalTank> ULTIMATE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalTank> CREATIVE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityFluidTank> BASIC_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityFluidTank> ADVANCED_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityFluidTank> ELITE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityFluidTank> ULTIMATE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityFluidTank> CREATIVE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityBin> BASIC_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityBin> ADVANCED_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityBin> ELITE_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityBin> ULTIMATE_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityBin> CREATIVE_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityInductionCell> BASIC_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<TileEntityInductionCell> ADVANCED_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<TileEntityInductionCell> ELITE_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<TileEntityInductionCell> ULTIMATE_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<TileEntityInductionProvider> BASIC_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<TileEntityInductionProvider> ADVANCED_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<TileEntityInductionProvider> ELITE_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<TileEntityInductionProvider> ULTIMATE_INDUCTION_PROVIDER;

    private MekanismTileEntityTypes() {
    }

    private static void registerFactory(FactoryTier tier, FactoryType type, BlockEntityFactory<? extends TileEntityFactory<?>> factoryConstructor) {
        BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory> block = MekanismBlocks.getFactory(tier, type);
        TileEntityTypeRegistryObject tileRO = TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> (TileEntityFactory)factoryConstructor.create(block, pos, state)).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        FACTORIES.put((Object)tier, (Object)type, tileRO);
    }

    private static TileEntityTypeRegistryObject<TileEntityDiversionTransporter> registerDiversionTransporter() {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<TileEntityDiversionTransporter> builder = MekanismTileEntityTypes.transporterBuilder(MekanismBlocks.DIVERSION_TRANSPORTER, TileEntityDiversionTransporter::new);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(builder, ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static <BE extends TileEntityLogisticalTransporterBase> TileEntityTypeRegistryObject<BE> registerTransporter(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return MekanismTileEntityTypes.transporterBuilder(block, factory).build();
    }

    private static <BE extends TileEntityLogisticalTransporterBase> TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<BE> transporterBuilder(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return MekanismTileEntityTypes.transmitterBuilder(block, factory).clientTicker(TileEntityLogisticalTransporterBase::tickClient).with(Capabilities.ITEM.block(), CapabilityTileEntity.ITEM_HANDLER_PROVIDER);
    }

    private static TileEntityTypeRegistryObject<TileEntityMechanicalPipe> registerPipe(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<CapabilityTileEntity> builder = MekanismTileEntityTypes.transmitterBuilder(block, TileEntityMechanicalPipe::new).with(Capabilities.FLUID.block(), CapabilityTileEntity.FLUID_HANDLER_PROVIDER);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(builder, ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static TileEntityTypeRegistryObject<TileEntityPressurizedTube> registerTube(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<CapabilityTileEntity> builder = MekanismTileEntityTypes.transmitterBuilder(block, TileEntityPressurizedTube::new).with(Capabilities.CHEMICAL.block(), CapabilityTileEntity.CHEMICAL_HANDLER_PROVIDER);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(builder, ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static TileEntityTypeRegistryObject<TileEntityThermodynamicConductor> registerConductor(BlockRegistryObject<?, ?> block) {
        return MekanismTileEntityTypes.transmitterBuilder(block, TileEntityThermodynamicConductor::new).with(Capabilities.HEAT, CapabilityTileEntity.HEAT_HANDLER_PROVIDER).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityUniversalCable> registerCable(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<TileEntityUniversalCable> builder = MekanismTileEntityTypes.transmitterBuilder(block, TileEntityUniversalCable::new);
        EnergyCompatUtils.addBlockCapabilities(builder);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(builder, ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static <BE extends TileEntityTransmitter> TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<BE> transmitterBuilder(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return TILE_ENTITY_TYPES.builder(block, (pos, state) -> (TileEntityTransmitter)factory.create(block, pos, state)).serverTicker(TileEntityTransmitter::tickServer).withSimple(Capabilities.ALLOY_INTERACTION).with(Capabilities.CONFIGURABLE, TileEntityTransmitter.CONFIGURABLE_PROVIDER);
    }

    private static TileEntityTypeRegistryObject<TileEntityEnergyCube> registerEnergyCube(BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> block) {
        return TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityEnergyCube(block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityChemicalTank> registerChemicalTank(BlockRegistryObject<?, ItemBlockChemicalTank> block) {
        return TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityChemicalTank(block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityFluidTank> registerFluidTank(BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> block) {
        return TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityFluidTank(block, pos, state)).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityBin> registerBin(BlockRegistryObject<BlockBin, ItemBlockBin> block) {
        return TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityBin(block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityFactory<?>> getFactoryTile(FactoryTier tier, FactoryType type) {
        return (TileEntityTypeRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityFactory<?>>[] getFactoryTiles() {
        return FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.COMBINING, TileEntityCombiningFactory::new);
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.COMPRESSING, TileEntityItemStackChemicalToItemStackFactory::new);
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.CRUSHING, TileEntityItemStackToItemStackFactory::new);
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.ENRICHING, TileEntityItemStackToItemStackFactory::new);
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.INFUSING, TileEntityItemStackChemicalToItemStackFactory::new);
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.INJECTING, TileEntityItemStackChemicalToItemStackFactory::new);
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.PURIFYING, TileEntityItemStackChemicalToItemStackFactory::new);
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.SAWING, TileEntitySawingFactory::new);
            MekanismTileEntityTypes.registerFactory(tier, FactoryType.SMELTING, TileEntityItemStackToItemStackFactory::new);
        }
        BOUNDING_BLOCK = TILE_ENTITY_TYPES.builder(MekanismBlocks.BOUNDING_BLOCK, TileEntityBoundingBlock::new).build();
        BOILER_CASING = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.BOILER_CASING, TileEntityBoilerCasing::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        BOILER_VALVE = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.BOILER_VALVE, TileEntityBoilerValve::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        CARDBOARD_BOX = TILE_ENTITY_TYPES.builder(MekanismBlocks.CARDBOARD_BOX, TileEntityCardboardBox::new).build();
        CHARGEPAD = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.CHARGEPAD, TileEntityChargepad::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).build();
        CHEMICAL_CRYSTALLIZER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.CHEMICAL_CRYSTALLIZER, TileEntityChemicalCrystallizer::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CHEMICAL_DISSOLUTION_CHAMBER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, TileEntityChemicalDissolutionChamber::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CHEMICAL_INFUSER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.CHEMICAL_INFUSER, TileEntityChemicalInfuser::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CHEMICAL_INJECTION_CHAMBER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.CHEMICAL_INJECTION_CHAMBER, TileEntityChemicalInjectionChamber::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CHEMICAL_OXIDIZER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.CHEMICAL_OXIDIZER, TileEntityChemicalOxidizer::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CHEMICAL_WASHER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.CHEMICAL_WASHER, TileEntityChemicalWasher::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        COMBINER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.COMBINER, TileEntityCombiner::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CRUSHER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.CRUSHER, TileEntityCrusher::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        DIGITAL_MINER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.DIGITAL_MINER, TileEntityDigitalMiner::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).without(Capabilities.ITEM.block()).build();
        DYNAMIC_TANK = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.DYNAMIC_TANK, TileEntityDynamicTank::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).without(Capabilities.ITEM.block()).build();
        DYNAMIC_VALVE = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.DYNAMIC_VALVE, TileEntityDynamicValve::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        ELECTRIC_PUMP = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.ELECTRIC_PUMP, TileEntityElectricPump::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
        ELECTROLYTIC_SEPARATOR = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.ELECTROLYTIC_SEPARATOR, TileEntityElectrolyticSeparator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        ENERGIZED_SMELTER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.ENERGIZED_SMELTER, TileEntityEnergizedSmelter::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        ENRICHMENT_CHAMBER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.ENRICHMENT_CHAMBER, TileEntityEnrichmentChamber::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        FLUIDIC_PLENISHER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.FLUIDIC_PLENISHER, TileEntityFluidicPlenisher::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
        FORMULAIC_ASSEMBLICATOR = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.FORMULAIC_ASSEMBLICATOR, TileEntityFormulaicAssemblicator::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        FUELWOOD_HEATER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.FUELWOOD_HEATER, TileEntityFuelwoodHeater::new).serverTicker(TileEntityMekanism::tickServer).build();
        INDUCTION_CASING = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.INDUCTION_CASING, TileEntityInductionCasing::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).without(Capabilities.ITEM.block()).build();
        INDUCTION_PORT = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.INDUCTION_PORT, TileEntityInductionPort::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        LASER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.LASER, TileEntityLaser::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).build();
        LASER_AMPLIFIER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.LASER_AMPLIFIER, TileEntityLaserAmplifier::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.LASER_RECEPTOR).build();
        LASER_TRACTOR_BEAM = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.LASER_TRACTOR_BEAM, TileEntityLaserTractorBeam::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.LASER_RECEPTOR).build();
        LOGISTICAL_SORTER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.LOGISTICAL_SORTER, TileEntityLogisticalSorter::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        METALLURGIC_INFUSER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.METALLURGIC_INFUSER, TileEntityMetallurgicInfuser::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        OREDICTIONIFICATOR = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.OREDICTIONIFICATOR, TileEntityOredictionificator::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        OSMIUM_COMPRESSOR = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.OSMIUM_COMPRESSOR, TileEntityOsmiumCompressor::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        PERSONAL_BARREL = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PERSONAL_BARREL, TileEntityPersonalBarrel::new).serverTicker(TileEntityMekanism::tickServer).build();
        PERSONAL_CHEST = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PERSONAL_CHEST, TileEntityPersonalChest::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).build();
        PRECISION_SAWMILL = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PRECISION_SAWMILL, TileEntityPrecisionSawmill::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        PRESSURE_DISPERSER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PRESSURE_DISPERSER, TileEntityPressureDisperser::new).serverTicker(TileEntityMekanism::tickServer).build();
        PRESSURIZED_REACTION_CHAMBER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PRESSURIZED_REACTION_CHAMBER, TileEntityPressurizedReactionChamber::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        PURIFICATION_CHAMBER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PURIFICATION_CHAMBER, TileEntityPurificationChamber::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        QUANTUM_ENTANGLOPORTER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.QUANTUM_ENTANGLOPORTER, TileEntityQuantumEntangloporter::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        RESISTIVE_HEATER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.RESISTIVE_HEATER, TileEntityResistiveHeater::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        MODIFICATION_STATION = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.MODIFICATION_STATION, TileEntityModificationStation::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        ISOTOPIC_CENTRIFUGE = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.ISOTOPIC_CENTRIFUGE, TileEntityIsotopicCentrifuge::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        NUTRITIONAL_LIQUIFIER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.NUTRITIONAL_LIQUIFIER, TileEntityNutritionalLiquifier::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        ROTARY_CONDENSENTRATOR = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.ROTARY_CONDENSENTRATOR, TileEntityRotaryCondensentrator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        SECURITY_DESK = TILE_ENTITY_TYPES.builder(MekanismBlocks.SECURITY_DESK, TileEntitySecurityDesk::new).serverTicker(TileEntityMekanism::tickServer).withSimple(IBlockSecurityUtils.INSTANCE.ownerCapability()).build();
        SEISMIC_VIBRATOR = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.SEISMIC_VIBRATOR, TileEntitySeismicVibrator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        SOLAR_NEUTRON_ACTIVATOR = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR, TileEntitySolarNeutronActivator::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        STRUCTURAL_GLASS = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.STRUCTURAL_GLASS, TileEntityStructuralGlass::new).withSimple(Capabilities.CONFIGURABLE).build();
        SUPERHEATING_ELEMENT = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.SUPERHEATING_ELEMENT, TileEntitySuperheatingElement::new).serverTicker(TileEntityMekanism::tickServer).build();
        TELEPORTER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.TELEPORTER, TileEntityTeleporter::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        THERMAL_EVAPORATION_BLOCK = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.THERMAL_EVAPORATION_BLOCK, TileEntityThermalEvaporationBlock::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        THERMAL_EVAPORATION_CONTROLLER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, TileEntityThermalEvaporationController::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        THERMAL_EVAPORATION_VALVE = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.THERMAL_EVAPORATION_VALVE, TileEntityThermalEvaporationValve::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        RADIOACTIVE_WASTE_BARREL = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.RADIOACTIVE_WASTE_BARREL, TileEntityRadioactiveWasteBarrel::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        INDUSTRIAL_ALARM = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.INDUSTRIAL_ALARM, TileEntityIndustrialAlarm::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).build();
        ANTIPROTONIC_NUCLEOSYNTHESIZER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER, TileEntityAntiprotonicNucleosynthesizer::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        PIGMENT_EXTRACTOR = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PIGMENT_EXTRACTOR, TileEntityPigmentExtractor::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        PIGMENT_MIXER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PIGMENT_MIXER, TileEntityPigmentMixer::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        PAINTING_MACHINE = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.PAINTING_MACHINE, TileEntityPaintingMachine::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        SPS_CASING = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.SPS_CASING, TileEntitySPSCasing::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        SPS_PORT = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.SPS_PORT, TileEntitySPSPort::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        SUPERCHARGED_COIL = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.SUPERCHARGED_COIL, TileEntitySuperchargedCoil::new).serverTicker(TileEntityMekanism::tickServer).build();
        DIMENSIONAL_STABILIZER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.DIMENSIONAL_STABILIZER, TileEntityDimensionalStabilizer::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        QIO_DRIVE_ARRAY = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.QIO_DRIVE_ARRAY, TileEntityQIODriveArray::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        QIO_DASHBOARD = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.QIO_DASHBOARD, TileEntityQIODashboard::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        QIO_IMPORTER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.QIO_IMPORTER, TileEntityQIOImporter::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        QIO_EXPORTER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.QIO_EXPORTER, TileEntityQIOExporter::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        QIO_REDSTONE_ADAPTER = TILE_ENTITY_TYPES.mekBuilder(MekanismBlocks.QIO_REDSTONE_ADAPTER, TileEntityQIORedstoneAdapter::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        DIVERSION_TRANSPORTER = MekanismTileEntityTypes.registerDiversionTransporter();
        RESTRICTIVE_TRANSPORTER = MekanismTileEntityTypes.registerTransporter(MekanismBlocks.RESTRICTIVE_TRANSPORTER, TileEntityRestrictiveTransporter::new);
        BASIC_LOGISTICAL_TRANSPORTER = MekanismTileEntityTypes.registerTransporter(MekanismBlocks.BASIC_LOGISTICAL_TRANSPORTER, TileEntityLogisticalTransporter::new);
        ADVANCED_LOGISTICAL_TRANSPORTER = MekanismTileEntityTypes.registerTransporter(MekanismBlocks.ADVANCED_LOGISTICAL_TRANSPORTER, TileEntityLogisticalTransporter::new);
        ELITE_LOGISTICAL_TRANSPORTER = MekanismTileEntityTypes.registerTransporter(MekanismBlocks.ELITE_LOGISTICAL_TRANSPORTER, TileEntityLogisticalTransporter::new);
        ULTIMATE_LOGISTICAL_TRANSPORTER = MekanismTileEntityTypes.registerTransporter(MekanismBlocks.ULTIMATE_LOGISTICAL_TRANSPORTER, TileEntityLogisticalTransporter::new);
        BASIC_MECHANICAL_PIPE = MekanismTileEntityTypes.registerPipe(MekanismBlocks.BASIC_MECHANICAL_PIPE);
        ADVANCED_MECHANICAL_PIPE = MekanismTileEntityTypes.registerPipe(MekanismBlocks.ADVANCED_MECHANICAL_PIPE);
        ELITE_MECHANICAL_PIPE = MekanismTileEntityTypes.registerPipe(MekanismBlocks.ELITE_MECHANICAL_PIPE);
        ULTIMATE_MECHANICAL_PIPE = MekanismTileEntityTypes.registerPipe(MekanismBlocks.ULTIMATE_MECHANICAL_PIPE);
        BASIC_PRESSURIZED_TUBE = MekanismTileEntityTypes.registerTube(MekanismBlocks.BASIC_PRESSURIZED_TUBE);
        ADVANCED_PRESSURIZED_TUBE = MekanismTileEntityTypes.registerTube(MekanismBlocks.ADVANCED_PRESSURIZED_TUBE);
        ELITE_PRESSURIZED_TUBE = MekanismTileEntityTypes.registerTube(MekanismBlocks.ELITE_PRESSURIZED_TUBE);
        ULTIMATE_PRESSURIZED_TUBE = MekanismTileEntityTypes.registerTube(MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE);
        BASIC_THERMODYNAMIC_CONDUCTOR = MekanismTileEntityTypes.registerConductor(MekanismBlocks.BASIC_THERMODYNAMIC_CONDUCTOR);
        ADVANCED_THERMODYNAMIC_CONDUCTOR = MekanismTileEntityTypes.registerConductor(MekanismBlocks.ADVANCED_THERMODYNAMIC_CONDUCTOR);
        ELITE_THERMODYNAMIC_CONDUCTOR = MekanismTileEntityTypes.registerConductor(MekanismBlocks.ELITE_THERMODYNAMIC_CONDUCTOR);
        ULTIMATE_THERMODYNAMIC_CONDUCTOR = MekanismTileEntityTypes.registerConductor(MekanismBlocks.ULTIMATE_THERMODYNAMIC_CONDUCTOR);
        BASIC_UNIVERSAL_CABLE = MekanismTileEntityTypes.registerCable(MekanismBlocks.BASIC_UNIVERSAL_CABLE);
        ADVANCED_UNIVERSAL_CABLE = MekanismTileEntityTypes.registerCable(MekanismBlocks.ADVANCED_UNIVERSAL_CABLE);
        ELITE_UNIVERSAL_CABLE = MekanismTileEntityTypes.registerCable(MekanismBlocks.ELITE_UNIVERSAL_CABLE);
        ULTIMATE_UNIVERSAL_CABLE = MekanismTileEntityTypes.registerCable(MekanismBlocks.ULTIMATE_UNIVERSAL_CABLE);
        BASIC_ENERGY_CUBE = MekanismTileEntityTypes.registerEnergyCube(MekanismBlocks.BASIC_ENERGY_CUBE);
        ADVANCED_ENERGY_CUBE = MekanismTileEntityTypes.registerEnergyCube(MekanismBlocks.ADVANCED_ENERGY_CUBE);
        ELITE_ENERGY_CUBE = MekanismTileEntityTypes.registerEnergyCube(MekanismBlocks.ELITE_ENERGY_CUBE);
        ULTIMATE_ENERGY_CUBE = MekanismTileEntityTypes.registerEnergyCube(MekanismBlocks.ULTIMATE_ENERGY_CUBE);
        CREATIVE_ENERGY_CUBE = MekanismTileEntityTypes.registerEnergyCube(MekanismBlocks.CREATIVE_ENERGY_CUBE);
        BASIC_CHEMICAL_TANK = MekanismTileEntityTypes.registerChemicalTank(MekanismBlocks.BASIC_CHEMICAL_TANK);
        ADVANCED_CHEMICAL_TANK = MekanismTileEntityTypes.registerChemicalTank(MekanismBlocks.ADVANCED_CHEMICAL_TANK);
        ELITE_CHEMICAL_TANK = MekanismTileEntityTypes.registerChemicalTank(MekanismBlocks.ELITE_CHEMICAL_TANK);
        ULTIMATE_CHEMICAL_TANK = MekanismTileEntityTypes.registerChemicalTank(MekanismBlocks.ULTIMATE_CHEMICAL_TANK);
        CREATIVE_CHEMICAL_TANK = MekanismTileEntityTypes.registerChemicalTank(MekanismBlocks.CREATIVE_CHEMICAL_TANK);
        BASIC_FLUID_TANK = MekanismTileEntityTypes.registerFluidTank(MekanismBlocks.BASIC_FLUID_TANK);
        ADVANCED_FLUID_TANK = MekanismTileEntityTypes.registerFluidTank(MekanismBlocks.ADVANCED_FLUID_TANK);
        ELITE_FLUID_TANK = MekanismTileEntityTypes.registerFluidTank(MekanismBlocks.ELITE_FLUID_TANK);
        ULTIMATE_FLUID_TANK = MekanismTileEntityTypes.registerFluidTank(MekanismBlocks.ULTIMATE_FLUID_TANK);
        CREATIVE_FLUID_TANK = MekanismTileEntityTypes.registerFluidTank(MekanismBlocks.CREATIVE_FLUID_TANK);
        BASIC_BIN = MekanismTileEntityTypes.registerBin(MekanismBlocks.BASIC_BIN);
        ADVANCED_BIN = MekanismTileEntityTypes.registerBin(MekanismBlocks.ADVANCED_BIN);
        ELITE_BIN = MekanismTileEntityTypes.registerBin(MekanismBlocks.ELITE_BIN);
        ULTIMATE_BIN = MekanismTileEntityTypes.registerBin(MekanismBlocks.ULTIMATE_BIN);
        CREATIVE_BIN = MekanismTileEntityTypes.registerBin(MekanismBlocks.CREATIVE_BIN);
        BASIC_INDUCTION_CELL = TILE_ENTITY_TYPES.builder(MekanismBlocks.BASIC_INDUCTION_CELL, (pos, state) -> new TileEntityInductionCell(MekanismBlocks.BASIC_INDUCTION_CELL, pos, state)).build();
        ADVANCED_INDUCTION_CELL = TILE_ENTITY_TYPES.builder(MekanismBlocks.ADVANCED_INDUCTION_CELL, (pos, state) -> new TileEntityInductionCell(MekanismBlocks.ADVANCED_INDUCTION_CELL, pos, state)).build();
        ELITE_INDUCTION_CELL = TILE_ENTITY_TYPES.builder(MekanismBlocks.ELITE_INDUCTION_CELL, (pos, state) -> new TileEntityInductionCell(MekanismBlocks.ELITE_INDUCTION_CELL, pos, state)).build();
        ULTIMATE_INDUCTION_CELL = TILE_ENTITY_TYPES.builder(MekanismBlocks.ULTIMATE_INDUCTION_CELL, (pos, state) -> new TileEntityInductionCell(MekanismBlocks.ULTIMATE_INDUCTION_CELL, pos, state)).build();
        BASIC_INDUCTION_PROVIDER = TILE_ENTITY_TYPES.builder(MekanismBlocks.BASIC_INDUCTION_PROVIDER, (pos, state) -> new TileEntityInductionProvider(MekanismBlocks.BASIC_INDUCTION_PROVIDER, pos, state)).build();
        ADVANCED_INDUCTION_PROVIDER = TILE_ENTITY_TYPES.builder(MekanismBlocks.ADVANCED_INDUCTION_PROVIDER, (pos, state) -> new TileEntityInductionProvider(MekanismBlocks.ADVANCED_INDUCTION_PROVIDER, pos, state)).build();
        ELITE_INDUCTION_PROVIDER = TILE_ENTITY_TYPES.builder(MekanismBlocks.ELITE_INDUCTION_PROVIDER, (pos, state) -> new TileEntityInductionProvider(MekanismBlocks.ELITE_INDUCTION_PROVIDER, pos, state)).build();
        ULTIMATE_INDUCTION_PROVIDER = TILE_ENTITY_TYPES.builder(MekanismBlocks.ULTIMATE_INDUCTION_PROVIDER, (pos, state) -> new TileEntityInductionProvider(MekanismBlocks.ULTIMATE_INDUCTION_PROVIDER, pos, state)).build();
    }

    @FunctionalInterface
    private static interface BlockEntityFactory<BE extends BlockEntity> {
        public BE create(IBlockProvider var1, BlockPos var2, BlockState var3);
    }
}

