/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.robit.RobitSkin;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.attachments.BlockData;
import mekanism.common.attachments.FilterAware;
import mekanism.common.attachments.FormulaAttachment;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.attachments.LockData;
import mekanism.common.attachments.OverflowAware;
import mekanism.common.attachments.StabilizedChunks;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.chemical.AttachedChemicals;
import mekanism.common.attachments.containers.energy.AttachedEnergy;
import mekanism.common.attachments.containers.fluid.AttachedFluids;
import mekanism.common.attachments.containers.heat.AttachedHeat;
import mekanism.common.attachments.containers.item.AttachedItems;
import mekanism.common.attachments.qio.DriveContents;
import mekanism.common.attachments.qio.DriveMetadata;
import mekanism.common.attachments.qio.PortableDashboardContents;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.impl.DataComponentDeferredRegister;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MekanismDataComponents {
    public static final DataComponentDeferredRegister DATA_COMPONENTS = new DataComponentDeferredRegister("mekanism");
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<ModuleContainer>> MODULE_CONTAINER = DATA_COMPONENTS.simple("module_container", builder -> builder.persistent(ModuleContainer.CODEC).networkSynchronized(ModuleContainer.STREAM_CODEC).cacheEncoding());
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<AttachedEnergy>> ATTACHED_ENERGY = DATA_COMPONENTS.simple("energy", builder -> builder.persistent(AttachedEnergy.CODEC).networkSynchronized(AttachedEnergy.STREAM_CODEC).cacheEncoding());
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<AttachedItems>> ATTACHED_ITEMS = DATA_COMPONENTS.simple("items", builder -> builder.persistent(AttachedItems.CODEC).networkSynchronized(AttachedItems.STREAM_CODEC).cacheEncoding());
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<AttachedFluids>> ATTACHED_FLUIDS = DATA_COMPONENTS.simple("fluids", builder -> builder.persistent(AttachedFluids.CODEC).networkSynchronized(AttachedFluids.STREAM_CODEC).cacheEncoding());
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<AttachedChemicals>> ATTACHED_CHEMICALS = DATA_COMPONENTS.simple("chemicals", builder -> builder.persistent(AttachedChemicals.CODEC).networkSynchronized(AttachedChemicals.STREAM_CODEC).cacheEncoding());
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<AttachedHeat>> ATTACHED_HEAT;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<ItemAtomicDisassembler.DisassemblerMode>> DISASSEMBLER_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<ItemConfigurator.ConfiguratorMode>> CONFIGURATOR_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<ItemFlamethrower.FlamethrowerMode>> FLAMETHROWER_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<ItemFreeRunners.FreeRunnerMode>> FREE_RUNNER_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<IJetpackItem.JetpackMode>> JETPACK_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<IFluidContainerManager.ContainerEditMode>> EDIT_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<TileEntityChemicalTank.GasMode>> DUMP_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<TileEntityChemicalTank.GasMode>> SECONDARY_DUMP_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<IRedstoneControl.RedstoneControl>> REDSTONE_CONTROL;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<TileEntityLaserAmplifier.RedstoneOutput>> REDSTONE_OUTPUT;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DEFAULT_MANUALLY_SELECTED;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SCUBA_TANK_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> ELECTRIC_BOW_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> BUCKET_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> ROTARY_MODE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> AUTO;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SORTING;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> EJECT;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> PULL;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> ROUND_ROBIN;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SINGLE_ITEM;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> FUZZY;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SILK_TOUCH;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> INVERSE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> INVERSE_REQUIRES_REPLACE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> FROM_RECIPE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> INSERT_INTO_FREQUENCY;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Integer>> RADIUS;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Integer>> MIN_Y;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Integer>> MAX_Y;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<OverflowAware>> OVERFLOW_AWARE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Item>> REPLACE_STACK;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Integer>> DELAY;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Long>> MIN_THRESHOLD;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Long>> MAX_THRESHOLD;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Long>> ENERGY_USAGE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Long>> LONG_AMOUNT;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<HashedItem>> ITEM_TARGET;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<DriveMetadata>> DRIVE_METADATA;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<DriveContents>> DRIVE_CONTENTS;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<StabilizedChunks>> STABILIZER_CHUNKS;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<Component>> ROBIT_NAME;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<ResourceKey<RobitSkin>>> ROBIT_SKIN;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<UUID>> PERSONAL_STORAGE_ID;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<LockData>> LOCK;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<FormulaAttachment>> FORMULA_HOLDER;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<CompoundTag>> CONFIGURATION_DATA;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<BlockData>> BLOCK_DATA;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<EnumColor>> COLOR;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<UUID>> OWNER;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<SecurityMode>> SECURITY;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<AttachedEjector>> EJECTOR;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<AttachedSideConfig>> SIDE_CONFIG;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<UpgradeAware>> UPGRADES;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<FilterAware>> FILTER_AWARE;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<FrequencyAware<TeleporterFrequency>>> TELEPORTER_FREQUENCY;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<FrequencyAware<InventoryFrequency>>> INVENTORY_FREQUENCY;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<FrequencyAware<QIOFrequency>>> QIO_FREQUENCY;
    public static final MekanismDeferredHolder<DataComponentType<?>, DataComponentType<PortableDashboardContents>> QIO_DASHBOARD;

    private MekanismDataComponents() {
    }

    @Nullable
    public static <FREQ extends Frequency> DataComponentType<FrequencyAware<FREQ>> getFrequencyComponent(FrequencyType<FREQ> freq) {
        if (freq == FrequencyType.TELEPORTER) {
            return (DataComponentType)TELEPORTER_FREQUENCY.value();
        }
        if (freq == FrequencyType.INVENTORY) {
            return (DataComponentType)INVENTORY_FREQUENCY.value();
        }
        if (freq == FrequencyType.QIO) {
            return (DataComponentType)QIO_FREQUENCY.value();
        }
        return null;
    }

    static {
        DATA_COMPONENTS.addAlias(Mekanism.rl("gases"), Mekanism.rl(ATTACHED_CHEMICALS.getName()));
        DATA_COMPONENTS.addAlias(Mekanism.rl("infuse_types"), Mekanism.rl(ATTACHED_CHEMICALS.getName()));
        DATA_COMPONENTS.addAlias(Mekanism.rl("pigments"), Mekanism.rl(ATTACHED_CHEMICALS.getName()));
        DATA_COMPONENTS.addAlias(Mekanism.rl("slurries"), Mekanism.rl(ATTACHED_CHEMICALS.getName()));
        ATTACHED_HEAT = DATA_COMPONENTS.simple("heat_data", builder -> builder.persistent(AttachedHeat.CODEC).networkSynchronized(AttachedHeat.STREAM_CODEC).cacheEncoding());
        DISASSEMBLER_MODE = DATA_COMPONENTS.simple("disassembler_mode", builder -> builder.persistent(ItemAtomicDisassembler.DisassemblerMode.CODEC).networkSynchronized(ItemAtomicDisassembler.DisassemblerMode.STREAM_CODEC));
        CONFIGURATOR_MODE = DATA_COMPONENTS.simple("configurator_mode", builder -> builder.persistent(ItemConfigurator.ConfiguratorMode.CODEC).networkSynchronized(ItemConfigurator.ConfiguratorMode.STREAM_CODEC));
        FLAMETHROWER_MODE = DATA_COMPONENTS.simple("flamethrower_mode", builder -> builder.persistent(ItemFlamethrower.FlamethrowerMode.CODEC).networkSynchronized(ItemFlamethrower.FlamethrowerMode.STREAM_CODEC));
        FREE_RUNNER_MODE = DATA_COMPONENTS.simple("free_runner_mode", builder -> builder.persistent(ItemFreeRunners.FreeRunnerMode.CODEC).networkSynchronized(ItemFreeRunners.FreeRunnerMode.STREAM_CODEC));
        JETPACK_MODE = DATA_COMPONENTS.simple("jetpack_mode", builder -> builder.persistent(IJetpackItem.JetpackMode.CODEC).networkSynchronized(IJetpackItem.JetpackMode.STREAM_CODEC));
        EDIT_MODE = DATA_COMPONENTS.simple("edit_mode", builder -> builder.persistent(IFluidContainerManager.ContainerEditMode.CODEC).networkSynchronized(IFluidContainerManager.ContainerEditMode.STREAM_CODEC));
        DUMP_MODE = DATA_COMPONENTS.simple("dump_mode", builder -> builder.persistent(TileEntityChemicalTank.GasMode.CODEC).networkSynchronized(TileEntityChemicalTank.GasMode.STREAM_CODEC));
        SECONDARY_DUMP_MODE = DATA_COMPONENTS.simple("secondary_dump_mode", builder -> builder.persistent(TileEntityChemicalTank.GasMode.CODEC).networkSynchronized(TileEntityChemicalTank.GasMode.STREAM_CODEC));
        REDSTONE_CONTROL = DATA_COMPONENTS.simple("redstone_control", builder -> builder.persistent(IRedstoneControl.RedstoneControl.CODEC).networkSynchronized(IRedstoneControl.RedstoneControl.STREAM_CODEC));
        REDSTONE_OUTPUT = DATA_COMPONENTS.simple("redstone_output", builder -> builder.persistent(TileEntityLaserAmplifier.RedstoneOutput.CODEC).networkSynchronized(TileEntityLaserAmplifier.RedstoneOutput.STREAM_CODEC));
        DEFAULT_MANUALLY_SELECTED = DATA_COMPONENTS.registerBoolean("default_manually_selected");
        SCUBA_TANK_MODE = DATA_COMPONENTS.registerBoolean("scuba_tank_mode");
        ELECTRIC_BOW_MODE = DATA_COMPONENTS.registerBoolean("electric_bow_mode");
        BUCKET_MODE = DATA_COMPONENTS.registerBoolean("bucket_mode");
        ROTARY_MODE = DATA_COMPONENTS.registerBoolean("rotary_mode");
        AUTO = DATA_COMPONENTS.registerBoolean("auto");
        SORTING = DATA_COMPONENTS.registerBoolean("sorting");
        EJECT = DATA_COMPONENTS.registerBoolean("eject");
        PULL = DATA_COMPONENTS.registerBoolean("pull");
        ROUND_ROBIN = DATA_COMPONENTS.registerBoolean("round_robin");
        SINGLE_ITEM = DATA_COMPONENTS.registerBoolean("single");
        FUZZY = DATA_COMPONENTS.registerBoolean("fuzzy");
        SILK_TOUCH = DATA_COMPONENTS.registerBoolean("silk_touch");
        INVERSE = DATA_COMPONENTS.registerBoolean("inverse");
        INVERSE_REQUIRES_REPLACE = DATA_COMPONENTS.registerBoolean("inverse_replace");
        FROM_RECIPE = DATA_COMPONENTS.registerBoolean("from_recipe");
        INSERT_INTO_FREQUENCY = DATA_COMPONENTS.registerBoolean("insert_into_frequency");
        RADIUS = DATA_COMPONENTS.registerNonNegativeInt("radius");
        MIN_Y = DATA_COMPONENTS.registerInt("min_y");
        MAX_Y = DATA_COMPONENTS.registerInt("max_y");
        OVERFLOW_AWARE = DATA_COMPONENTS.simple("overflow", builder -> builder.persistent(OverflowAware.CODEC).networkSynchronized(OverflowAware.STREAM_CODEC).cacheEncoding());
        REPLACE_STACK = DATA_COMPONENTS.simple("replace_stack", builder -> builder.persistent(BuiltInRegistries.ITEM.byNameCodec()).networkSynchronized(ByteBufCodecs.registry((ResourceKey)Registries.ITEM)));
        DELAY = DATA_COMPONENTS.registerInt("delay");
        MIN_THRESHOLD = DATA_COMPONENTS.registerNonNegativeLong("min_threshold");
        MAX_THRESHOLD = DATA_COMPONENTS.registerNonNegativeLong("max_threshold");
        ENERGY_USAGE = DATA_COMPONENTS.registerNonNegativeLong("energy_usage");
        LONG_AMOUNT = DATA_COMPONENTS.registerNonNegativeLong("long_amount");
        ITEM_TARGET = DATA_COMPONENTS.simple("item_target", builder -> builder.persistent(HashedItem.CODEC).networkSynchronized(HashedItem.STREAM_CODEC));
        DRIVE_METADATA = DATA_COMPONENTS.simple("drive_metadata", builder -> builder.persistent(DriveMetadata.CODEC).networkSynchronized(DriveMetadata.STREAM_CODEC));
        DRIVE_CONTENTS = DATA_COMPONENTS.simple("drive_contents", builder -> builder.persistent(DriveContents.CODEC).networkSynchronized(DriveContents.STREAM_CODEC).cacheEncoding());
        STABILIZER_CHUNKS = DATA_COMPONENTS.simple("stabilzer_chunks", builder -> builder.persistent(StabilizedChunks.CODEC).networkSynchronized(StabilizedChunks.STREAM_CODEC));
        ROBIT_NAME = DATA_COMPONENTS.registerComponent("robit_name");
        ROBIT_SKIN = DATA_COMPONENTS.registerResourceKey("robit_skin", MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
        PERSONAL_STORAGE_ID = DATA_COMPONENTS.registerUUID("storage_id");
        LOCK = DATA_COMPONENTS.simple("lock", builder -> builder.persistent(LockData.CODEC).networkSynchronized(LockData.STREAM_CODEC));
        FORMULA_HOLDER = DATA_COMPONENTS.simple("formula", builder -> builder.persistent(FormulaAttachment.CODEC).networkSynchronized(FormulaAttachment.STREAM_CODEC));
        CONFIGURATION_DATA = DATA_COMPONENTS.simple("configuration_data", builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.TRUSTED_COMPOUND_TAG));
        BLOCK_DATA = DATA_COMPONENTS.simple("block_data", builder -> builder.persistent(BlockData.CODEC).networkSynchronized(BlockData.STREAM_CODEC));
        COLOR = DATA_COMPONENTS.simple("color", builder -> builder.persistent(EnumColor.CODEC).networkSynchronized(EnumColor.STREAM_CODEC));
        OWNER = DATA_COMPONENTS.registerUUID("owner");
        SECURITY = DATA_COMPONENTS.simple("security", builder -> builder.persistent(SecurityMode.CODEC).networkSynchronized(SecurityMode.STREAM_CODEC));
        EJECTOR = DATA_COMPONENTS.simple("ejector", builder -> builder.persistent(AttachedEjector.CODEC).networkSynchronized(AttachedEjector.STREAM_CODEC).cacheEncoding());
        SIDE_CONFIG = DATA_COMPONENTS.simple("side_config", builder -> builder.persistent(AttachedSideConfig.CODEC).networkSynchronized(AttachedSideConfig.STREAM_CODEC).cacheEncoding());
        UPGRADES = DATA_COMPONENTS.simple("upgrades", builder -> builder.persistent(UpgradeAware.CODEC).networkSynchronized(UpgradeAware.STREAM_CODEC).cacheEncoding());
        FILTER_AWARE = DATA_COMPONENTS.simple("filters", builder -> builder.persistent(FilterAware.CODEC).networkSynchronized(FilterAware.STREAM_CODEC).cacheEncoding());
        TELEPORTER_FREQUENCY = DATA_COMPONENTS.registerFrequencyAware("teleporter_frequency", () -> FrequencyType.TELEPORTER);
        INVENTORY_FREQUENCY = DATA_COMPONENTS.registerFrequencyAware("inventory_frequency", () -> FrequencyType.INVENTORY);
        QIO_FREQUENCY = DATA_COMPONENTS.registerFrequencyAware("qio_frequency", () -> FrequencyType.QIO);
        QIO_DASHBOARD = DATA_COMPONENTS.simple("qio_dashboard", builder -> builder.persistent(PortableDashboardContents.CODEC).networkSynchronized(PortableDashboardContents.STREAM_CODEC).cacheEncoding());
    }
}

