/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.ChemicalConstants;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registration.impl.ChemicalDeferredRegister;
import mekanism.common.registration.impl.DeferredChemical;
import mekanism.common.registration.impl.SlurryRegistryObject;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.util.EnumUtils;

public class MekanismChemicals {
    public static final ChemicalDeferredRegister CHEMICALS = new ChemicalDeferredRegister("mekanism");
    public static final DeferredChemical<Chemical> BIO = CHEMICALS.register("bio", Mekanism.rl("infuse_type/bio"), 5916208);
    public static final DeferredChemical<Chemical> FUNGI = CHEMICALS.register("fungi", Mekanism.rl("infuse_type/fungi"), 7628138);
    public static final DeferredChemical<Chemical> TIN = CHEMICALS.registerInfuse("tin", 0xCCCCD9);
    public static final DeferredChemical<Chemical> GOLD = CHEMICALS.registerInfuse("gold", 15912295);
    public static final DeferredChemical<Chemical> REFINED_OBSIDIAN = CHEMICALS.registerInfuse("refined_obsidian", 8126701);
    public static final DeferredChemical<Chemical> DIAMOND = CHEMICALS.registerInfuse("diamond", 7138776);
    public static final DeferredChemical<Chemical> REDSTONE = CHEMICALS.registerInfuse("redstone", 11732229);
    public static final DeferredChemical<Chemical> CARBON = CHEMICALS.registerInfuse("carbon", 0x2C2C2C);
    public static final DeferredChemical<Chemical> HYDROGEN = CHEMICALS.registerGas(ChemicalConstants.HYDROGEN, new ChemicalAttributes.Fuel(() -> 1, MekanismConfig.general.FROM_H2));
    public static final DeferredChemical<Chemical> OXYGEN = CHEMICALS.registerGas(ChemicalConstants.OXYGEN, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> STEAM = CHEMICALS.register("steam", () -> new Chemical(ChemicalBuilder.builder(Mekanism.rl("liquid/steam")).gaseous()));
    public static final DeferredChemical<Chemical> WATER_VAPOR = CHEMICALS.register("water_vapor", () -> new Chemical(ChemicalBuilder.builder(Mekanism.rl("liquid/steam")).gaseous()));
    public static final DeferredChemical<Chemical> CHLORINE = CHEMICALS.register(ChemicalConstants.CHLORINE, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> SULFUR_DIOXIDE = CHEMICALS.registerGas(ChemicalConstants.SULFUR_DIOXIDE, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> SULFUR_TRIOXIDE = CHEMICALS.registerGas(ChemicalConstants.SULFUR_TRIOXIDE, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> SULFURIC_ACID = CHEMICALS.register(ChemicalConstants.SULFURIC_ACID, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> HYDROGEN_CHLORIDE = CHEMICALS.registerGas(ChemicalConstants.HYDROGEN_CHLORIDE, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> HYDROFLUORIC_ACID = CHEMICALS.register(ChemicalConstants.HYDROFLUORIC_ACID, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> URANIUM_OXIDE = CHEMICALS.register(ChemicalConstants.URANIUM_OXIDE, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> URANIUM_HEXAFLUORIDE = CHEMICALS.register(ChemicalConstants.URANIUM_HEXAFLUORIDE, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> ETHENE = CHEMICALS.registerGas(ChemicalConstants.ETHENE, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> SODIUM = CHEMICALS.register(ChemicalConstants.SODIUM, Coolants.SODIUM_COOLANT);
    public static final DeferredChemical<Chemical> SUPERHEATED_SODIUM = CHEMICALS.register(ChemicalConstants.SUPERHEATED_SODIUM, Coolants.HEATED_SODIUM_COOLANT);
    public static final DeferredChemical<Chemical> BRINE = CHEMICALS.registerGas("brine", 16707484, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> LITHIUM = CHEMICALS.register(ChemicalConstants.LITHIUM, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> OSMIUM = CHEMICALS.register("osmium", 5422538, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> FISSILE_FUEL = CHEMICALS.register("fissile_fuel", 3027759, new ChemicalAttribute[0]);
    public static final DeferredChemical<Chemical> NUCLEAR_WASTE = CHEMICALS.register("nuclear_waste", 5194026, new ChemicalAttributes.Radiation(0.01));
    public static final DeferredChemical<Chemical> SPENT_NUCLEAR_WASTE = CHEMICALS.register("spent_nuclear_waste", 2498581, new ChemicalAttributes.Radiation(0.01));
    public static final DeferredChemical<Chemical> PLUTONIUM = CHEMICALS.register("plutonium", 2068892, new ChemicalAttributes.Radiation(0.02));
    public static final DeferredChemical<Chemical> POLONIUM = CHEMICALS.register("polonium", 1810043, new ChemicalAttributes.Radiation(0.05));
    public static final DeferredChemical<Chemical> ANTIMATTER = CHEMICALS.register("antimatter", 10773683, new ChemicalAttribute[0]);
    public static Map<EnumColor, IChemicalProvider> PIGMENT_COLOR_LOOKUP = new EnumMap<EnumColor, IChemicalProvider>(EnumColor.class);
    public static final Map<PrimaryResource, SlurryRegistryObject<Chemical, Chemical>> PROCESSED_RESOURCES = new LinkedHashMap<PrimaryResource, SlurryRegistryObject<Chemical, Chemical>>();

    private MekanismChemicals() {
    }

    private static DeferredChemical<Chemical> registerPigment(EnumColor color) {
        int[] rgb = color.getRgbCode();
        int tint = rgb[0] << 16;
        tint |= rgb[1] << 8;
        return CHEMICALS.registerPigment(color.getRegistryPrefix(), tint |= rgb[2]);
    }

    static {
        for (EnumColor enumColor : EnumUtils.COLORS) {
            PIGMENT_COLOR_LOOKUP.put(enumColor, MekanismChemicals.registerPigment(enumColor));
        }
        for (Enum enum_ : EnumUtils.PRIMARY_RESOURCES) {
            PROCESSED_RESOURCES.put((PrimaryResource)enum_, CHEMICALS.registerSlurry((PrimaryResource)enum_));
        }
    }

    public static class Coolants {
        public static final ChemicalAttributes.CooledCoolant SODIUM_COOLANT = new ChemicalAttributes.CooledCoolant(() -> (Chemical)SUPERHEATED_SODIUM.get(), 5.0, 1.0);
        public static final ChemicalAttributes.HeatedCoolant HEATED_SODIUM_COOLANT = new ChemicalAttributes.HeatedCoolant(() -> (Chemical)SODIUM.get(), 5.0, 1.0);

        private Coolants() {
        }
    }
}

