/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@NothingNullByDefault
public final class DataMapTypeRegister {
    private final String namespace;
    private final List<DataMapType<?, ?>> types = new ArrayList();

    public DataMapTypeRegister(String namespace) {
        this.namespace = namespace;
    }

    public <R, T> DataMapType<R, T> register(String name, ResourceKey<Registry<R>> registryKey, Codec<T> codec, UnaryOperator<DataMapType.Builder<T, R>> builder) {
        DataMapType type = ((DataMapType.Builder)builder.apply(DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name), registryKey, codec))).build();
        this.types.add(type);
        return type;
    }

    public <R, T> DataMapType<R, T> registerSimple(String name, ResourceKey<Registry<R>> registryKey, Codec<T> codec) {
        return this.register(name, registryKey, codec, UnaryOperator.identity());
    }

    public void register(IEventBus bus) {
        bus.addListener(RegisterDataMapTypesEvent.class, event -> this.types.forEach(arg_0 -> ((RegisterDataMapTypesEvent)event).register(arg_0)));
    }
}

