/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import java.util.Optional;
import java.util.function.BiFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.basic.BasicRotaryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.recipe.ingredients.creator.ChemicalStackIngredientCreator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public class RotaryRecipeSerializer
implements RecipeSerializer<BasicRotaryRecipe> {
    private final RecordCodecBuilder<BasicRotaryRecipe, FluidStackIngredient> FLUID_INPUT_FIELD = FluidStackIngredient.CODEC.validate(ingredient -> ingredient == null ? DataResult.error(() -> "Fluid input may not be empty") : DataResult.success((Object)ingredient)).fieldOf("fluid_input").forGetter(BasicRotaryRecipe::getFluidInputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, FluidStack> FLUID_OUTPUT_FIELD = FluidStack.CODEC.fieldOf("fluid_output").forGetter(BasicRotaryRecipe::getFluidOutputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, ChemicalStackIngredient> CHEMICAL_INPUT_FIELD = ChemicalStackIngredientCreator.INSTANCE.codec().validate(ingredient -> ingredient == null ? DataResult.error(() -> "Chemical input may not be empty") : DataResult.success((Object)ingredient)).fieldOf("chemical_input").forGetter(BasicRotaryRecipe::getChemicalInputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, ChemicalStack> CHEMICAL_OUTPUT_FIELD = ChemicalStack.CODEC.fieldOf("chemical_output").forGetter(BasicRotaryRecipe::getChemicalOutputRaw);
    private final StreamCodec<RegistryFriendlyByteBuf, BasicRotaryRecipe> streamCodec;
    private final MapCodec<BasicRotaryRecipe> codec = NeoForgeExtraCodecs.withAlternative((MapCodec)RecordCodecBuilder.mapCodec(i -> i.group(this.FLUID_INPUT_FIELD, this.CHEMICAL_INPUT_FIELD, this.CHEMICAL_OUTPUT_FIELD, this.FLUID_OUTPUT_FIELD).apply((Applicative)i, bothWaysFactory)), (MapCodec)NeoForgeExtraCodecs.withAlternative((MapCodec)RecordCodecBuilder.mapCodec(i -> i.group(this.FLUID_INPUT_FIELD, this.CHEMICAL_OUTPUT_FIELD).apply((Applicative)i, toChemicalFactory)), (MapCodec)RecordCodecBuilder.mapCodec(i -> i.group(this.CHEMICAL_INPUT_FIELD, this.FLUID_OUTPUT_FIELD).apply((Applicative)i, toFluidFactory))));

    public RotaryRecipeSerializer(Function4<FluidStackIngredient, ChemicalStackIngredient, ChemicalStack, FluidStack, BasicRotaryRecipe> bothWaysFactory, BiFunction<FluidStackIngredient, ChemicalStack, BasicRotaryRecipe> toChemicalFactory, BiFunction<ChemicalStackIngredient, FluidStack, BasicRotaryRecipe> toFluidFactory) {
        this.streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(FluidToChemical.STREAM_CODEC), recipe -> recipe.hasFluidToChemical() ? Optional.of(new FluidToChemical((BasicRotaryRecipe)recipe)) : Optional.empty(), (StreamCodec)ByteBufCodecs.optional(ChemicalToFluid.STREAM_CODEC), recipe -> recipe.hasChemicalToFluid() ? Optional.of(new ChemicalToFluid((BasicRotaryRecipe)recipe)) : Optional.empty(), (toGas, toFluid) -> {
            if (toGas.isPresent()) {
                FluidToChemical fluidToChemical = (FluidToChemical)toGas.get();
                if (toFluid.isPresent()) {
                    ChemicalToFluid chemicalToFluid = (ChemicalToFluid)toFluid.get();
                    return (BasicRotaryRecipe)bothWaysFactory.apply((Object)fluidToChemical.input(), (Object)chemicalToFluid.input(), (Object)fluidToChemical.output(), (Object)chemicalToFluid.output());
                }
                return (BasicRotaryRecipe)toChemicalFactory.apply(fluidToChemical.input(), fluidToChemical.output());
            }
            if (toFluid.isPresent()) {
                ChemicalToFluid chemicalToFluid = (ChemicalToFluid)toFluid.get();
                return (BasicRotaryRecipe)toFluidFactory.apply(chemicalToFluid.input(), chemicalToFluid.output());
            }
            throw new DecoderException("A recipe got sent with no conversion in either direction.");
        });
    }

    public MapCodec<BasicRotaryRecipe> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BasicRotaryRecipe> streamCodec() {
        return this.streamCodec;
    }

    private record FluidToChemical(FluidStackIngredient input, ChemicalStack output) {
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidToChemical> STREAM_CODEC = StreamCodec.composite(FluidStackIngredient.STREAM_CODEC, FluidToChemical::input, ChemicalStack.STREAM_CODEC, FluidToChemical::output, FluidToChemical::new);

        private FluidToChemical(BasicRotaryRecipe recipe) {
            this(recipe.getFluidInput(), recipe.getChemicalOutputRaw());
        }
    }

    private record ChemicalToFluid(ChemicalStackIngredient input, FluidStack output) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalToFluid> STREAM_CODEC = StreamCodec.composite(IngredientCreatorAccess.chemicalStack().streamCodec(), ChemicalToFluid::input, (StreamCodec)FluidStack.STREAM_CODEC, ChemicalToFluid::output, ChemicalToFluid::new);

        private ChemicalToFluid(BasicRotaryRecipe recipe) {
            this(recipe.getChemicalInput(), recipe.getFluidOutputRaw());
        }
    }
}

