/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function7;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ChemicalToChemicalRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ItemStackChemicalToObjectRecipe;
import mekanism.api.recipes.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.basic.BasicChemicalCrystallizerRecipe;
import mekanism.api.recipes.basic.BasicChemicalDissolutionRecipe;
import mekanism.api.recipes.basic.BasicChemicalToChemicalRecipe;
import mekanism.api.recipes.basic.BasicCombinerRecipe;
import mekanism.api.recipes.basic.BasicElectrolysisRecipe;
import mekanism.api.recipes.basic.BasicFluidToFluidRecipe;
import mekanism.api.recipes.basic.BasicItemStackToEnergyRecipe;
import mekanism.api.recipes.basic.BasicItemStackToItemStackRecipe;
import mekanism.api.recipes.basic.BasicNucleosynthesizingRecipe;
import mekanism.api.recipes.basic.BasicPressurizedReactionRecipe;
import mekanism.api.recipes.basic.BasicWashingRecipe;
import mekanism.api.recipes.basic.IBasicChemicalOutput;
import mekanism.api.recipes.basic.IBasicItemStackOutput;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.recipe.WrappedShapedRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record MekanismRecipeSerializer<RECIPE extends Recipe<?>>(MapCodec<RECIPE> codec, StreamCodec<RegistryFriendlyByteBuf, RECIPE> streamCodec) implements RecipeSerializer<RECIPE>
{
    public static <RECIPE extends WrappedShapedRecipe> MekanismRecipeSerializer<RECIPE> wrapped(Function<ShapedRecipe, RECIPE> wrapper) {
        return new MekanismRecipeSerializer<RECIPE>(RecipeSerializer.SHAPED_RECIPE.codec().xmap(wrapper, WrappedShapedRecipe::getInternal), RecipeSerializer.SHAPED_RECIPE.streamCodec().map(wrapper, WrappedShapedRecipe::getInternal));
    }

    public static <RECIPE extends BasicItemStackToItemStackRecipe> MekanismRecipeSerializer<RECIPE> itemToItem(BiFunction<ItemStackIngredient, ItemStack, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("input").forGetter(BasicItemStackToItemStackRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicItemStackToItemStackRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, BasicItemStackToItemStackRecipe::getInput, (StreamCodec)ItemStack.STREAM_CODEC, BasicItemStackToItemStackRecipe::getOutputRaw, factory));
    }

    public static MekanismRecipeSerializer<BasicChemicalCrystallizerRecipe> crystallizing(BiFunction<ChemicalStackIngredient, ItemStack, BasicChemicalCrystallizerRecipe> factory) {
        return new MekanismRecipeSerializer<BasicChemicalCrystallizerRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("input").forGetter(BasicChemicalCrystallizerRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicChemicalCrystallizerRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(IngredientCreatorAccess.chemicalStack().streamCodec(), BasicChemicalCrystallizerRecipe::getInput, (StreamCodec)ItemStack.STREAM_CODEC, BasicChemicalCrystallizerRecipe::getOutputRaw, factory));
    }

    public static MekanismRecipeSerializer<BasicCombinerRecipe> combining(Function3<ItemStackIngredient, ItemStackIngredient, ItemStack, BasicCombinerRecipe> factory) {
        return new MekanismRecipeSerializer<BasicCombinerRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("main_input").forGetter(CombinerRecipe::getMainInput), (App)ItemStackIngredient.CODEC.fieldOf("extra_input").forGetter(CombinerRecipe::getExtraInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicCombinerRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, BasicCombinerRecipe::getMainInput, ItemStackIngredient.STREAM_CODEC, BasicCombinerRecipe::getExtraInput, (StreamCodec)ItemStack.STREAM_CODEC, BasicCombinerRecipe::getOutputRaw, factory));
    }

    public static <RECIPE extends BasicItemStackToEnergyRecipe> MekanismRecipeSerializer<RECIPE> itemToEnergy(BiFunction<ItemStackIngredient, Long, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("input").forGetter(ItemStackToEnergyRecipe::getInput), (App)SerializerHelper.POSITIVE_NONZERO_LONG_CODEC.fieldOf("output").forGetter(BasicItemStackToEnergyRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, ItemStackToEnergyRecipe::getInput, (StreamCodec)ByteBufCodecs.VAR_LONG, BasicItemStackToEnergyRecipe::getOutputRaw, factory));
    }

    public static <RECIPE extends BasicFluidToFluidRecipe> MekanismRecipeSerializer<RECIPE> fluidToFluid(BiFunction<FluidStackIngredient, FluidStack, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStackIngredient.CODEC.fieldOf("input").forGetter(FluidToFluidRecipe::getInput), (App)FluidStack.CODEC.fieldOf("output").forGetter(BasicFluidToFluidRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(FluidStackIngredient.STREAM_CODEC, FluidToFluidRecipe::getInput, (StreamCodec)FluidStack.STREAM_CODEC, BasicFluidToFluidRecipe::getOutputRaw, factory));
    }

    public static <RECIPE extends BasicChemicalToChemicalRecipe> MekanismRecipeSerializer<RECIPE> chemicalToChemical(BiFunction<ChemicalStackIngredient, ChemicalStack, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("input").forGetter(ChemicalToChemicalRecipe::getInput), (App)ChemicalStack.MAP_CODEC.fieldOf("output").forGetter(BasicChemicalToChemicalRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(IngredientCreatorAccess.chemicalStack().streamCodec(), ChemicalToChemicalRecipe::getInput, ChemicalStack.STREAM_CODEC, BasicChemicalToChemicalRecipe::getOutputRaw, factory));
    }

    public static MekanismRecipeSerializer<BasicWashingRecipe> fluidChemicalToChemical(Function3<FluidStackIngredient, ChemicalStackIngredient, ChemicalStack, BasicWashingRecipe> factory) {
        return new MekanismRecipeSerializer<BasicWashingRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStackIngredient.CODEC.fieldOf("fluid_input").forGetter(FluidChemicalToChemicalRecipe::getFluidInput), (App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("chemical_input").forGetter(FluidChemicalToChemicalRecipe::getChemicalInput), (App)ChemicalStack.CODEC.fieldOf("output").forGetter(BasicWashingRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(FluidStackIngredient.STREAM_CODEC, FluidChemicalToChemicalRecipe::getFluidInput, IngredientCreatorAccess.chemicalStack().streamCodec(), FluidChemicalToChemicalRecipe::getChemicalInput, ChemicalStack.STREAM_CODEC, BasicWashingRecipe::getOutputRaw, factory));
    }

    public static MekanismRecipeSerializer<BasicNucleosynthesizingRecipe> nucleosynthesizing(Function5<ItemStackIngredient, ChemicalStackIngredient, ItemStack, Integer, Boolean, BasicNucleosynthesizingRecipe> factory) {
        return new MekanismRecipeSerializer<BasicNucleosynthesizingRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(ItemStackChemicalToObjectRecipe::getItemInput), (App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("chemical_input").forGetter(ItemStackChemicalToObjectRecipe::getChemicalInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicNucleosynthesizingRecipe::getOutputRaw), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(NucleosynthesizingRecipe::getDuration), (App)Codec.BOOL.fieldOf("per_tick_usage").forGetter(ItemStackChemicalToObjectRecipe::perTickUsage)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, ItemStackChemicalToObjectRecipe::getItemInput, IngredientCreatorAccess.chemicalStack().streamCodec(), ItemStackChemicalToObjectRecipe::getChemicalInput, (StreamCodec)ItemStack.STREAM_CODEC, BasicNucleosynthesizingRecipe::getOutputRaw, (StreamCodec)ByteBufCodecs.VAR_INT, NucleosynthesizingRecipe::getDuration, (StreamCodec)ByteBufCodecs.BOOL, ItemStackChemicalToObjectRecipe::perTickUsage, factory));
    }

    public static MekanismRecipeSerializer<BasicElectrolysisRecipe> separating(Function4<FluidStackIngredient, Long, ChemicalStack, ChemicalStack, BasicElectrolysisRecipe> factory) {
        return new MekanismRecipeSerializer<BasicElectrolysisRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStackIngredient.CODEC.fieldOf("input").forGetter(ElectrolysisRecipe::getInput), (App)SerializerHelper.POSITIVE_NONZERO_LONG_CODEC.optionalFieldOf("energy_multiplier", (Object)1L).forGetter(ElectrolysisRecipe::getEnergyMultiplier), (App)ChemicalStack.MAP_CODEC.fieldOf("left_chemical_output").forGetter(BasicElectrolysisRecipe::getLeftChemicalOutput), (App)ChemicalStack.MAP_CODEC.fieldOf("right_chemical_output").forGetter(BasicElectrolysisRecipe::getRightChemicalOutput)).apply((Applicative)instance, factory)), StreamCodec.composite(FluidStackIngredient.STREAM_CODEC, ElectrolysisRecipe::getInput, (StreamCodec)ByteBufCodecs.VAR_LONG, ElectrolysisRecipe::getEnergyMultiplier, ChemicalStack.STREAM_CODEC, BasicElectrolysisRecipe::getLeftChemicalOutput, ChemicalStack.STREAM_CODEC, BasicElectrolysisRecipe::getRightChemicalOutput, factory));
    }

    public static MekanismRecipeSerializer<BasicChemicalDissolutionRecipe> dissolution(Function4<ItemStackIngredient, ChemicalStackIngredient, ChemicalStack, Boolean, BasicChemicalDissolutionRecipe> factory) {
        return new MekanismRecipeSerializer<BasicChemicalDissolutionRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(ItemStackChemicalToObjectRecipe::getItemInput), (App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("chemical_input").forGetter(ItemStackChemicalToObjectRecipe::getChemicalInput), (App)ChemicalStack.CODEC.fieldOf("output").forGetter(BasicChemicalDissolutionRecipe::getOutputRaw), (App)Codec.BOOL.fieldOf("per_tick_usage").forGetter(BasicChemicalDissolutionRecipe::perTickUsage)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, BasicChemicalDissolutionRecipe::getItemInput, IngredientCreatorAccess.chemicalStack().streamCodec(), BasicChemicalDissolutionRecipe::getChemicalInput, ChemicalStack.STREAM_CODEC, BasicChemicalDissolutionRecipe::getOutputRaw, (StreamCodec)ByteBufCodecs.BOOL, BasicChemicalDissolutionRecipe::perTickUsage, factory));
    }

    public static MekanismRecipeSerializer<BasicPressurizedReactionRecipe> reaction(Function7<ItemStackIngredient, FluidStackIngredient, ChemicalStackIngredient, Long, Integer, ItemStack, ChemicalStack, BasicPressurizedReactionRecipe> factory) {
        return new MekanismRecipeSerializer<BasicPressurizedReactionRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(PressurizedReactionRecipe::getInputSolid), (App)FluidStackIngredient.CODEC.fieldOf("fluid_input").forGetter(PressurizedReactionRecipe::getInputFluid), (App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("chemical_input").forGetter(PressurizedReactionRecipe::getInputChemical), (App)SerializerHelper.POSITIVE_LONG_CODEC.optionalFieldOf("energy_required", (Object)0L).forGetter(PressurizedReactionRecipe::getEnergyRequired), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(PressurizedReactionRecipe::getDuration), (App)ItemStack.CODEC.optionalFieldOf("item_output", (Object)ItemStack.EMPTY).forGetter(BasicPressurizedReactionRecipe::getOutputItem), (App)ChemicalStack.CODEC.optionalFieldOf("chemical_output", (Object)ChemicalStack.EMPTY).forGetter(BasicPressurizedReactionRecipe::getOutputChemical)).apply((Applicative)instance, factory)).validate(result -> {
            if (result.getOutputItem().isEmpty() && result.getOutputChemical().isEmpty()) {
                return DataResult.error(() -> "No output specified, must have at least an Item or Chemical output");
            }
            return DataResult.success((Object)result);
        }), NeoForgeStreamCodecs.composite(ItemStackIngredient.STREAM_CODEC, PressurizedReactionRecipe::getInputSolid, FluidStackIngredient.STREAM_CODEC, PressurizedReactionRecipe::getInputFluid, IngredientCreatorAccess.chemicalStack().streamCodec(), PressurizedReactionRecipe::getInputChemical, (StreamCodec)ByteBufCodecs.VAR_LONG, PressurizedReactionRecipe::getEnergyRequired, (StreamCodec)ByteBufCodecs.VAR_INT, PressurizedReactionRecipe::getDuration, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, BasicPressurizedReactionRecipe::getOutputItem, ChemicalStack.OPTIONAL_STREAM_CODEC, BasicPressurizedReactionRecipe::getOutputChemical, factory));
    }

    public static <RECIPE extends ItemStackToChemicalRecipe> MekanismRecipeSerializer<RECIPE> itemToChemical(BiFunction<ItemStackIngredient, ChemicalStack, RECIPE> factory, MapCodec<ChemicalStack> stackCodec, StreamCodec<? super RegistryFriendlyByteBuf, ChemicalStack> stackStreamCodec) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("input").forGetter(rec$ -> ((ItemStackToChemicalRecipe)rec$).getInput()), (App)stackCodec.fieldOf("output").forGetter(rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw())).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, rec$ -> ((ItemStackToChemicalRecipe)rec$).getInput(), stackStreamCodec, rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw(), factory));
    }

    public static <RECIPE extends ItemStackChemicalToItemStackRecipe> MekanismRecipeSerializer<RECIPE> itemChemicalToItem(Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStack, Boolean, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(rec$ -> ((ItemStackChemicalToObjectRecipe)rec$).getItemInput()), (App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("chemical_input").forGetter(rec$ -> ((ItemStackChemicalToObjectRecipe)rec$).getChemicalInput()), (App)ItemStack.CODEC.fieldOf("output").forGetter(rec$ -> ((IBasicItemStackOutput)rec$).getOutputRaw()), (App)Codec.BOOL.fieldOf("per_tick_usage").forGetter(rec$ -> ((ItemStackChemicalToObjectRecipe)rec$).perTickUsage())).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, rec$ -> ((ItemStackChemicalToObjectRecipe)rec$).getItemInput(), IngredientCreatorAccess.chemicalStack().streamCodec(), rec$ -> ((ItemStackChemicalToObjectRecipe)rec$).getChemicalInput(), (StreamCodec)ItemStack.STREAM_CODEC, rec$ -> ((IBasicItemStackOutput)rec$).getOutputRaw(), (StreamCodec)ByteBufCodecs.BOOL, rec$ -> ((ItemStackChemicalToObjectRecipe)rec$).perTickUsage(), factory));
    }

    public static <RECIPE extends ChemicalChemicalToChemicalRecipe> MekanismRecipeSerializer<RECIPE> chemicalChemicalToChemical(Function3<ChemicalStackIngredient, ChemicalStackIngredient, ChemicalStack, RECIPE> factory, IIngredientCreator<Chemical, ChemicalStack, ChemicalStackIngredient> ingredientCreator, MapCodec<ChemicalStack> stackCodec, StreamCodec<? super RegistryFriendlyByteBuf, ChemicalStack> stackStreamCodec) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ingredientCreator.codec().fieldOf("left_input").forGetter(rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getLeftInput()), (App)ingredientCreator.codec().fieldOf("right_input").forGetter(rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getRightInput()), (App)stackCodec.fieldOf("output").forGetter(rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw())).apply((Applicative)instance, factory)), StreamCodec.composite(ingredientCreator.streamCodec(), rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getLeftInput(), ingredientCreator.streamCodec(), rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getRightInput(), stackStreamCodec, rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw(), factory));
    }
}

