/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.recipe.lookup.cache.type.ComponentSensitiveInputCache;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class ItemInputCache<RECIPE extends MekanismRecipe<?>>
extends ComponentSensitiveInputCache<Item, ItemStack, ItemStackIngredient, RECIPE> {
    public ItemInputCache() {
        super(ItemStackLinkedSet.TYPE_AND_TAG);
    }

    @Override
    public boolean mapInputs(RECIPE recipe, ItemStackIngredient inputIngredient) {
        return this.mapIngredient(recipe, inputIngredient.ingredient().ingredient());
    }

    private boolean mapIngredient(RECIPE recipe, Ingredient input) {
        if (input.isSimple()) {
            for (ItemStack item : input.getItems()) {
                if (item.isEmpty()) continue;
                this.addInputCache(item.getItem(), recipe);
            }
        } else {
            DataComponentIngredient componentIngredient;
            ICustomIngredient iCustomIngredient = input.getCustomIngredient();
            if (iCustomIngredient instanceof CompoundIngredient) {
                CompoundIngredient compoundIngredient = (CompoundIngredient)iCustomIngredient;
                boolean result = false;
                for (Ingredient child : compoundIngredient.children()) {
                    result |= this.mapIngredient(recipe, child);
                }
                return result;
            }
            iCustomIngredient = input.getCustomIngredient();
            if (iCustomIngredient instanceof DataComponentIngredient && (componentIngredient = (DataComponentIngredient)iCustomIngredient).isStrict()) {
                for (ItemStack item : input.getItems()) {
                    this.addNbtInputCache(item.copyWithCount(1), recipe);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Item createKey(ItemStack stack) {
        return stack.getItem();
    }

    @Override
    public boolean isEmpty(ItemStack input) {
        return input.isEmpty();
    }
}

