/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredients;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.DifferenceChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IntersectionChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.SingleChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalIngredientCreator;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

@NothingNullByDefault
public class ChemicalIngredientCreator
implements IChemicalIngredientCreator {
    public static final ChemicalIngredientCreator INSTANCE = new ChemicalIngredientCreator();
    private static final MapCodec<ChemicalIngredient> SINGLE_OR_TAG_CODEC = NeoForgeExtraCodecs.xor(SingleChemicalIngredient.CODEC, TagChemicalIngredient.CODEC).flatXmap(either -> DataResult.success((Object)((ChemicalIngredient)either.map(i -> i, ChemicalIngredient.class::cast))), ingredient -> {
        if (ingredient instanceof SingleChemicalIngredient) {
            return DataResult.success((Object)Either.left((Object)((SingleChemicalIngredient)ingredient)));
        }
        if (ingredient instanceof TagChemicalIngredient) {
            return DataResult.success((Object)Either.right((Object)((TagChemicalIngredient)ingredient)));
        }
        return DataResult.error(() -> "Basic chemical ingredient should be either a chemical or a tag!");
    });
    private static final MapCodec<ChemicalIngredient> MAP_CODEC_NONEMPTY = NeoForgeExtraCodecs.dispatchMapOrElse((Codec)MekanismAPI.CHEMICAL_INGREDIENT_TYPES.byNameCodec(), ChemicalIngredient::codec, Function.identity(), SINGLE_OR_TAG_CODEC).xmap(either -> (ChemicalIngredient)either.map(Function.identity(), Function.identity()), ingredient -> {
        if (ingredient instanceof SingleChemicalIngredient || ingredient instanceof TagChemicalIngredient) {
            return Either.right((Object)ingredient);
        }
        return Either.left((Object)ingredient);
    }).validate(ingredient -> {
        if (ingredient.isEmpty()) {
            return DataResult.error(() -> "Cannot serialize empty chemical ingredient using the map codec");
        }
        return DataResult.success((Object)ingredient);
    });
    private static final Codec<ChemicalIngredient> MAP_CODEC_CODEC = MAP_CODEC_NONEMPTY.codec();
    private static final Codec<List<ChemicalIngredient>> LIST_CODEC = MAP_CODEC_CODEC.listOf();
    private static final Codec<List<ChemicalIngredient>> LIST_CODEC_NON_EMPTY = ExtraCodecs.nonEmptyList(LIST_CODEC);
    private static final Codec<List<ChemicalIngredient>> LIST_CODEC_MULTIPLE_ELEMENTS = LIST_CODEC.validate(list -> list.size() < 2 ? DataResult.error(() -> "List must have multiple elements") : DataResult.success((Object)list));
    private static final Codec<ChemicalIngredient> CODEC = ChemicalIngredientCreator.codec(LIST_CODEC);
    private static final Codec<ChemicalIngredient> CODEC_NON_EMPTY = ChemicalIngredientCreator.codec(LIST_CODEC_NON_EMPTY);
    private static final StreamCodec<RegistryFriendlyByteBuf, ChemicalIngredient> STREAM_CODEC = Chemical.STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)).map(chemicals -> INSTANCE.of(chemicals.stream()), ChemicalIngredient::getChemicals);

    private static Codec<ChemicalIngredient> codec(Codec<List<ChemicalIngredient>> listCodec) {
        return Codec.either(listCodec, MAP_CODEC_CODEC).xmap(either -> (ChemicalIngredient)either.map(INSTANCE::ofIngredients, Function.identity()), ingredient -> {
            if (ingredient instanceof CompoundChemicalIngredient) {
                CompoundChemicalIngredient compound = (CompoundChemicalIngredient)ingredient;
                return Either.left(compound.children());
            }
            if (ingredient.isEmpty()) {
                return Either.left(Collections.emptyList());
            }
            return Either.right((Object)ingredient);
        });
    }

    @Override
    public MapCodec<ChemicalIngredient> singleOrTagCodec() {
        return SINGLE_OR_TAG_CODEC;
    }

    @Override
    public MapCodec<ChemicalIngredient> mapCodecNonEmpty() {
        return MAP_CODEC_NONEMPTY;
    }

    @Override
    public Codec<List<ChemicalIngredient>> listCodec() {
        return LIST_CODEC;
    }

    @Override
    public Codec<List<ChemicalIngredient>> listCodecNonEmpty() {
        return LIST_CODEC_NON_EMPTY;
    }

    @Override
    public Codec<List<ChemicalIngredient>> listCodecMultipleElements() {
        return LIST_CODEC_MULTIPLE_ELEMENTS;
    }

    @Override
    public Codec<ChemicalIngredient> codec() {
        return CODEC;
    }

    @Override
    public Codec<ChemicalIngredient> codecNonEmpty() {
        return CODEC_NON_EMPTY;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ChemicalIngredient> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public SingleChemicalIngredient of(Holder<Chemical> holder) {
        Objects.requireNonNull(holder, "holder cannot be null");
        return new SingleChemicalIngredient(holder);
    }

    @Override
    public TagChemicalIngredient tag(TagKey<Chemical> tag) {
        Objects.requireNonNull(tag, "tag cannot be null");
        return new TagChemicalIngredient(tag);
    }

    @Override
    public CompoundChemicalIngredient compound(List<ChemicalIngredient> children) {
        Objects.requireNonNull(children, "children cannot be null");
        return new CompoundChemicalIngredient(children);
    }

    @Override
    public ChemicalIngredient difference(ChemicalIngredient base, ChemicalIngredient subtracted) {
        Objects.requireNonNull(base, "base ingredient cannot be null");
        Objects.requireNonNull(subtracted, "subtracted ingredient cannot be null");
        return new DifferenceChemicalIngredient(base, subtracted);
    }

    @Override
    public ChemicalIngredient intersection(ChemicalIngredient ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create an IntersectionChemicalIngredient with no children, use IChemicalIngredientCreator#empty() to create an empty ingredient");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IntersectionChemicalIngredient(List.of(ingredients));
    }

    @Override
    public ChemicalIngredient intersection(List<? extends ChemicalIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an IntersectionChemicalIngredient with no children, use IChemicalIngredientCreator#empty() to create an empty ingredient");
        }
        if (ingredients.size() == 1) {
            return ingredients.getFirst();
        }
        return new IntersectionChemicalIngredient(List.copyOf(ingredients));
    }
}

