/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.frequency;

import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.to_server.frequency.TypedIdentity;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketSetTileFrequency(boolean set, TypedIdentity data, BlockPos pos) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketSetTileFrequency> TYPE = new CustomPacketPayload.Type(Mekanism.rl("set_tile_frequency"));
    public static final StreamCodec<FriendlyByteBuf, PacketSetTileFrequency> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PacketSetTileFrequency::set, TypedIdentity.STREAM_CODEC, PacketSetTileFrequency::data, (StreamCodec)BlockPos.STREAM_CODEC, PacketSetTileFrequency::pos, PacketSetTileFrequency::new);

    public PacketSetTileFrequency(boolean set, FrequencyType<?> type, Frequency.FrequencyIdentity data, BlockPos pos) {
        this(set, new TypedIdentity(type, data), pos);
    }

    @NotNull
    public CustomPacketPayload.Type<PacketSetTileFrequency> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)player.level(), this.pos);
        if (tile instanceof IFrequencyHandler) {
            IFrequencyHandler frequencyHandler = (IFrequencyHandler)tile;
            if (IBlockSecurityUtils.INSTANCE.canAccess(player, player.level(), this.pos, tile)) {
                if (this.set) {
                    frequencyHandler.setFrequency(this.data.type(), this.data.data(), player.getUUID());
                } else {
                    frequencyHandler.removeFrequency(this.data.type(), this.data.data(), player.getUUID());
                }
            }
        }
    }
}

