/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.button;

import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketItemButtonPress(ClickedItemButton buttonClicked, InteractionHand hand) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketItemButtonPress> TYPE = new CustomPacketPayload.Type(Mekanism.rl("item_button"));
    public static final StreamCodec<ByteBuf, PacketItemButtonPress> STREAM_CODEC = StreamCodec.composite(ClickedItemButton.STREAM_CODEC, PacketItemButtonPress::buttonClicked, PacketUtils.INTERACTION_HAND_STREAM_CODEC, PacketItemButtonPress::hand, PacketItemButtonPress::new);

    @NotNull
    public CustomPacketPayload.Type<PacketItemButtonPress> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getItemInHand(this.hand);
        if (stack.getItem() instanceof IGuiItem) {
            player.openMenu(this.buttonClicked.getProvider(stack, this.hand), buf -> {
                buf.writeEnum((Enum)this.hand);
                ItemStack.STREAM_CODEC.encode(buf, (Object)stack);
            });
        }
    }

    public static enum ClickedItemButton {
        BACK_BUTTON((stack, hand) -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof IGuiItem) {
                IGuiItem guiItem = (IGuiItem)patt0$temp;
                return guiItem.getContainerType().getProvider(stack.getHoverName(), (InteractionHand)hand, (ItemStack)stack);
            }
            return null;
        }),
        QIO_FREQUENCY_SELECT((stack, hand) -> MekanismContainerTypes.QIO_FREQUENCY_SELECT_ITEM.getProvider((ILangEntry)MekanismLang.QIO_FREQUENCY_SELECT, (InteractionHand)hand, (ItemStack)stack));

        public static final IntFunction<ClickedItemButton> BY_ID;
        public static final StreamCodec<ByteBuf, ClickedItemButton> STREAM_CODEC;
        private final BiFunction<ItemStack, InteractionHand, @Nullable MenuProvider> providerFromItem;

        private ClickedItemButton(BiFunction<ItemStack, InteractionHand, MenuProvider> providerFromItem) {
            this.providerFromItem = providerFromItem;
        }

        @Nullable
        public MenuProvider getProvider(ItemStack stack, InteractionHand hand) {
            return this.providerFromItem.apply(stack, hand);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ClickedItemButton.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

