/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.lib.math.Range3D;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class PacketUtils {
    public static final int LAST_USERNAME_LENGTH = Math.max(16, 38);
    public static final StreamCodec<FriendlyByteBuf, BlockHitResult> BLOCK_HIT_RESULT_STREAM_CODEC = StreamCodec.of(FriendlyByteBuf::writeBlockHitResult, FriendlyByteBuf::readBlockHitResult);
    public static final StreamCodec<ByteBuf, InteractionHand> INTERACTION_HAND_STREAM_CODEC = PacketUtils.enumCodec(InteractionHand.class);
    public static final StreamCodec<ByteBuf, EquipmentSlot> EQUIPMENT_SLOT_STREAM_CODEC = PacketUtils.enumCodec(EquipmentSlot.class);
    public static final StreamCodec<ByteBuf, Vec3> VEC3_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Vec3::x, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::y, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::z, Vec3::new);

    private PacketUtils() {
    }

    public static <V extends Enum<V>> StreamCodec<ByteBuf, V> enumCodec(Class<V> enumClass) {
        return ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])((Enum[])enumClass.getEnumConstants()), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP), Enum::ordinal);
    }

    public static void log(String logFormat, Object ... params) {
        if (MekanismConfig.general.logPackets.get()) {
            Mekanism.logger.info(logFormat, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <OBJ> OBJ read(RegistryAccess registryAccess, byte[] rawData, Function<RegistryFriendlyByteBuf, OBJ> deserializer) {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])rawData), registryAccess);
        try {
            OBJ OBJ = deserializer.apply(buffer);
            return OBJ;
        }
        finally {
            buffer.release();
        }
    }

    @Nullable
    public static TileComponentEjector ejector(IPayloadContext context, BlockPos pos) {
        BlockEntity blockEntity = PacketUtils.blockEntity(context, pos);
        if (blockEntity instanceof ISideConfiguration) {
            ISideConfiguration sideConfig = (ISideConfiguration)blockEntity;
            return sideConfig.getEjector();
        }
        return null;
    }

    @Nullable
    public static TileComponentConfig config(IPayloadContext context, BlockPos pos) {
        BlockEntity blockEntity = PacketUtils.blockEntity(context, pos);
        if (blockEntity instanceof ISideConfiguration) {
            ISideConfiguration sideConfig = (ISideConfiguration)blockEntity;
            return sideConfig.getConfig();
        }
        return null;
    }

    @Nullable
    public static FilterManager<?> filterManager(IPayloadContext context, BlockPos pos) {
        BlockEntity blockEntity = PacketUtils.blockEntity(context, pos);
        if (blockEntity instanceof ITileFilterHolder) {
            ITileFilterHolder filterHolder = (ITileFilterHolder)blockEntity;
            return filterHolder.getFilterManager();
        }
        return null;
    }

    @Nullable
    public static BlockEntity blockEntity(IPayloadContext context, BlockPos pos) {
        return WorldUtils.getTileEntity((BlockGetter)context.player().level(), pos);
    }

    public static <MSG extends CustomPacketPayload> boolean sendToServer(MSG message) {
        PacketDistributor.sendToServer(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTracking(MSG message, BlockEntity tile) {
        PacketUtils.sendToAllTracking(message, tile.getLevel(), tile.getBlockPos());
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTracking(MSG message, Level world, BlockPos pos) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)world), (ChunkPos)new ChunkPos(pos), message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean hasPlayersTracking(ServerLevel level, BlockPos pos) {
        int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        Set players = level.getChunkSource().chunkMap.playerMap.getAllPlayers();
        for (ServerPlayer serverplayer : players) {
            if (!level.getChunkSource().chunkMap.isChunkTracked(serverplayer, chunkX, chunkZ)) continue;
            return true;
        }
        return false;
    }

    public static void sendToAllTracking(DynamicBufferedNetwork<?, ?, ?, ?> network, CustomPacketPayload ... packets) {
        Range3D range = network.getPacketRange();
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().getPlayerList();
        Packet<?> packet = PacketUtils.makeClientboundPacket(packets);
        int radius = playerList.getViewDistance() * 16;
        for (ServerPlayer player : playerList.getPlayers()) {
            if (range.dimension() != player.level().dimension()) continue;
            BlockPos playerPosition = player.blockPosition();
            int playerX = playerPosition.getX();
            int playerZ = playerPosition.getZ();
            if (!((double)(playerX + radius) + 1.99999 > (double)range.xMin()) || !((double)range.xMax() + 0.99999 > (double)(playerX - radius)) || !((double)(playerZ + radius) + 1.99999 > (double)range.zMin()) || !((double)range.zMax() + 0.99999 > (double)(playerZ - radius))) continue;
            player.connection.send(packet);
        }
    }

    private static Packet<?> makeClientboundPacket(CustomPacketPayload ... payloads) {
        if (payloads.length > 1) {
            ArrayList<ClientboundCustomPayloadPacket> packets = new ArrayList<ClientboundCustomPayloadPacket>(payloads.length);
            for (CustomPacketPayload otherPayload : payloads) {
                packets.add(new ClientboundCustomPayloadPacket(otherPayload));
            }
            return new ClientboundBundlePacket(packets);
        }
        return new ClientboundCustomPayloadPacket(payloads[0]);
    }
}

