/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import mekanism.common.Mekanism;
import mekanism.common.lib.inventory.CollectionTransitRequest;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.InventoryUtils;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class HandlerTransitRequest
extends CollectionTransitRequest {
    private final IItemHandler handler;
    private Map<HashedItem, HandlerItemData> itemMap = Collections.emptyMap();

    public HandlerTransitRequest(IItemHandler handler) {
        this.handler = handler;
    }

    public void addItem(ItemStack stack, int slot) {
        HashedItem hashed = HashedItem.create(stack);
        if (this.itemMap.isEmpty()) {
            this.itemMap = new LinkedHashMap<HashedItem, HandlerItemData>();
        }
        this.itemMap.computeIfAbsent(hashed, x$0 -> new HandlerItemData((HashedItem)x$0)).addSlot(slot, stack);
    }

    public int getCount(HashedItem itemType) {
        TransitRequest.ItemData data = this.itemMap.get(itemType);
        return data == null ? 0 : data.getTotalCount();
    }

    protected IItemHandler getHandler() {
        return this.handler;
    }

    public Collection<HandlerItemData> getItemData() {
        return this.itemMap.values();
    }

    @Override
    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    public class HandlerItemData
    extends TransitRequest.ItemData {
        private final Int2IntMap slotMap;

        public HandlerItemData(HashedItem itemType) {
            super(itemType);
            this.slotMap = new Int2IntLinkedOpenHashMap();
        }

        public void addSlot(int id, ItemStack stack) {
            this.slotMap.put(id, stack.getCount());
            this.totalCount += stack.getCount();
        }

        @Override
        public ItemStack use(int amount) {
            IItemHandler handler = HandlerTransitRequest.this.getHandler();
            if (handler != null && !this.slotMap.isEmpty()) {
                HashedItem itemType = this.getItemType();
                ItemStack itemStack = itemType.getInternalStack();
                ObjectIterator iterator = this.slotMap.int2IntEntrySet().iterator();
                while (iterator.hasNext()) {
                    int currentCount;
                    int toUse;
                    Int2IntMap.Entry entry = (Int2IntMap.Entry)iterator.next();
                    int slot = entry.getIntKey();
                    ItemStack ret = handler.extractItem(slot, toUse = Math.min(amount, currentCount = entry.getIntValue()), false);
                    boolean stackable = InventoryUtils.areItemsStackable(itemStack, ret);
                    if (!stackable || ret.getCount() != toUse) {
                        Mekanism.logger.warn("An inventory's returned content {} does not line up with HandlerTransitRequest's prediction.", (Object)(stackable ? "count" : "type"));
                        Mekanism.logger.warn("HandlerTransitRequest item: {}, toUse: {}, ret: {}, slot: {}", new Object[]{itemStack, toUse, ret, slot});
                        Mekanism.logger.warn("ItemHandler: {}", (Object)handler.getClass().getName());
                    }
                    amount -= toUse;
                    this.totalCount -= toUse;
                    if (this.totalCount == 0) {
                        HandlerTransitRequest.this.itemMap.remove(itemType);
                    }
                    if ((currentCount -= toUse) == 0) {
                        iterator.remove();
                    } else {
                        entry.setValue(currentCount);
                    }
                    if (amount != 0) continue;
                    break;
                }
            }
            return this.getStack();
        }
    }
}

