/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import mekanism.common.lib.distribution.SplitInfo;

public abstract class Target<HANDLER, RESOURCE> {
    protected final Collection<HANDLER> handlers;
    protected final Collection<HandlerType<HANDLER>> needed;
    private int handlerCount = 0;

    protected Target() {
        this.handlers = new LinkedList<HANDLER>();
        this.needed = new LinkedList<HandlerType<HANDLER>>();
    }

    protected Target(Collection<HANDLER> allHandlers) {
        this.handlers = Collections.unmodifiableCollection(allHandlers);
        this.needed = new ArrayList<HandlerType<HANDLER>>(allHandlers.size() / 2);
        this.handlerCount = allHandlers.size();
    }

    protected Target(int expectedSize) {
        this.handlers = new ArrayList<HANDLER>(expectedSize);
        this.needed = new ArrayList<HandlerType<HANDLER>>(expectedSize / 2);
    }

    public void addHandler(HANDLER handler) {
        this.handlers.add(handler);
        ++this.handlerCount;
    }

    public int getHandlerCount() {
        return this.handlerCount;
    }

    public void sendRemainingSplit(RESOURCE resource, SplitInfo splitInfo) {
        if (!this.needed.isEmpty() && splitInfo.getRemainderAmount() != 0L) {
            Iterator<HandlerType<HANDLER>> iterator = this.needed.iterator();
            while (iterator.hasNext()) {
                long remainderAmount = splitInfo.getRemainderAmount();
                if (remainderAmount == 0L) {
                    return;
                }
                HandlerType<HANDLER> needInfo = iterator.next();
                long amountNeeded = needInfo.amount();
                if (amountNeeded <= remainderAmount) {
                    this.acceptAmount(needInfo.handler(), splitInfo, resource, amountNeeded);
                    iterator.remove();
                    continue;
                }
                splitInfo.decrementTargets = false;
                this.acceptAmount(needInfo.handler(), splitInfo, resource, remainderAmount);
                splitInfo.decrementTargets = true;
            }
            if (splitInfo.getUnsent() != 0L) {
                for (HandlerType<HANDLER> recipient : this.needed) {
                    long remaining = splitInfo.getUnsent();
                    if (remaining == 0L) {
                        return;
                    }
                    this.acceptAmount(recipient.handler(), splitInfo, resource, remaining);
                }
            }
        }
    }

    protected abstract void acceptAmount(HANDLER var1, SplitInfo var2, RESOURCE var3, long var4);

    protected abstract long simulate(HANDLER var1, RESOURCE var2, long var3);

    public void sendPossible(RESOURCE resource, SplitInfo splitInfo) {
        if (splitInfo.getShareAmount() == 0L) {
            for (HANDLER entry : this.handlers) {
                long amountNeeded = this.simulate(entry, resource, splitInfo.getUnsent());
                if (amountNeeded == 0L) continue;
                this.needed.add(new HandlerType<HANDLER>(entry, amountNeeded));
            }
        } else {
            for (HANDLER entry : this.handlers) {
                long amountNeeded = this.simulate(entry, resource, splitInfo.getUnsent());
                if (amountNeeded <= splitInfo.getShareAmount()) {
                    if (amountNeeded == 0L) continue;
                    this.acceptAmount(entry, splitInfo, resource, amountNeeded);
                    continue;
                }
                this.needed.add(new HandlerType<HANDLER>(entry, amountNeeded));
            }
        }
    }

    public void shiftNeeded(RESOURCE resource, SplitInfo splitInfo) {
        if (splitInfo.getShareAmount() == 0L) {
            return;
        }
        Iterator<HandlerType<HANDLER>> iterator = this.needed.iterator();
        while (iterator.hasNext()) {
            HandlerType<HANDLER> needInfo = iterator.next();
            long amountNeeded = needInfo.amount();
            if (amountNeeded > splitInfo.getShareAmount()) continue;
            this.acceptAmount(needInfo.handler(), splitInfo, resource, amountNeeded);
            iterator.remove();
        }
    }

    protected record HandlerType<HANDLER>(HANDLER handler, long amount) {
    }
}

