/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import java.util.Collections;
import java.util.List;
import mekanism.api.security.SecurityMode;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.inventory.container.item.MekanismItemContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class FrequencyItemContainer<FREQ extends Frequency>
extends MekanismItemContainer {
    private List<FREQ> publicCache = Collections.emptyList();
    private List<FREQ> privateCache = Collections.emptyList();
    private List<FREQ> trustedCache = Collections.emptyList();
    private FREQ freq;

    protected FrequencyItemContainer(ContainerTypeRegistryObject<?> type, int id, Inventory inv, InteractionHand hand, ItemStack stack) {
        super(type, id, inv, hand, stack);
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    protected abstract FrequencyType<FREQ> getFrequencyType();

    @Nullable
    public FREQ getFrequency() {
        return this.freq;
    }

    public List<FREQ> getPublicCache() {
        return this.publicCache;
    }

    public List<FREQ> getPrivateCache() {
        return this.privateCache;
    }

    public List<FREQ> getTrustedCache() {
        return this.trustedCache;
    }

    @Override
    protected void addContainerTrackers() {
        super.addContainerTrackers();
        FrequencyType frequencyType = this.getFrequencyType();
        DataComponentType<FrequencyAware<FREQ>> frequencyComponent = MekanismDataComponents.getFrequencyComponent(frequencyType);
        if (frequencyComponent != null) {
            FrequencyAware frequencyAware = (FrequencyAware)this.stack.get(frequencyComponent);
            if (frequencyAware != null) {
                this.freq = frequencyAware.getFrequency(this.stack, frequencyComponent);
            }
            this.track(SyncableFrequency.create(frequencyType, this::getFrequency, f -> {
                this.freq = f;
            }));
        }
        if (this.getLevel().isClientSide()) {
            this.track(SyncableFrequencyList.create(frequencyType, this::getPublicCache, value -> {
                this.publicCache = value;
            }));
            this.track(SyncableFrequencyList.create(frequencyType, this::getPrivateCache, value -> {
                this.privateCache = value;
            }));
            this.track(SyncableFrequencyList.create(frequencyType, this::getTrustedCache, value -> {
                this.trustedCache = value;
            }));
        } else {
            this.track(SyncableFrequencyList.create(frequencyType, () -> frequencyType.getManager(null, SecurityMode.PUBLIC).getFrequencies(), value -> {
                this.publicCache = value;
            }));
            this.track(SyncableFrequencyList.create(frequencyType, () -> frequencyType.getManager(this.getPlayerUUID(), SecurityMode.PRIVATE).getFrequencies(), value -> {
                this.privateCache = value;
            }));
            this.track(SyncableFrequencyList.create(frequencyType, () -> frequencyType.getManager(this.getPlayerUUID(), SecurityMode.TRUSTED).getFrequencies(), value -> {
                this.trustedCache = value;
            }));
        }
    }
}

