/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.SearchQueryParser;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.inventory.ISlotClickHandler;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.InsertableSlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.VirtualCraftingOutputSlot;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.qio.PacketQIOItemViewerSlotPlace;
import mekanism.common.network.to_server.qio.PacketQIOItemViewerSlotShiftTake;
import mekanism.common.network.to_server.qio.PacketQIOItemViewerSlotTake;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QIOItemViewerContainer
extends MekanismContainer
implements ISlotClickHandler {
    public static final int SLOTS_X_MIN = 8;
    public static final int SLOTS_X_MAX = 16;
    public static final int SLOTS_Y_MIN = 2;
    public static final int SLOTS_Y_MAX = 48;
    public static final int SLOTS_START_Y = 43;
    private static final int DOUBLE_CLICK_TRANSFER_DURATION = 20;
    private ListSortType sortType;
    private SortDirection sortDirection;
    private Object2LongMap<HashedItem.UUIDAwareHashedItem> cachedInventory = new Object2LongOpenHashMap();
    private long cachedCountCapacity;
    private int cachedTypeCapacity;
    private long totalItems;
    @Nullable
    private List<ISlotClickHandler.IScrollableSlot> itemList;
    @Nullable
    private List<ISlotClickHandler.IScrollableSlot> searchList;
    private Map<String, List<ISlotClickHandler.IScrollableSlot>> searchCache = new Object2ObjectOpenHashMap();
    private String searchQuery = "";
    private int doubleClickTransferTicks = 0;
    private int lastSlot = -1;
    private ItemStack lastStack = ItemStack.EMPTY;
    private List<InventoryContainerSlot>[] craftingGridInputSlots;
    protected final IQIOCraftingWindowHolder craftingWindowHolder;
    private final VirtualInventoryContainerSlot[][] craftingSlots = new VirtualInventoryContainerSlot[3][10];

    public static int getSlotsYMax() {
        int maxY = Mth.ceil((double)((double)Minecraft.getInstance().getWindow().getGuiScaledHeight() * 0.05 - 8.0)) + 1;
        return Mth.clamp((int)maxY, (int)2, (int)48);
    }

    protected QIOItemViewerContainer(ContainerTypeRegistryObject<?> type, int id, Inventory inv, boolean remote, IQIOCraftingWindowHolder craftingWindowHolder) {
        super(type, id, inv);
        this.craftingWindowHolder = craftingWindowHolder;
        if (craftingWindowHolder == null) {
            Mekanism.logger.error("Error getting crafting window holder, closing.");
            this.closeInventory(inv.player);
            return;
        }
        if (remote) {
            this.sortType = (ListSortType)MekanismConfig.client.qioItemViewerSortType.get();
            this.sortDirection = (SortDirection)MekanismConfig.client.qioItemViewerSortDirection.get();
            int maxY = QIOItemViewerContainer.getSlotsYMax();
            if (MekanismConfig.client.qioItemViewerSlotsY.get() > maxY) {
                MekanismConfig.client.qioItemViewerSlotsY.set(maxY);
                MekanismConfig.client.save();
            }
        } else {
            this.sortType = ListSortType.NAME;
            this.sortDirection = SortDirection.ASCENDING;
            this.craftingGridInputSlots = new List[3];
        }
    }

    @Nullable
    public QIOFrequency getFrequency() {
        return this.craftingWindowHolder.getFrequency();
    }

    public abstract boolean shiftClickIntoFrequency();

    public abstract void toggleTargetDirection();

    public abstract QIOItemViewerContainer recreate();

    protected void sync(QIOItemViewerContainer container) {
        container.sortType = this.sortType;
        container.cachedInventory = this.cachedInventory;
        container.cachedCountCapacity = this.cachedCountCapacity;
        container.cachedTypeCapacity = this.cachedTypeCapacity;
        container.totalItems = this.totalItems;
        container.itemList = this.itemList;
        container.searchList = this.searchList;
        container.searchCache = this.searchCache;
        container.searchQuery = this.searchQuery;
        container.selectedWindow = this.getSelectedWindow();
    }

    @Override
    protected int getInventoryYOffset() {
        return 43 + MekanismConfig.client.qioItemViewerSlotsY.getOrDefault() * 18 + 15;
    }

    @Override
    protected int getInventoryXOffset() {
        return super.getInventoryXOffset() + (MekanismConfig.client.qioItemViewerSlotsX.getOrDefault() - 8) * 18 / 2;
    }

    @Override
    protected void addSlots() {
        super.addSlots();
        for (QIOCraftingWindow craftingWindow : this.craftingWindowHolder.getCraftingWindows()) {
            byte tableIndex = craftingWindow.getWindowIndex();
            for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
                this.addCraftingSlot(craftingWindow.getInputSlot(slotIndex), tableIndex, slotIndex);
            }
            this.addCraftingSlot(craftingWindow.getOutputSlot(), tableIndex, 9);
        }
    }

    private void addCraftingSlot(IInventorySlot slot, byte tableIndex, int slotIndex) {
        VirtualInventoryContainerSlot containerSlot;
        this.craftingSlots[tableIndex][slotIndex] = containerSlot = (VirtualInventoryContainerSlot)slot.createContainerSlot();
        this.addSlot(containerSlot);
    }

    public VirtualInventoryContainerSlot getCraftingWindowSlot(byte tableIndex, int slotIndex) {
        return this.craftingSlots[tableIndex][slotIndex];
    }

    @Override
    protected void openInventory(@NotNull Inventory inv) {
        super.openInventory(inv);
        if (this.getLevel().isClientSide()) {
            Mekanism.packetHandler().requestQIOData();
        }
    }

    @Override
    protected void closeInventory(@NotNull Player player) {
        QIOFrequency freq;
        super.closeInventory(player);
        if (!player.level().isClientSide() && (freq = this.getFrequency()) != null) {
            freq.closeItemViewer((ServerPlayer)player);
        }
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.doubleClickTransferTicks > 0) {
            --this.doubleClickTransferTicks;
        } else {
            this.resetTransferTracker();
        }
    }

    private void resetTransferTracker() {
        this.doubleClickTransferTicks = 0;
        this.lastSlot = -1;
        this.lastStack = ItemStack.EMPTY;
    }

    private void setTransferTracker(ItemStack stack, int slot) {
        this.doubleClickTransferTicks = 20;
        this.lastSlot = slot;
        this.lastStack = stack;
    }

    private void doDoubleClickTransfer(Player player) {
        QIOFrequency freq = this.getFrequency();
        if (freq != null) {
            for (InsertableSlot slot : this.mainInventorySlots) {
                this.handleDoDoubleClickTransfer(player, slot, freq);
            }
            for (InsertableSlot slot : this.hotBarSlots) {
                this.handleDoDoubleClickTransfer(player, slot, freq);
            }
        }
    }

    private void handleDoDoubleClickTransfer(Player player, InsertableSlot slot, QIOFrequency freq) {
        ItemStack slotItem;
        if (slot.hasItem() && slot.mayPickup(player) && InventoryUtils.areItemsStackable(this.lastStack, slotItem = slot.getItem())) {
            this.transferSuccess(slot, player, slotItem, freq.addItem(slotItem));
        }
    }

    private List<InventoryContainerSlot> getCraftingGridSlots(byte selectedCraftingGrid) {
        List<InventoryContainerSlot> craftingGridSlots = this.craftingGridInputSlots[selectedCraftingGrid];
        if (craftingGridSlots == null) {
            craftingGridSlots = new ArrayList<InventoryContainerSlot>();
            for (int i = 0; i < 9; ++i) {
                craftingGridSlots.add(this.getCraftingWindowSlot(selectedCraftingGrid, i));
            }
            this.craftingGridInputSlots[selectedCraftingGrid] = craftingGridSlots;
        }
        return craftingGridSlots;
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotID) {
        Slot currentSlot = (Slot)this.slots.get(slotID);
        if (currentSlot == null) {
            return ItemStack.EMPTY;
        }
        if (currentSlot instanceof VirtualCraftingOutputSlot) {
            VirtualCraftingOutputSlot virtualSlot = (VirtualCraftingOutputSlot)currentSlot;
            return virtualSlot.shiftClickSlot(player, this.hotBarSlots, this.mainInventorySlots);
        }
        if (currentSlot instanceof InventoryContainerSlot) {
            return super.quickMoveStack(player, slotID);
        }
        if (!player.level().isClientSide()) {
            Optional<ItemStack> windowHandling;
            ItemStack slotStack = currentSlot.getItem();
            if (!this.shiftClickIntoFrequency() && (windowHandling = this.tryTransferToWindow(player, currentSlot, slotStack)).isPresent()) {
                return windowHandling.get();
            }
            QIOFrequency frequency = this.getFrequency();
            if (frequency != null) {
                if (!slotStack.isEmpty()) {
                    ItemStack ret = frequency.addItem(slotStack);
                    if (slotStack.getCount() != ret.getCount()) {
                        this.setTransferTracker(slotStack.copy(), slotID);
                        return this.transferSuccess(currentSlot, player, slotStack, ret);
                    }
                } else {
                    if (slotID == this.lastSlot && !this.lastStack.isEmpty()) {
                        this.doDoubleClickTransfer(player);
                    }
                    this.resetTransferTracker();
                    return ItemStack.EMPTY;
                }
            }
            if (this.shiftClickIntoFrequency()) {
                return this.tryTransferToWindow(player, currentSlot, slotStack).orElse(ItemStack.EMPTY);
            }
        }
        return ItemStack.EMPTY;
    }

    private Optional<ItemStack> tryTransferToWindow(Player player, Slot currentSlot, ItemStack slotStack) {
        QIOCraftingWindow craftingWindow;
        byte selectedCraftingGrid = this.getSelectedCraftingGrid(player.getUUID());
        if (selectedCraftingGrid != -1 && !(craftingWindow = this.getCraftingWindow(selectedCraftingGrid)).isOutput(slotStack)) {
            SelectedWindowData windowData;
            ItemStack stackToInsert = slotStack;
            List<InventoryContainerSlot> craftingGridSlots = this.getCraftingGridSlots(selectedCraftingGrid);
            stackToInsert = QIOItemViewerContainer.insertItem(craftingGridSlots, stackToInsert, windowData = craftingWindow.getWindowData());
            if (stackToInsert.getCount() != slotStack.getCount()) {
                return Optional.of(this.transferSuccess(currentSlot, player, slotStack, stackToInsert));
            }
        }
        return Optional.empty();
    }

    public void handleBatchUpdate(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        this.cachedInventory = itemMap;
        this.cachedCountCapacity = countCapacity;
        this.cachedTypeCapacity = typeCapacity;
        this.syncItemList();
    }

    public void handleUpdate(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        this.cachedCountCapacity = countCapacity;
        this.cachedTypeCapacity = typeCapacity;
        if (itemMap.isEmpty()) {
            return;
        }
        for (Object2LongMap.Entry entry : itemMap.object2LongEntrySet()) {
            long value = entry.getLongValue();
            if (value == 0L) {
                this.cachedInventory.removeLong(entry.getKey());
                continue;
            }
            this.cachedInventory.put((Object)((HashedItem.UUIDAwareHashedItem)entry.getKey()), value);
        }
        this.syncItemList();
    }

    public void handleKill() {
        this.itemList = null;
        this.searchList = null;
        this.cachedInventory.clear();
    }

    public QIOCraftingTransferHelper getTransferHelper(Player player, QIOCraftingWindow craftingWindow) {
        return new QIOCraftingTransferHelper(this.cachedInventory, this.hotBarSlots, this.mainInventorySlots, craftingWindow, player);
    }

    private void syncItemList() {
        if (this.itemList == null) {
            this.itemList = new ArrayList<ISlotClickHandler.IScrollableSlot>();
        }
        this.itemList.clear();
        this.searchCache.clear();
        this.totalItems = 0L;
        for (Object2LongMap.Entry entry : this.cachedInventory.object2LongEntrySet()) {
            HashedItem.UUIDAwareHashedItem key = (HashedItem.UUIDAwareHashedItem)entry.getKey();
            long value = entry.getLongValue();
            this.itemList.add(new ItemSlotData(key, key.getUUID(), value));
            this.totalItems += value;
        }
        this.sortItemList();
        if (!this.searchQuery.isEmpty()) {
            this.updateSearch(this.getLevel(), this.searchQuery);
        }
    }

    private void sortItemList() {
        if (this.itemList != null) {
            this.sortType.sort(this.itemList, this.sortDirection);
        }
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
        MekanismConfig.client.qioItemViewerSortDirection.set(sortDirection);
        MekanismConfig.client.save();
        this.sortItemList();
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortType(ListSortType sortType) {
        this.sortType = sortType;
        MekanismConfig.client.qioItemViewerSortType.set(sortType);
        MekanismConfig.client.save();
        this.sortItemList();
    }

    public ListSortType getSortType() {
        return this.sortType;
    }

    @Nullable
    public List<ISlotClickHandler.IScrollableSlot> getQIOItemList() {
        return this.searchQuery.isEmpty() ? this.itemList : this.searchList;
    }

    public long getCountCapacity() {
        return this.cachedCountCapacity;
    }

    public int getTypeCapacity() {
        return this.cachedTypeCapacity;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public int getTotalTypes() {
        return this.itemList == null ? 0 : this.itemList.size();
    }

    public byte getSelectedCraftingGrid() {
        return this.getSelectedCraftingGrid(this.getSelectedWindow());
    }

    public byte getSelectedCraftingGrid(UUID player) {
        return this.getSelectedCraftingGrid(this.getSelectedWindow(player));
    }

    private byte getSelectedCraftingGrid(@Nullable SelectedWindowData selectedWindow) {
        if (selectedWindow != null && selectedWindow.type == SelectedWindowData.WindowType.CRAFTING) {
            return selectedWindow.extraData;
        }
        return -1;
    }

    public QIOCraftingWindow getCraftingWindow(int selectedCraftingGrid) {
        if (selectedCraftingGrid < 0 || selectedCraftingGrid >= 3) {
            throw new IllegalArgumentException("Selected crafting grid not in range.");
        }
        return this.craftingWindowHolder.getCraftingWindows()[selectedCraftingGrid];
    }

    public ItemStack insertIntoPlayerInventory(UUID player, ItemStack stack) {
        SelectedWindowData selectedWindow = this.getSelectedWindow(player);
        stack = QIOItemViewerContainer.insertItem(this.hotBarSlots, stack, true, selectedWindow);
        stack = QIOItemViewerContainer.insertItem(this.mainInventorySlots, stack, true, selectedWindow);
        stack = QIOItemViewerContainer.insertItem(this.hotBarSlots, stack, false, selectedWindow);
        stack = QIOItemViewerContainer.insertItem(this.mainInventorySlots, stack, false, selectedWindow);
        return stack;
    }

    public ItemStack simulateInsertIntoPlayerInventory(UUID player, ItemStack stack) {
        SelectedWindowData selectedWindow = this.getSelectedWindow(player);
        stack = QIOItemViewerContainer.insertItemCheckAll(this.hotBarSlots, stack, selectedWindow, Action.SIMULATE);
        stack = QIOItemViewerContainer.insertItemCheckAll(this.mainInventorySlots, stack, selectedWindow, Action.SIMULATE);
        return stack;
    }

    public void updateSearch(@Nullable Level level, String queryText) {
        if (level == null || !level.isClientSide() || this.itemList == null) {
            return;
        }
        this.searchQuery = queryText;
        this.searchList = this.searchCache.get(queryText);
        if (this.searchList == null) {
            this.searchList = new ArrayList<ISlotClickHandler.IScrollableSlot>();
            SearchQueryParser.ISearchQuery query = SearchQueryParser.parse(queryText);
            for (ISlotClickHandler.IScrollableSlot slot : this.itemList) {
                if (!query.test(level, slot.item().getInternalStack())) continue;
                this.searchList.add(slot);
            }
        }
    }

    @Override
    public void onClick(Supplier<@Nullable ISlotClickHandler.IScrollableSlot> slotProvider, int button, boolean hasShiftDown, ItemStack heldItem) {
        if (hasShiftDown) {
            ISlotClickHandler.IScrollableSlot slot = slotProvider.get();
            if (slot != null) {
                PacketUtils.sendToServer(new PacketQIOItemViewerSlotShiftTake(slot.itemUUID()));
            }
        } else if (button == 0 || button == 1 || button == 2) {
            ISlotClickHandler.IScrollableSlot slot;
            if (heldItem.isEmpty()) {
                ISlotClickHandler.IScrollableSlot slot2 = slotProvider.get();
                if (slot2 != null) {
                    int maxStackSize = Math.min(MathUtils.clampToInt(slot2.count()), slot2.item().getMaxStackSize());
                    int toTake = button == 0 ? maxStackSize : (button == 2 ? 1 : Math.max(1, maxStackSize / 2));
                    PacketUtils.sendToServer(new PacketQIOItemViewerSlotTake(slot2.itemUUID(), toTake));
                }
            } else if (button == 2 && (slot = slotProvider.get()) != null && InventoryUtils.areItemsStackable(heldItem, slot.item().getInternalStack())) {
                PacketUtils.sendToServer(new PacketQIOItemViewerSlotTake(slot.itemUUID(), 1));
            } else {
                int toAdd = button == 0 ? heldItem.getCount() : 1;
                PacketUtils.sendToServer(new PacketQIOItemViewerSlotPlace(toAdd));
            }
        }
    }

    public static enum ListSortType implements GuiComponents.IDropdownEnum<ListSortType>,
    TranslatableEnum
    {
        NAME(MekanismLang.LIST_SORT_NAME, MekanismLang.LIST_SORT_NAME_DESC, Comparator.comparing(ISlotClickHandler.IScrollableSlot::getDisplayName)),
        SIZE(MekanismLang.LIST_SORT_COUNT, MekanismLang.LIST_SORT_COUNT_DESC, Comparator.comparingLong(ISlotClickHandler.IScrollableSlot::count).thenComparing(ISlotClickHandler.IScrollableSlot::getDisplayName), Comparator.comparingLong(ISlotClickHandler.IScrollableSlot::count).reversed().thenComparing(ISlotClickHandler.IScrollableSlot::getDisplayName)),
        MOD(MekanismLang.LIST_SORT_MOD, MekanismLang.LIST_SORT_MOD_DESC, Comparator.comparing(ISlotClickHandler.IScrollableSlot::getModID).thenComparing(ISlotClickHandler.IScrollableSlot::getDisplayName), Comparator.comparing(ISlotClickHandler.IScrollableSlot::getModID).reversed().thenComparing(ISlotClickHandler.IScrollableSlot::getDisplayName)),
        REGISTRY_NAME(MekanismLang.LIST_SORT_REGISTRY_NAME, MekanismLang.LIST_SORT_REGISTRY_NAME_DESC, Comparator.comparing(ISlotClickHandler.IScrollableSlot::getRegistryName, ResourceLocation::compareNamespaced).thenComparingLong(ISlotClickHandler.IScrollableSlot::count), Comparator.comparing(ISlotClickHandler.IScrollableSlot::getRegistryName, ResourceLocation::compareNamespaced).reversed().thenComparingLong(ISlotClickHandler.IScrollableSlot::count));

        private final ILangEntry name;
        private final ILangEntry tooltip;
        private final Comparator<ISlotClickHandler.IScrollableSlot> ascendingComparator;
        private final Comparator<ISlotClickHandler.IScrollableSlot> descendingComparator;

        private ListSortType(ILangEntry name, ILangEntry tooltip, Comparator<ISlotClickHandler.IScrollableSlot> ascendingComparator) {
            this(name, tooltip, ascendingComparator, ascendingComparator.reversed());
        }

        private ListSortType(ILangEntry name, ILangEntry tooltip, Comparator<ISlotClickHandler.IScrollableSlot> ascendingComparator, Comparator<ISlotClickHandler.IScrollableSlot> descendingComparator) {
            this.name = name;
            this.tooltip = tooltip;
            this.ascendingComparator = ascendingComparator;
            this.descendingComparator = descendingComparator;
        }

        public void sort(List<ISlotClickHandler.IScrollableSlot> list, SortDirection direction) {
            list.sort(direction.isAscending() ? this.ascendingComparator : this.descendingComparator);
        }

        @Override
        public Component getTooltip() {
            return this.tooltip.translate();
        }

        @Override
        public Component getShortName() {
            return this.name.translate();
        }

        @NotNull
        public Component getTranslatedName() {
            return this.getShortName();
        }
    }

    public static enum SortDirection implements GuiComponents.IToggleEnum<SortDirection>,
    IHasTranslationKey.IHasEnumNameTranslationKey
    {
        ASCENDING(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_up.png"), MekanismLang.LIST_SORT_ASCENDING, MekanismLang.LIST_SORT_ASCENDING_DESC),
        DESCENDING(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_down.png"), MekanismLang.LIST_SORT_DESCENDING, MekanismLang.LIST_SORT_DESCENDING_DESC);

        private final ResourceLocation icon;
        private final ILangEntry name;
        private final ILangEntry tooltip;

        private SortDirection(ResourceLocation icon, ILangEntry name, ILangEntry tooltip) {
            this.icon = icon;
            this.name = name;
            this.tooltip = tooltip;
        }

        @Override
        public ResourceLocation getIcon() {
            return this.icon;
        }

        @Override
        public Component getTooltip() {
            return this.tooltip.translate();
        }

        public boolean isAscending() {
            return this == ASCENDING;
        }

        @Override
        @NotNull
        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }
    }

    private record ItemSlotData(HashedItem item, UUID itemUUID, long count) implements ISlotClickHandler.IScrollableSlot
    {
    }
}

