/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSChemical;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@RecipeTypeMapper
public class PressurizedReactionRecipeMapper
extends TypedMekanismRecipeMapper<PressurizedReactionRecipe> {
    public PressurizedReactionRecipeMapper() {
        super(PressurizedReactionRecipe.class, MekanismRecipeType.REACTION);
    }

    public String getName() {
        return "MekPressurizedReaction";
    }

    public String getDescription() {
        return "Maps Mekanism pressurized reaction recipes.";
    }

    public boolean isAvailable() {
        return false;
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, PressurizedReactionRecipe recipe) {
        boolean handled = false;
        List<@NotNull ItemStack> itemRepresentations = recipe.getInputSolid().getRepresentations();
        List<@NotNull FluidStack> fluidRepresentations = recipe.getInputFluid().getRepresentations();
        List<@NotNull ChemicalStack> chemicalRepresentations = recipe.getInputChemical().getRepresentations();
        for (ItemStack itemRepresentation : itemRepresentations) {
            NSSItem nssItem = NSSItem.createItem((ItemStack)itemRepresentation);
            for (FluidStack fluidRepresentation : fluidRepresentations) {
                NSSFluid nssFluid = NSSFluid.createFluid((FluidStack)fluidRepresentation);
                for (ChemicalStack chemicalRepresentation : chemicalRepresentations) {
                    NSSChemical nssChemical = NSSChemical.createChemical(chemicalRepresentation);
                    PressurizedReactionRecipe.PressurizedReactionRecipeOutput output = recipe.getOutput(itemRepresentation, fluidRepresentation, chemicalRepresentation);
                    ItemStack itemOutput = output.item();
                    ChemicalStack chemicalOutput = output.chemical();
                    IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                    ingredientHelper.put((NormalizedSimpleStack)nssItem, itemRepresentation.getCount());
                    ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssChemical, chemicalRepresentation.getAmount());
                    if (itemOutput.isEmpty()) {
                        if (chemicalOutput.isEmpty() || !ingredientHelper.addAsConversion(chemicalOutput)) continue;
                        handled = true;
                        continue;
                    }
                    if (chemicalOutput.isEmpty()) {
                        if (!ingredientHelper.addAsConversion(itemOutput)) continue;
                        handled = true;
                        continue;
                    }
                    NSSItem nssItemOutput = NSSItem.createItem((ItemStack)itemOutput);
                    NSSChemical nssChemicalOutput = NSSChemical.createChemical(chemicalOutput);
                    ingredientHelper.put((NormalizedSimpleStack)nssChemicalOutput, -chemicalOutput.getAmount());
                    if (ingredientHelper.addAsConversion((NormalizedSimpleStack)nssItemOutput, itemOutput.getCount())) {
                        handled = true;
                    }
                    ingredientHelper.resetHelper();
                    ingredientHelper.put((NormalizedSimpleStack)nssItem, itemRepresentation.getCount());
                    ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssChemical, chemicalRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssItemOutput, -itemOutput.getCount());
                    if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)nssChemicalOutput, chemicalOutput.getAmount())) continue;
                    handled = true;
                }
            }
        }
        return handled;
    }
}

