/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSChemical;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.neoforged.neoforge.fluids.FluidStack;

@RecipeTypeMapper
public class ElectrolysisRecipeMapper
extends TypedMekanismRecipeMapper<ElectrolysisRecipe> {
    public ElectrolysisRecipeMapper() {
        super(ElectrolysisRecipe.class, MekanismRecipeType.SEPARATING);
    }

    public String getName() {
        return "MekElectrolysis";
    }

    public String getDescription() {
        return "Maps Mekanism electrolytic separator recipes.";
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, ElectrolysisRecipe recipe) {
        boolean handled = false;
        FluidStackIngredient input = recipe.getInput();
        for (FluidStack representation : input.getRepresentations()) {
            ElectrolysisRecipe.ElectrolysisRecipeOutput output = recipe.getOutput(representation);
            ChemicalStack leftOutput = output.left();
            ChemicalStack rightOutput = output.right();
            if (leftOutput.isEmpty() || rightOutput.isEmpty()) continue;
            NSSFluid nssInput = NSSFluid.createFluid((FluidStack)representation);
            NSSChemical nssLeftOutput = NSSChemical.createChemical(leftOutput);
            NSSChemical nssRightOutput = NSSChemical.createChemical(rightOutput);
            IngredientHelper ingredientHelper = new IngredientHelper(mapper);
            ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.getAmount());
            ingredientHelper.put((NormalizedSimpleStack)nssRightOutput, -rightOutput.getAmount());
            if (ingredientHelper.addAsConversion((NormalizedSimpleStack)nssLeftOutput, leftOutput.getAmount())) {
                handled = true;
            }
            ingredientHelper.resetHelper();
            ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.getAmount());
            ingredientHelper.put((NormalizedSimpleStack)nssLeftOutput, -leftOutput.getAmount());
            if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)nssRightOutput, rightOutput.getAmount())) continue;
            handled = true;
        }
        return handled;
    }
}

