/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSChemical;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@RecipeTypeMapper
public class ChemicalDissolutionRecipeMapper
extends TypedMekanismRecipeMapper<ChemicalDissolutionRecipe> {
    public ChemicalDissolutionRecipeMapper() {
        super(ChemicalDissolutionRecipe.class, MekanismRecipeType.DISSOLUTION);
    }

    public String getName() {
        return "MekDissolution";
    }

    public String getDescription() {
        return "Maps Mekanism dissolution recipes.";
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, ChemicalDissolutionRecipe recipe) {
        boolean handled = false;
        List<@NotNull ItemStack> itemRepresentations = recipe.getItemInput().getRepresentations();
        List<@NotNull ChemicalStack> chemicalRepresentations = recipe.getChemicalInput().getRepresentations();
        for (ChemicalStack chemicalRepresentation : chemicalRepresentations) {
            NSSChemical nssChemical = NSSChemical.createChemical(chemicalRepresentation);
            long chemicalAmount = chemicalRepresentation.getAmount();
            if (recipe.perTickUsage()) {
                chemicalAmount *= 200L;
            }
            for (ItemStack itemRepresentation : itemRepresentations) {
                ChemicalStack output = (ChemicalStack)recipe.getOutput(itemRepresentation, chemicalRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put(itemRepresentation);
                ingredientHelper.put((NormalizedSimpleStack)nssChemical, chemicalAmount);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

