/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import moze_intel.projecte.api.codec.NSSCodecHolder;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public final class NSSChemical
extends AbstractNSSTag<Chemical> {
    private static final boolean ALLOW_DEFAULT = false;
    public static final Codec<NSSChemical> LEGACY_CODEC = NSSChemical.createLegacyCodec(MekanismAPI.CHEMICAL_REGISTRY, (boolean)false, (String)"CHEMICAL|", NSSChemical::new);
    public static final MapCodec<NSSChemical> EXPLICIT_MAP_CODEC = NSSChemical.createExplicitCodec(MekanismAPI.CHEMICAL_REGISTRY, (boolean)false, NSSChemical::new);
    public static final Codec<NSSChemical> EXPLICIT_CODEC = EXPLICIT_MAP_CODEC.codec();
    public static final NSSCodecHolder<NSSChemical> CODECS = new NSSCodecHolder("CHEMICAL", LEGACY_CODEC, EXPLICIT_CODEC);

    private NSSChemical(@NotNull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @NotNull
    public static NSSChemical createChemical(@NotNull ChemicalStack stack) {
        return NSSChemical.createChemical(stack.getChemical());
    }

    @NotNull
    public static NSSChemical createChemical(@NotNull IChemicalProvider chemicalProvider) {
        return NSSChemical.createChemical(chemicalProvider.getChemical());
    }

    @NotNull
    public static NSSChemical createChemical(@NotNull Chemical chemical) {
        if (chemical.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSChemical with an empty chemical");
        }
        return NSSChemical.createChemical(chemical.getRegistryName());
    }

    @NotNull
    public static NSSChemical createChemical(@NotNull ResourceLocation chemicalId) {
        return new NSSChemical(chemicalId, false);
    }

    @NotNull
    public static NSSChemical createTag(@NotNull ResourceLocation tagId) {
        return new NSSChemical(tagId, true);
    }

    @NotNull
    public static NSSChemical createTag(@NotNull TagKey<Chemical> tag) {
        return NSSChemical.createTag(tag.location());
    }

    @NotNull
    protected Registry<Chemical> getRegistry() {
        return MekanismAPI.CHEMICAL_REGISTRY;
    }

    protected NSSChemical createNew(Chemical chemical) {
        return NSSChemical.createChemical(chemical);
    }

    public NSSCodecHolder<NSSChemical> codecs() {
        return CODECS;
    }
}

