/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.integration.projecte.NSSChemical;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class IngredientHelper {
    private final IMappingCollector<NormalizedSimpleStack, Long> mapper;
    private Map<NormalizedSimpleStack, Integer> ingredientMap = new HashMap<NormalizedSimpleStack, Integer>();
    private boolean isValid = true;

    public IngredientHelper(IMappingCollector<NormalizedSimpleStack, Long> mapper) {
        this.mapper = mapper;
    }

    public void resetHelper() {
        this.isValid = true;
        this.ingredientMap = new HashMap<NormalizedSimpleStack, Integer>();
    }

    public void put(NormalizedSimpleStack stack, int amount) {
        if (this.isValid) {
            if (this.ingredientMap.containsKey(stack)) {
                long newAmount = (long)this.ingredientMap.get(stack).intValue() + (long)amount;
                if (newAmount > Integer.MAX_VALUE || newAmount < Integer.MIN_VALUE) {
                    this.isValid = false;
                } else {
                    this.ingredientMap.put(stack, (int)newAmount);
                }
            } else {
                this.ingredientMap.put(stack, amount);
            }
        }
    }

    public void put(NormalizedSimpleStack stack, long amount) {
        if (amount > Integer.MAX_VALUE || amount < Integer.MIN_VALUE) {
            this.isValid = false;
        } else {
            this.put(stack, (int)amount);
        }
    }

    public void put(ChemicalStack stack) {
        this.put(this.convertToNSS(stack), stack.getAmount());
    }

    public void put(FluidStack stack) {
        this.put((NormalizedSimpleStack)NSSFluid.createFluid((FluidStack)stack), stack.getAmount());
    }

    public void put(ItemStack stack) {
        this.put((NormalizedSimpleStack)NSSItem.createItem((ItemStack)stack), stack.getCount());
    }

    public boolean addAsConversion(NormalizedSimpleStack output, int outputAmount) {
        if (this.isValid) {
            this.mapper.addConversion(outputAmount, (Object)output, this.ingredientMap);
            return true;
        }
        return false;
    }

    public boolean addAsConversion(NormalizedSimpleStack output, long outputAmount) {
        if (outputAmount > Integer.MAX_VALUE) {
            return false;
        }
        return this.addAsConversion(output, (int)outputAmount);
    }

    public boolean addAsConversion(ChemicalStack stack) {
        return this.addAsConversion(this.convertToNSS(stack), stack.getAmount());
    }

    public boolean addAsConversion(FluidStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSFluid.createFluid((FluidStack)stack), stack.getAmount());
    }

    public boolean addAsConversion(ItemStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSItem.createItem((ItemStack)stack), stack.getCount());
    }

    private NormalizedSimpleStack convertToNSS(ChemicalStack chemicalStack) {
        return NSSChemical.createChemical(chemicalStack);
    }
}

