/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.wthit;

import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mekanism.common.integration.lookingat.ILookingAtElement;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.TextElement;
import mekanism.common.integration.lookingat.wthit.MekanismWTHITPlugin;
import mekanism.common.integration.lookingat.wthit.WTHITLookingAtHelper;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class WTHITTooltipRenderer
implements IBlockComponentProvider,
IEntityComponentProvider {
    static final WTHITTooltipRenderer INSTANCE = new WTHITTooltipRenderer();

    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        this.append(tooltip, accessor.getData(), config);
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.append(tooltip, accessor.getData(), config);
    }

    private void append(ITooltip tooltip, IDataReader dataReader, IPluginConfig config) {
        WTHITLookingAtHelper helper = (WTHITLookingAtHelper)dataReader.get(WTHITLookingAtHelper.TYPE);
        if (helper != null) {
            tooltip.setLine(MekanismWTHITPlugin.MEK_DATA);
            Component lastText = null;
            for (ILookingAtElement element : helper.elements) {
                if (element instanceof TextElement) {
                    TextElement textElement = (TextElement)element;
                    if (lastText != null) {
                        tooltip.addLine(lastText);
                    }
                    lastText = textElement.text();
                    continue;
                }
                if (config.getBoolean(element.getID())) {
                    tooltip.addLine((ITooltipComponent)new MekElement(lastText, (LookingAtElement)element));
                }
                lastText = null;
            }
            if (lastText != null) {
                tooltip.addLine(lastText);
            }
        }
    }

    private record MekElement(@Nullable Component text, LookingAtElement element) implements ITooltipComponent
    {
        public int getWidth() {
            if (this.text == null) {
                return this.element.getWidth();
            }
            return Math.max(this.element.getWidth(), 96);
        }

        public int getHeight() {
            if (this.text == null) {
                return this.element.getHeight() + 2;
            }
            return this.element.getHeight() + 16;
        }

        public void render(GuiGraphics guiGraphics, int x, int y, DeltaTracker delta) {
            if (this.text != null) {
                LookingAtElement.renderScaledText(Minecraft.getInstance(), guiGraphics, x + 4, y + 3, 0xFFFFFF, 92.0f, this.text);
                y += 13;
            }
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate((float)x, (float)y, 0.0f);
            this.element.render(guiGraphics, 0, 1);
            pose.popPose();
        }
    }
}

