/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.math.MathUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidElement
extends LookingAtElement {
    public static final MapCodec<FluidElement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid").forGetter(FluidElement::getStored), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max").forGetter(FluidElement::getCapacity)).apply((Applicative)instance, FluidElement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidElement> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, FluidElement::getStored, (StreamCodec)ByteBufCodecs.VAR_INT, FluidElement::getCapacity, FluidElement::new);
    @NotNull
    protected final FluidStack stored;
    protected final int capacity;

    public FluidElement(@NotNull FluidStack stored, int capacity) {
        super(-16777216, 0xFFFFFF);
        this.stored = stored;
        this.capacity = capacity;
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0 || this.stored.getAmount() == Integer.MAX_VALUE) {
            return level;
        }
        return MathUtils.clampToInt((double)level * (double)this.stored.getAmount() / (double)this.capacity);
    }

    @NotNull
    public FluidStack getStored() {
        return this.stored;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.stored.isEmpty() ? null : MekanismRenderer.getFluidTexture(this.stored, MekanismRenderer.FluidTextureType.STILL);
    }

    @Override
    public Component getText() {
        int amount = this.stored.getAmount();
        if (this.stored.isEmpty()) {
            return MekanismLang.EMPTY.translate();
        }
        if (amount == Integer.MAX_VALUE) {
            return MekanismLang.GENERIC_STORED.translate(this.stored, MekanismLang.INFINITE);
        }
        return MekanismLang.GENERIC_STORED_MB.translate(this.stored, TextUtils.format(amount));
    }

    @Override
    protected boolean applyRenderColor(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, this.stored);
        return true;
    }

    @Override
    public ResourceLocation getID() {
        return LookingAtUtils.FLUID;
    }
}

