/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.MathUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ChemicalElement
extends LookingAtElement {
    public static final MapCodec<ChemicalElement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChemicalStack.OPTIONAL_CODEC.fieldOf("chemical").forGetter(ChemicalElement::getStored), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("max").forGetter(ChemicalElement::getCapacity)).apply((Applicative)instance, ChemicalElement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalElement> STREAM_CODEC = StreamCodec.composite(ChemicalStack.OPTIONAL_STREAM_CODEC, ChemicalElement::getStored, (StreamCodec)ByteBufCodecs.VAR_LONG, ChemicalElement::getCapacity, ChemicalElement::new);
    @NotNull
    protected final ChemicalStack stored;
    protected final long capacity;

    public ChemicalElement(@NotNull ChemicalStack stored, long capacity) {
        super(-16777216, 0xFFFFFF);
        this.stored = stored;
        this.capacity = capacity;
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0L || this.stored.getAmount() == Long.MAX_VALUE) {
            return level;
        }
        return MathUtils.clampToInt((double)level * (double)this.stored.getAmount() / (double)this.capacity);
    }

    @NotNull
    public ChemicalStack getStored() {
        return this.stored;
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.stored.isEmpty() ? null : MekanismRenderer.getChemicalTexture(this.stored.getChemical());
    }

    @Override
    public Component getText() {
        long amount = this.stored.getAmount();
        if (this.stored.isEmpty()) {
            return MekanismLang.EMPTY.translate();
        }
        if (amount == Long.MAX_VALUE) {
            return MekanismLang.GENERIC_STORED.translate(this.stored.getChemical(), MekanismLang.INFINITE);
        }
        return MekanismLang.GENERIC_STORED_MB.translate(this.stored.getChemical(), TextUtils.format(amount));
    }

    @Override
    protected boolean applyRenderColor(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, this.stored.getChemical());
        return true;
    }

    @Override
    public ResourceLocation getID() {
        return LookingAtUtils.CHEMICAL;
    }
}

