/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.ModuleData;
import mekanism.api.robit.RobitSkin;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.BracketHandlers")
public class CrTBracketHandlers {
    @ZenCodeType.Method
    @BracketResolver(value="chemical")
    public static ICrTChemicalStack getChemicalStack(String tokens) {
        return CrTUtils.fromChemical(CrTBracketHandlers.getValue("chemical", tokens, MekanismAPI.CHEMICAL_REGISTRY), 1);
    }

    @ZenCodeType.Method
    @BracketResolver(value="robit_skin")
    public static RobitSkin getRobitSkin(String tokens) {
        return CrTBracketHandlers.getValue("robit_skin", tokens, MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
    }

    @ZenCodeType.Method
    @BracketResolver(value="module_data")
    public static ModuleData<?> getModuleData(String tokens) {
        return CrTBracketHandlers.getValue("module_data", tokens, MekanismAPI.MODULE_REGISTRY);
    }

    private static <V> V getValue(String bracket, String tokens, ResourceKey<? extends Registry<? extends V>> registryKey) {
        Registry registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().registryOrThrow(registryKey);
        return CrTBracketHandlers.getValue(bracket, tokens, registry);
    }

    private static <V> V getValue(String bracket, String tokens, Registry<V> registry) {
        ResourceLocation registryName = ResourceLocation.tryParse((String)tokens);
        if (registryName == null) {
            String typeName = bracket.replace("_", " ");
            throw new IllegalArgumentException("Could not get " + typeName + " for <" + bracket + ":" + tokens + ">. Syntax is <" + bracket + ":modid:" + bracket + "_name>");
        }
        if (!registry.containsKey(registryName)) {
            String typeName = bracket.replace("_", " ");
            throw new IllegalArgumentException("Could not get " + typeName + " for <" + bracket + ":" + tokens + ">, " + typeName + " does not appear to exist!");
        }
        return (V)registry.get(registryName);
    }
}

