/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.natives.ingredient.ExpandCTFluidIngredientNeoForge;
import com.blamejared.crafttweaker.natives.ingredient.ExpandIIngredientWithAmountNeoForge;
import com.blamejared.crafttweaker.natives.ingredient.ExpandSizedFluidIngredient;
import com.blamejared.crafttweaker.natives.ingredient.ExpandSizedIngredient;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class CrTUtils {
    public static final Function<ChemicalStack, ICrTChemicalStack> CHEMICAL_CONVERTER = CrTChemicalStack::new;

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)path);
    }

    public static ICrTChemicalStack fromChemical(Chemical chemical, int size) {
        return new CrTChemicalStack(chemical.getStack(size));
    }

    public static ItemStackIngredient fromCrT(IIngredientWithAmount ingredient) {
        return IngredientCreatorAccess.item().from(ExpandIIngredientWithAmountNeoForge.asSizedIngredient((IIngredientWithAmount)ingredient));
    }

    public static IIngredientWithAmount toCrT(ItemStackIngredient ingredient) {
        return ExpandSizedIngredient.asIIngredientWithAmount((SizedIngredient)ingredient.ingredient());
    }

    public static FluidStackIngredient fromCrT(CTFluidIngredient ingredient) {
        return IngredientCreatorAccess.fluid().from(ExpandCTFluidIngredientNeoForge.asSizedFluidIngredient((CTFluidIngredient)ingredient));
    }

    public static CTFluidIngredient toCrT(FluidStackIngredient ingredient) {
        return ExpandSizedFluidIngredient.asCTFluidIngredient((SizedFluidIngredient)ingredient.ingredient());
    }

    public static <C> Optional<C> getSingleIfPresent(IDecomposedRecipe recipe, IRecipeComponent<C> component) {
        List values = recipe.get(component);
        if (values == null) {
            return Optional.empty();
        }
        if (values.size() != 1) {
            String message = String.format(Locale.ROOT, "Expected a list with a single element for %s, but got %d-sized list: %s", component.getCommandString(), values.size(), values);
            throw new IllegalArgumentException(message);
        }
        return Optional.of(values.getFirst());
    }

    public static <C> UnaryTypePair<C> getPair(IDecomposedRecipe recipe, IRecipeComponent<C> component) {
        List list = recipe.getOrThrow(component);
        if (list.size() != 2) {
            String message = String.format(Locale.ROOT, "Expected a list with two elements element for %s, but got %d-sized list: %s", component.getCommandString(), list.size(), list);
            throw new IllegalArgumentException(message);
        }
        return new UnaryTypePair(list.get(0), list.get(1));
    }

    public static String describeOutputs(List<ChemicalStack> outputs) {
        if (outputs.isEmpty()) {
            return "";
        }
        return CrTUtils.describeOutputs(outputs, CHEMICAL_CONVERTER);
    }

    public static <TYPE> String describeOutputs(List<TYPE> outputs, Function<TYPE, ?> converter) {
        int size = outputs.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return converter.apply(outputs.getFirst()).toString();
        }
        StringBuilder description = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                description.append(", or ");
            }
            description.append(converter.apply(outputs.get(i)));
        }
        return description.toString();
    }

    public static String describeOutputs(long[] outputs) {
        int size = outputs.length;
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return Long.toString(outputs[0]);
        }
        StringBuilder description = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                description.append(", or ");
            }
            description.append(outputs[i]);
        }
        return description.toString();
    }

    public static <TYPE> TagKey<TYPE> validateTagAndGet(KnownTag<TYPE> tag) {
        if (tag.exists()) {
            return tag.getTagKey();
        }
        throw new IllegalArgumentException("Tag " + tag.getCommandString() + " does not exist.");
    }

    public static <TYPE, CRT_TYPE> List<CRT_TYPE> convert(List<TYPE> elements, Function<TYPE, CRT_TYPE> converter) {
        return elements.stream().map(converter).toList();
    }

    public static List<ICrTChemicalStack> convertChemical(List<ChemicalStack> elements) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return CrTUtils.convert(elements, CHEMICAL_CONVERTER);
    }

    public static List<IItemStack> convertItems(List<ItemStack> elements) {
        return CrTUtils.convert(elements, IItemStack::of);
    }

    public static List<IFluidStack> convertFluids(List<FluidStack> elements) {
        return CrTUtils.convert(elements, IFluidStack::of);
    }

    public static KnownTagManager<Item> itemTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.ITEM);
    }

    public static KnownTagManager<Fluid> fluidTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.FLUID);
    }

    public static KnownTagManager<Chemical> chemicalTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.CHEMICAL_REGISTRY_NAME);
    }

    public record UnaryTypePair<TYPE>(TYPE a, TYPE b) {
    }
}

