/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.integration.computer.FactoryRegistry;
import mekanism.common.integration.computer.computercraft.CCCapabilityHelper;
import mekanism.common.integration.crafttweaker.content.CrTContentUtils;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.integration.framedblocks.FramedBlocksIntegration;
import mekanism.common.integration.jsonthings.JsonThingsIntegration;
import mekanism.common.integration.lookingat.theoneprobe.TOPProvider;
import mekanism.common.integration.projecte.MekanismNormalizedSimpleStacks;
import mekanism.common.recipe.bin.BinInsertRecipe;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.loading.DatagenModLoader;

public final class MekanismHooks {
    public static final String CC_MOD_ID = "computercraft";
    public static final String CRAFTTWEAKER_MOD_ID = "crafttweaker";
    public static final String CURIOS_MODID = "curios";
    public static final String DARK_MODE_EVERYWHERE_MODID = "darkmodeeverywhere";
    public static final String FLUX_NETWORKS_MOD_ID = "fluxnetworks";
    public static final String GRAND_POWER_MOD_ID = "grandpower";
    public static final String JEI_MOD_ID = "jei";
    public static final String EMI_MOD_ID = "emi";
    public static final String JEITWEAKER_MOD_ID = "jeitweaker";
    public static final String JSON_THINGS_MOD_ID = "jsonthings";
    public static final String OC2_MOD_ID = "oc2";
    public static final String PROJECTE_MOD_ID = "projecte";
    public static final String RECIPE_STAGES_MOD_ID = "recipestages";
    public static final String TOP_MOD_ID = "theoneprobe";
    public static final String WILDFIRE_GENDER_MOD_ID = "wildfire_gender";
    public static final String FRAMEDBLOCKS_MOD_ID = "framedblocks";
    public final boolean CCLoaded;
    public final boolean CraftTweakerLoaded;
    public final boolean CuriosLoaded;
    public final boolean DMELoaded;
    public final boolean EmiLoaded;
    public final boolean FluxNetworksLoaded;
    public final boolean GrandPowerLoaded;
    public final boolean JEILoaded;
    public final boolean JsonThingsLoaded;
    public final boolean OC2Loaded;
    public final boolean ProjectELoaded;
    public final boolean RecipeStagesLoaded;
    public final boolean TOPLoaded;
    public final boolean WildfireGenderModLoaded;
    public final boolean FramedBlocksLoaded;

    public MekanismHooks() {
        ModList modList = ModList.get();
        Predicate<String> loadedCheck = modList == null ? modid -> false : arg_0 -> ((ModList)modList).isLoaded(arg_0);
        this.CCLoaded = loadedCheck.test(CC_MOD_ID);
        this.CraftTweakerLoaded = loadedCheck.test(CRAFTTWEAKER_MOD_ID);
        this.CuriosLoaded = loadedCheck.test(CURIOS_MODID);
        this.DMELoaded = loadedCheck.test(DARK_MODE_EVERYWHERE_MODID);
        this.EmiLoaded = loadedCheck.test(EMI_MOD_ID);
        this.FluxNetworksLoaded = loadedCheck.test(FLUX_NETWORKS_MOD_ID);
        this.GrandPowerLoaded = loadedCheck.test(GRAND_POWER_MOD_ID);
        this.JEILoaded = loadedCheck.test(JEI_MOD_ID);
        this.JsonThingsLoaded = loadedCheck.test(JSON_THINGS_MOD_ID);
        this.OC2Loaded = loadedCheck.test(OC2_MOD_ID);
        this.ProjectELoaded = loadedCheck.test(PROJECTE_MOD_ID);
        this.RecipeStagesLoaded = loadedCheck.test(RECIPE_STAGES_MOD_ID);
        this.TOPLoaded = loadedCheck.test(TOP_MOD_ID);
        this.WildfireGenderModLoaded = loadedCheck.test(WILDFIRE_GENDER_MOD_ID);
        this.FramedBlocksLoaded = loadedCheck.test(FRAMEDBLOCKS_MOD_ID);
    }

    public void hookConstructor(IEventBus bus) {
        if (this.CuriosLoaded) {
            CuriosIntegration.addListeners(bus);
        }
        if (this.CraftTweakerLoaded && !DatagenModLoader.isRunningDataGen()) {
            IEventBus crtModEventBus = ModList.get().getModContainerById(CRAFTTWEAKER_MOD_ID).map(ModContainer::getEventBus).orElse(bus);
            crtModEventBus.addListener(EventPriority.LOWEST, CrTContentUtils::registerCrTContent);
        }
        if (this.JsonThingsLoaded) {
            JsonThingsIntegration.hook(bus);
        }
        if (this.ProjectELoaded) {
            MekanismNormalizedSimpleStacks.NSS_SERIALIZERS.register(bus);
        }
        if (this.FramedBlocksLoaded) {
            FramedBlocksIntegration.init(bus);
        }
    }

    public void hookCapabilityRegistration() {
        EnergyCompatUtils.initLoadedCache();
    }

    public void hookCommonSetup() {
        if (this.computerCompatEnabled()) {
            FactoryRegistry.load();
            if (this.CCLoaded) {
                CCCapabilityHelper.registerApis();
            }
        }
        if (ModList.get().isLoaded("fastbench")) {
            NeoForge.EVENT_BUS.addListener(BinInsertRecipe::onCrafting);
        }
    }

    public void sendIMCMessages(InterModEnqueueEvent event) {
        if (this.DMELoaded) {
            this.sendDarkModeEverywhereIMC();
        }
        if (this.TOPLoaded) {
            InterModComms.sendTo((String)TOP_MOD_ID, (String)"getTheOneProbe", TOPProvider::new);
        }
    }

    public boolean computerCompatEnabled() {
        return this.CCLoaded || this.OC2Loaded;
    }

    public boolean recipeViewerCompatEnabled() {
        return this.EmiLoaded || this.JEILoaded;
    }

    private void sendDarkModeEverywhereIMC() {
        List<Supplier<String>> methodBlacklist = List.of(() -> "mekanism.client.gui.GuiUtils:drawTiledSprite", () -> "mekanism.client.render.HUDRenderer:renderCompass", () -> "mekanism.client.render.HUDRenderer:renderHUDElement");
        for (Supplier<String> method : methodBlacklist) {
            InterModComms.sendTo((String)DARK_MODE_EVERYWHERE_MODID, (String)"dme-shaderblacklist", method);
        }
    }
}

