/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.providers.IChemicalProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LazyChemicalProvider
implements IChemicalProvider {
    private Supplier<Chemical> chemicalSupplier;
    private Chemical chemical = MekanismAPI.EMPTY_CHEMICAL;

    public LazyChemicalProvider(ResourceLocation chemicalRegistryName) {
        this(() -> (Chemical)MekanismAPI.CHEMICAL_REGISTRY.get(chemicalRegistryName));
    }

    public LazyChemicalProvider(Supplier<Chemical> chemicalSupplier) {
        this.chemicalSupplier = chemicalSupplier;
    }

    @Override
    @NotNull
    public Chemical getChemical() {
        if (this.chemical.isEmptyType()) {
            this.chemical = this.chemicalSupplier.get().getChemical();
            if (this.chemical.isEmptyType()) {
                throw new IllegalStateException("Empty chemical used for coolant attribute via a CraftTweaker Script.");
            }
            this.chemicalSupplier = null;
        }
        return this.chemical;
    }
}

