/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import mekanism.api.SerializerHelper;
import mekanism.api.text.EnumColor;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransporterStack {
    public static StreamCodec<RegistryFriendlyByteBuf, TransporterStack> STREAM_CODEC = NeoForgeStreamCodecs.composite(EnumColor.OPTIONAL_STREAM_CODEC, stack -> Optional.ofNullable(stack.color), (StreamCodec)ByteBufCodecs.VAR_INT, stack -> stack.progress, (StreamCodec)BlockPos.STREAM_CODEC, stack -> stack.originalLocation, Path.STREAM_CODEC, TransporterStack::getPathType, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_LONG), stack -> stack.clientNext == Long.MAX_VALUE ? Optional.empty() : Optional.of(stack.clientNext), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_LONG), stack -> stack.clientPrev == Long.MAX_VALUE ? Optional.empty() : Optional.of(stack.clientPrev), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, stack -> stack.itemStack, (color, progress, originalLocation, pathType, clientNext, clientPrev, itemStack) -> {
        TransporterStack stack = new TransporterStack();
        stack.color = color.orElse(null);
        stack.progress = progress == 0 ? 5 : progress;
        stack.originalLocation = originalLocation;
        stack.pathType = pathType;
        stack.clientNext = clientNext.orElse(Long.MAX_VALUE);
        stack.clientPrev = clientPrev.orElse(Long.MAX_VALUE);
        stack.itemStack = itemStack;
        return stack;
    });
    public ItemStack itemStack = ItemStack.EMPTY;
    public int progress;
    public EnumColor color = null;
    public boolean initiatedPath = false;
    public Direction idleDir = null;
    public BlockPos originalLocation;
    public BlockPos homeLocation;
    private long clientNext = Long.MAX_VALUE;
    private long clientPrev = Long.MAX_VALUE;
    @Nullable
    private Path pathType;
    private LongList pathToTarget = new LongArrayList();

    public static TransporterStack readFromNBT(HolderLookup.Provider provider, CompoundTag nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.read(provider, nbtTags);
        return stack;
    }

    public static TransporterStack readFromUpdate(HolderLookup.Provider provider, CompoundTag nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.readFromUpdateTag(provider, nbtTags);
        return stack;
    }

    public void writeToUpdateTag(HolderLookup.Provider provider, LogisticalTransporterBase transporter, CompoundTag updateTag) {
        long prev;
        if (this.color != null) {
            NBTUtils.writeEnum(updateTag, "color", this.color);
        }
        updateTag.putInt("progress", this.progress);
        updateTag.put("original_location", NbtUtils.writeBlockPos((BlockPos)this.originalLocation));
        NBTUtils.writeEnum(updateTag, "path_type", this.getPathType());
        long next = this.getNext(transporter);
        if (next != Long.MAX_VALUE) {
            updateTag.putLong("next", next);
        }
        if ((prev = this.getPrev(transporter)) != Long.MAX_VALUE) {
            updateTag.putLong("previous", prev);
        }
        if (!this.itemStack.isEmpty()) {
            updateTag.put("item", SerializerHelper.saveOversized(provider, this.itemStack));
        }
    }

    public void readFromUpdateTag(HolderLookup.Provider provider, CompoundTag updateTag) {
        this.color = NBTUtils.getEnum(updateTag, "color", EnumColor.BY_ID);
        this.progress = updateTag.getInt("progress");
        NBTUtils.setBlockPosIfPresent(updateTag, "original_location", coord -> {
            this.originalLocation = coord;
        });
        NBTUtils.setEnumIfPresent(updateTag, "path_type", Path.BY_ID, type -> {
            this.pathType = type;
        });
        this.clientNext = Long.MAX_VALUE;
        NBTUtils.setLongIfPresent(updateTag, "next", coord -> {
            this.clientNext = coord;
        });
        NBTUtils.setBlockPosIfPresent(updateTag, "next", coord -> {
            this.clientNext = coord.asLong();
        });
        this.clientPrev = Long.MAX_VALUE;
        NBTUtils.setLongIfPresent(updateTag, "previous", coord -> {
            this.clientPrev = coord;
        });
        NBTUtils.setBlockPosIfPresent(updateTag, "previous", coord -> {
            this.clientPrev = coord.asLong();
        });
        Tag itemTag = updateTag.get("item");
        if (itemTag != null) {
            this.itemStack = SerializerHelper.parseOversized(provider, itemTag).orElse(ItemStack.EMPTY);
        }
    }

    public void write(HolderLookup.Provider provider, CompoundTag nbtTags) {
        if (this.color != null) {
            NBTUtils.writeEnum(nbtTags, "color", this.color);
        }
        nbtTags.putInt("progress", this.progress);
        nbtTags.put("original_location", NbtUtils.writeBlockPos((BlockPos)this.originalLocation));
        if (this.idleDir != null) {
            NBTUtils.writeEnum(nbtTags, "idle_dir", this.idleDir);
        }
        if (this.homeLocation != null) {
            nbtTags.put("home_location", NbtUtils.writeBlockPos((BlockPos)this.homeLocation));
        }
        if (this.pathType != null) {
            NBTUtils.writeEnum(nbtTags, "path_type", this.pathType);
        }
        if (!this.itemStack.isEmpty()) {
            nbtTags.put("item_oversized", SerializerHelper.saveOversized(provider, this.itemStack));
        }
    }

    public void read(HolderLookup.Provider provider, CompoundTag nbtTags) {
        this.color = NBTUtils.getEnum(nbtTags, "color", EnumColor.BY_ID);
        this.progress = nbtTags.getInt("progress");
        NBTUtils.setBlockPosIfPresent(nbtTags, "original_location", coord -> {
            this.originalLocation = coord;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "idle_dir", Direction::from3DDataValue, dir -> {
            this.idleDir = dir;
        });
        NBTUtils.setBlockPosIfPresent(nbtTags, "home_location", coord -> {
            this.homeLocation = coord;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "path_type", Path.BY_ID, type -> {
            this.pathType = type;
        });
        this.itemStack = nbtTags.contains("item_oversized") ? SerializerHelper.parseOversized(provider, nbtTags.get("item_oversized")).orElse(ItemStack.EMPTY) : (nbtTags.contains("item", 10) ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTags.getCompound("item")) : ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTags));
    }

    private void setPath(Level world, @NotNull LongList path, @NotNull Path type, boolean updateFlowing) {
        if (updateFlowing && (this.pathType == null || this.pathType.hasTarget())) {
            TransporterManager.remove(world, this);
        }
        this.pathToTarget = path;
        this.pathType = type;
        if (updateFlowing && this.pathType.hasTarget()) {
            TransporterManager.add(world, this);
        }
    }

    public boolean hasPath() {
        return this.pathToTarget.size() >= 2;
    }

    public LongList getPath() {
        return this.pathToTarget;
    }

    public Path getPathType() {
        return this.pathType == null ? Path.NONE : this.pathType;
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min) {
        return this.recalculatePath(request, transporter, min, true);
    }

    public final TransitRequest.TransitResponse recalculatePath(TransitRequest request, BlockEntity ignored, LogisticalTransporterBase transporter, int min, boolean updateFlowing) {
        return this.recalculatePath(request, transporter, min, updateFlowing);
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min, boolean updateFlowing) {
        return this.recalculatePath(request, transporter, min, updateFlowing, Collections.emptyMap());
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min, Map<GlobalPos, Set<TransporterStack>> additionalFlowingStacks) {
        return this.recalculatePath(request, transporter, min, false, additionalFlowingStacks);
    }

    private TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min, boolean updateFlowing, Map<GlobalPos, Set<TransporterStack>> additionalFlowingStacks) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewBasePath(transporter, this, request, min, additionalFlowingStacks);
        if (newPath == null) {
            return request.getEmptyResponse();
        }
        this.idleDir = null;
        this.setPath(transporter.getLevel(), newPath.getPath(), Path.DEST, updateFlowing);
        this.initiatedPath = true;
        return newPath.getResponse();
    }

    public <BE extends BlockEntity> TransitRequest.TransitResponse recalculateRRPath(TransitRequest request, BE outputter, LogisticalTransporterBase transporter, int min) {
        return this.recalculateRRPath(request, outputter, transporter, min, true);
    }

    public <BE extends BlockEntity> TransitRequest.TransitResponse recalculateRRPath(TransitRequest request, BE outputter, LogisticalTransporterBase transporter, int min, boolean updateFlowing) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewRRPath(transporter, this, request, (IAdvancedTransportEjector)outputter, min);
        if (newPath == null) {
            return request.getEmptyResponse();
        }
        this.idleDir = null;
        this.setPath(transporter.getLevel(), newPath.getPath(), Path.DEST, updateFlowing);
        this.initiatedPath = true;
        return newPath.getResponse();
    }

    public boolean calculateIdle(LogisticalTransporterBase transporter) {
        TransporterPathfinder.IdlePathData newPath = TransporterPathfinder.getIdlePath(transporter, this);
        if (newPath == null) {
            return false;
        }
        if (newPath.type().isHome()) {
            this.idleDir = null;
        }
        this.setPath(transporter.getLevel(), newPath.path(), newPath.type(), true);
        this.originalLocation = transporter.getBlockPos();
        this.initiatedPath = true;
        return true;
    }

    public boolean isFinal(LogisticalTransporterBase transporter) {
        return this.pathToTarget.indexOf(transporter.getBlockPos().asLong()) == (this.getPathType().hasTarget() ? 1 : 0);
    }

    public TransporterStack updateForPos(BlockPos pos) {
        this.clientNext = this.getNext(pos);
        this.clientPrev = this.getPrev(pos.asLong());
        return this;
    }

    public long getNext(LogisticalTransporterBase transporter) {
        return transporter.isRemote() ? this.clientNext : this.getNext(transporter.getBlockPos());
    }

    private long getNext(BlockPos pos) {
        int index = this.pathToTarget.indexOf(pos.asLong()) - 1;
        if (index < 0) {
            return Long.MAX_VALUE;
        }
        return this.pathToTarget.getLong(index);
    }

    public long getPrev(LogisticalTransporterBase transporter) {
        return transporter.isRemote() ? this.clientPrev : this.getPrev(transporter.getBlockPos().asLong());
    }

    private long getPrev(long pos) {
        int index = this.pathToTarget.indexOf(pos) + 1;
        if (index < this.pathToTarget.size()) {
            return this.pathToTarget.getLong(index);
        }
        return this.originalLocation.asLong();
    }

    public Direction getSide(LogisticalTransporterBase transporter) {
        Direction side = null;
        if (this.progress < 50) {
            long prev = this.getPrev(transporter);
            if (prev != Long.MAX_VALUE) {
                side = WorldUtils.sideDifference(transporter.getBlockPos().asLong(), prev);
            }
        } else {
            long next = this.getNext(transporter);
            if (next != Long.MAX_VALUE) {
                side = WorldUtils.sideDifference(next, transporter.getBlockPos().asLong());
            }
        }
        return side == null ? Direction.DOWN : side;
    }

    public Direction getSide(BlockPos pos, long target) {
        Direction side = null;
        if (target != Long.MAX_VALUE) {
            side = WorldUtils.sideDifference(target, pos.asLong());
        }
        return side == null ? Direction.DOWN : side;
    }

    @Contract(value="null, _, _ -> false")
    public boolean canInsertToTransporter(@Nullable LogisticalTransporterBase transmitter, Direction from, @Nullable LogisticalTransporterBase transporterFrom) {
        return transmitter != null && this.canInsertToTransporterNN(transmitter, from, transporterFrom);
    }

    public boolean canInsertToTransporterNN(@NotNull LogisticalTransporterBase transporter, Direction from, @Nullable BlockEntity tileFrom) {
        EnumColor color = transporter.getColor();
        return (color == null || color == this.color) && transporter.canConnectMutual(from.getOpposite(), tileFrom);
    }

    public boolean canInsertToTransporterNN(@NotNull LogisticalTransporterBase transporter, Direction from, @Nullable LogisticalTransporterBase transporterFrom) {
        EnumColor color = transporter.getColor();
        return (color == null || color == this.color) && transporter.canConnectMutual(from.getOpposite(), transporterFrom);
    }

    public long getDest() {
        return (Long)this.pathToTarget.getFirst();
    }

    @Nullable
    public Direction getSideOfDest() {
        if (this.hasPath()) {
            long lastTransporter = this.pathToTarget.getLong(1);
            return WorldUtils.sideDifference(lastTransporter, this.getDest());
        }
        return null;
    }

    public static enum Path {
        DEST,
        HOME,
        NONE;

        public static final IntFunction<Path> BY_ID;
        public static final StreamCodec<ByteBuf, Path> STREAM_CODEC;

        public boolean hasTarget() {
            return this != NONE;
        }

        public boolean noTarget() {
            return this == NONE;
        }

        public boolean isHome() {
            return this == HOME;
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Path.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

