/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.CompatibleTransmitterValidator;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tier.PipeTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.MechanicalPipeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MechanicalPipe
extends BufferedTransmitter<IFluidHandler, FluidNetwork, FluidStack, MechanicalPipe>
implements IMekanismFluidHandler,
IUpgradeableTransmitter<MechanicalPipeUpgradeData> {
    public final PipeTier tier;
    @NotNull
    public FluidStack saveShare = FluidStack.EMPTY;
    private final List<IExtendedFluidTank> tanks;
    public final BasicFluidTank buffer;

    public MechanicalPipe(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(tile, TransmissionType.FLUID);
        this.tier = Attribute.getTier(blockProvider, PipeTier.class);
        this.buffer = BasicFluidTank.create(MathUtils.clampToInt(this.getCapacity()), BasicFluidTank.alwaysFalse, BasicFluidTank.alwaysTrue, this);
        this.tanks = Collections.singletonList(this.buffer);
    }

    @Override
    protected AbstractAcceptorCache<IFluidHandler, ?> createAcceptorCache() {
        return new AcceptorCache<IFluidHandler>(this.getTransmitterTile(), Capabilities.FLUID.block());
    }

    public AcceptorCache<IFluidHandler> getAcceptorCache() {
        return (AcceptorCache)super.getAcceptorCache();
    }

    @Override
    public PipeTier getTier() {
        return this.tier;
    }

    @Override
    public void pullFromAcceptors() {
        if (!this.hasPullSide || this.getAvailablePull() <= 0) {
            return;
        }
        AbstractAcceptorCache acceptorCache = this.getAcceptorCache();
        for (Direction side : EnumUtils.DIRECTIONS) {
            FluidStack bufferWithFallback;
            FluidStack received;
            IFluidHandler connectedAcceptor;
            if (!this.isConnectionType(side, ConnectionType.PULL) || (connectedAcceptor = (IFluidHandler)acceptorCache.getConnectedAcceptor(side)) == null || (received = (bufferWithFallback = this.getBufferWithFallback()).isEmpty() ? connectedAcceptor.drain(this.getAvailablePull(), IFluidHandler.FluidAction.SIMULATE) : connectedAcceptor.drain(bufferWithFallback.copyWithAmount(this.getAvailablePull()), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || !this.takeFluid(received, Action.SIMULATE).isEmpty()) continue;
            this.takeFluid(connectedAcceptor.drain(received, IFluidHandler.FluidAction.EXECUTE), Action.EXECUTE);
        }
    }

    private int getAvailablePull() {
        if (this.hasTransmitterNetwork()) {
            return Math.min(this.tier.getPipePullAmount(), ((FluidNetwork)this.getTransmitterNetwork()).fluidTank.getNeeded());
        }
        return Math.min(this.tier.getPipePullAmount(), this.buffer.getNeeded());
    }

    @Override
    @Nullable
    public MechanicalPipeUpgradeData getUpgradeData() {
        return new MechanicalPipeUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.getShare());
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return data instanceof MechanicalPipeUpgradeData;
    }

    @Override
    public void parseUpgradeData(@NotNull MechanicalPipeUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.takeFluid(data.contents, Action.EXECUTE);
    }

    @Override
    public void read(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.read(provider, nbtTags);
        this.saveShare = nbtTags.contains("fluid", 10) ? FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTags.getCompound("fluid")) : FluidStack.EMPTY;
        this.buffer.setStack(this.saveShare);
    }

    @Override
    @NotNull
    public CompoundTag write(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.write(provider, nbtTags);
        if (this.hasTransmitterNetwork()) {
            ((FluidNetwork)this.getTransmitterNetwork()).validateSaveShares(this);
        }
        if (this.saveShare.isEmpty()) {
            nbtTags.remove("fluid");
        } else {
            nbtTags.put("fluid", this.saveShare.save(provider));
        }
        return nbtTags;
    }

    @Override
    public CompatibleTransmitterValidator<IFluidHandler, FluidNetwork, MechanicalPipe> getNewOrphanValidator() {
        return new CompatibleTransmitterValidator.CompatibleFluidTransmitterValidator(this);
    }

    @Override
    public boolean isValidTransmitter(TileEntityTransmitter transmitter, Direction side) {
        Transmitter<?, ?, ?> transmitter2;
        if (super.isValidTransmitter(transmitter, side) && (transmitter2 = transmitter.getTransmitter()) instanceof MechanicalPipe) {
            FluidStack otherBuffer;
            MechanicalPipe other = (MechanicalPipe)transmitter2;
            FluidStack buffer = this.getBufferWithFallback();
            if (buffer.isEmpty() && this.hasTransmitterNetwork() && ((FluidNetwork)this.getTransmitterNetwork()).getPrevTransferAmount() > 0) {
                buffer = ((FluidNetwork)this.getTransmitterNetwork()).lastFluid;
            }
            if ((otherBuffer = other.getBufferWithFallback()).isEmpty() && other.hasTransmitterNetwork() && ((FluidNetwork)other.getTransmitterNetwork()).getPrevTransferAmount() > 0) {
                otherBuffer = ((FluidNetwork)other.getTransmitterNetwork()).lastFluid;
            }
            return buffer.isEmpty() || otherBuffer.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)buffer, (FluidStack)otherBuffer);
        }
        return false;
    }

    @Override
    public FluidNetwork createEmptyNetworkWithID(UUID networkID) {
        return new FluidNetwork(networkID);
    }

    @Override
    public FluidNetwork createNetworkByMerging(Collection<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @Override
    protected boolean canHaveIncompatibleNetworks() {
        return true;
    }

    @Override
    public long getCapacity() {
        return this.tier.getPipeCapacity();
    }

    @Override
    @NotNull
    public FluidStack releaseShare() {
        FluidStack ret = this.buffer.getFluid();
        this.buffer.setEmpty();
        return ret;
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback().isEmpty();
    }

    @Override
    @NotNull
    public FluidStack getBufferWithFallback() {
        FluidStack buffer = this.getShare();
        if (buffer.isEmpty() && this.hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    @NotNull
    public FluidStack getShare() {
        return this.buffer.getFluid();
    }

    @Override
    public void takeShare() {
        if (this.hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitterNetwork();
            if (!network.fluidTank.isEmpty() && !this.saveShare.isEmpty()) {
                int amount = this.saveShare.getAmount();
                MekanismUtils.logMismatchedStackSize(network.fluidTank.shrinkStack(amount, Action.EXECUTE), amount);
                this.buffer.setStack(this.saveShare);
            }
        }
    }

    @Override
    @NotNull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitterNetwork()).getFluidTanks(side);
        }
        return this.tanks;
    }

    @Override
    public void onContentsChanged() {
        this.getTransmitterTile().setChanged();
    }

    @NotNull
    public FluidStack takeFluid(@NotNull FluidStack fluid, Action action) {
        if (this.hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitterNetwork()).fluidTank.insert(fluid, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(fluid, action, AutomationType.INTERNAL);
    }

    @Override
    protected void handleContentsUpdateTag(@NotNull FluidNetwork network, @NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleContentsUpdateTag(network, tag, provider);
        NBTUtils.setFluidStackIfPresent(provider, tag, "fluid", network::setLastFluid);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.currentScale = scale;
        });
    }
}

