/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiversionTransporter
extends LogisticalTransporterBase {
    public final DiversionControl[] modes = new DiversionControl[EnumUtils.DIRECTIONS.length];
    @Nullable
    private Boolean wasGettingPower;

    public DiversionTransporter(TileEntityTransmitter tile) {
        super(tile, TransporterTier.BASIC);
        Arrays.fill(this.modes, DiversionControl.DISABLED);
    }

    @Override
    public void onNeighborBlockChange(Direction side) {
        boolean receivingPower = this.isGettingPowered();
        if (this.wasGettingPower == null || this.wasGettingPower != receivingPower) {
            this.wasGettingPower = receivingPower;
            byte current = this.getAllCurrentConnections();
            this.refreshConnections();
            if (current != this.getAllCurrentConnections()) {
                this.markDirtyTransmitters();
            }
            TileEntityTransmitter transmitterTile = this.getTransmitterTile();
            for (Direction direction : EnumUtils.DIRECTIONS) {
                if (!super.exposesInsertCap(direction)) continue;
                if (this.modeReqsMet(direction)) {
                    transmitterTile.invalidateCapabilities();
                    continue;
                }
                transmitterTile.invalidateCapability(Capabilities.ITEM.block(), direction);
            }
        } else {
            this.refreshConnections(side);
        }
    }

    private void readModes(@NotNull CompoundTag tag) {
        if (tag.contains("mode", 11)) {
            int[] modeIndices = tag.getIntArray("mode");
            for (int i = 0; i < modeIndices.length && i < this.modes.length; ++i) {
                this.modes[i] = DiversionControl.BY_ID.apply(modeIndices[i]);
            }
        }
    }

    @NotNull
    private CompoundTag writeModes(@NotNull CompoundTag nbtTags) {
        int[] modeIndices = new int[this.modes.length];
        for (int i = 0; i < this.modes.length; ++i) {
            modeIndices[i] = this.modes[i].ordinal();
        }
        nbtTags.putIntArray("mode", modeIndices);
        return nbtTags;
    }

    @Override
    public void read(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.read(provider, nbtTags);
        this.readModes(nbtTags);
    }

    @Override
    @NotNull
    public CompoundTag write(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        return this.writeModes(super.write(provider, nbtTags));
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider, CompoundTag updateTag) {
        return this.writeModes(super.getReducedUpdateTag(provider, updateTag));
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.readModes(tag);
    }

    public void updateMode(Direction side, DiversionControl mode) {
        int ordinal = side.ordinal();
        DiversionControl oldMode = this.modes[ordinal];
        if (oldMode != mode) {
            boolean nowExposes;
            this.modes[ordinal] = mode;
            TileEntityTransmitter transmitterTile = this.getTransmitterTile();
            if (super.exposesInsertCap(side) && (nowExposes = this.modeReqsMet(mode)) != this.modeReqsMet(oldMode)) {
                if (nowExposes) {
                    transmitterTile.invalidateCapabilities();
                } else {
                    transmitterTile.invalidateCapability(Capabilities.ITEM.block(), side);
                }
            }
            this.refreshConnections();
            this.notifyTileChange();
            transmitterTile.sendUpdatePacket();
        }
    }

    @Override
    public InteractionResult onRightClick(Player player, Direction side) {
        side = this.getTransmitterTile().getSideLookingAt(player, side);
        DiversionControl newMode = (DiversionControl)this.modes[side.ordinal()].getNext();
        this.updateMode(side, newMode);
        player.displayClientMessage((Component)MekanismLang.TOGGLE_DIVERTER.translateColored(EnumColor.GRAY, EnumColor.RED, newMode), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean exposesInsertCap(@NotNull Direction side) {
        return super.exposesInsertCap(side) && this.modeReqsMet(side);
    }

    @Override
    public boolean canConnect(Direction side) {
        return super.canConnect(side) && this.modeReqsMet(side);
    }

    private boolean modeReqsMet(Direction side) {
        return this.modeReqsMet(this.modes[side.ordinal()]);
    }

    private boolean modeReqsMet(DiversionControl mode) {
        return switch (mode.ordinal()) {
            case 1 -> this.isGettingPowered();
            case 2 -> {
                if (!this.isGettingPowered()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private boolean isGettingPowered() {
        return WorldUtils.isGettingPowered(this.getLevel(), this.getBlockPos());
    }

    @NothingNullByDefault
    public static enum DiversionControl implements IIncrementalEnum<DiversionControl>,
    IHasTextComponent.IHasEnumNameTextComponent
    {
        DISABLED(MekanismLang.DIVERSION_CONTROL_DISABLED),
        HIGH(MekanismLang.DIVERSION_CONTROL_HIGH),
        LOW(MekanismLang.DIVERSION_CONTROL_LOW);

        public static final IntFunction<DiversionControl> BY_ID;
        public static final StreamCodec<ByteBuf, DiversionControl> STREAM_CODEC;
        private final ILangEntry langEntry;

        private DiversionControl(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate();
        }

        @Override
        public DiversionControl byIndex(int index) {
            return BY_ID.apply(index);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DiversionControl.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

