/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

@ParametersAreNotNullByDefault
public record ModuleLocomotiveBoostingUnit(SprintBoost sprintBoost) implements ICustomModule<ModuleLocomotiveBoostingUnit>
{
    public static final ResourceLocation SPRINT_BOOST = Mekanism.rl("sprint_boost");

    public ModuleLocomotiveBoostingUnit(IModule<ModuleLocomotiveBoostingUnit> module) {
        this((SprintBoost)module.getConfigOrThrow(SPRINT_BOOST).get());
    }

    @Override
    public void changeMode(IModule<ModuleLocomotiveBoostingUnit> module, Player player, IModuleContainer moduleContainer, ItemStack stack, int shift, boolean displayChangeMessage) {
        SprintBoost newMode = this.sprintBoost.adjust(shift, v -> v.ordinal() < module.getInstalledCount() + 1);
        if (this.sprintBoost != newMode) {
            if (displayChangeMessage) {
                module.displayModeChange(player, (Component)MekanismLang.MODULE_SPRINT_BOOST.translate(), newMode);
            }
            moduleContainer.replaceModuleConfig((HolderLookup.Provider)player.level().registryAccess(), stack, module.getData(), module.getConfigOrThrow(SPRINT_BOOST).with(newMode));
        }
    }

    @Override
    public void tickServer(IModule<ModuleLocomotiveBoostingUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        if (this.tick(module, stack, player)) {
            module.useEnergy((LivingEntity)player, stack, MathUtils.clampToLong((double)((float)MekanismConfig.gear.mekaSuitEnergyUsageSprintBoost.get() * this.sprintBoost.getBoost()) / 0.1));
        }
    }

    @Override
    public void tickClient(IModule<ModuleLocomotiveBoostingUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        this.tick(module, stack, player);
    }

    private boolean tick(IModule<ModuleLocomotiveBoostingUnit> module, ItemStack stack, Player player) {
        if (this.canFunction(module, stack, player)) {
            float boost = this.sprintBoost.getBoost();
            if (!player.onGround()) {
                boost /= 5.0f;
            }
            if (player.isInWater()) {
                boost /= 5.0f;
            }
            player.moveRelative(boost, new Vec3(0.0, 0.0, 1.0));
            return true;
        }
        return false;
    }

    public boolean canFunction(IModule<ModuleLocomotiveBoostingUnit> module, ItemStack stack, Player player) {
        return !player.isFallFlying() && player.isSprinting() && module.canUseEnergy((LivingEntity)player, stack, MathUtils.clampToLong((double)((float)MekanismConfig.gear.mekaSuitEnergyUsageSprintBoost.get() * this.sprintBoost.getBoost()) / 0.1));
    }

    @NothingNullByDefault
    public static enum SprintBoost implements IHasTextComponent,
    IIncrementalEnum<SprintBoost>,
    StringRepresentable
    {
        OFF(0.0f),
        LOW(0.05f),
        MED(0.1f),
        HIGH(0.25f),
        ULTRA(0.5f);

        public static final Codec<SprintBoost> CODEC;
        public static final IntFunction<SprintBoost> BY_ID;
        public static final StreamCodec<ByteBuf, SprintBoost> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final float boost;
        private final Component label;

        private SprintBoost(float boost) {
            this.boost = boost;
            this.label = TextComponentUtil.getString(Float.toString(boost));
        }

        @Override
        public SprintBoost byIndex(int index) {
            return BY_ID.apply(index);
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public float getBoost() {
            return this.boost;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(SprintBoost::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])SprintBoost.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

