/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedEnumValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedBooleanValue whiteRadialText;
    public final CachedIntValue energyColor;
    public final CachedBooleanValue allowModeScroll;
    public final CachedBooleanValue opaqueTransmitters;
    public final CachedIntValue berRange;
    public final CachedFloatValue baseSoundVolume;
    public final CachedBooleanValue enablePlayerSounds;
    public final CachedBooleanValue enableMachineSounds;
    public final CachedBooleanValue enableMultiblockFormationParticles;
    public final CachedBooleanValue machineEffects;
    public final CachedIntValue radiationParticleRadius;
    public final CachedIntValue radiationParticleCount;
    public final CachedBooleanValue renderMagneticAttractionParticles;
    public final CachedBooleanValue renderToolAOEParticles;
    public final CachedBooleanValue enableHUD;
    public final CachedFloatValue hudScale;
    public final CachedBooleanValue reverseHUD;
    public final CachedFloatValue hudOpacity;
    public final CachedIntValue hudColor;
    public final CachedIntValue hudWarningColor;
    public final CachedIntValue hudDangerColor;
    public final CachedFloatValue hudJitter;
    public final CachedBooleanValue hudCompassEnabled;
    public final CachedEnumValue<QIOItemViewerContainer.ListSortType> qioItemViewerSortType;
    public final CachedEnumValue<QIOItemViewerContainer.SortDirection> qioItemViewerSortDirection;
    public final CachedIntValue qioItemViewerSlotsX;
    public final CachedIntValue qioItemViewerSlotsY;
    public final CachedBooleanValue qioAutoFocusSearchBar;
    public final CachedBooleanValue qioRejectsToInventory;
    public final Map<String, SelectedWindowData.CachedWindowPosition> lastWindowPositions = new HashMap<String, SelectedWindowData.CachedWindowPosition>();

    ClientConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        MekanismConfigTranslations.CLIENT_ACCESSIBILITY.applyToBuilder(builder).push("accessibility");
        this.whiteRadialText = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_WHITE_RADIAL_TEXT.applyToBuilder(builder).define("whiteRadialText", false));
        this.opaqueTransmitters = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_OPAQUE_TRANSMITTERS.applyToBuilder(builder).gameRestart().define("opaqueTransmitters", false));
        this.allowModeScroll = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_SCROLL_MODE_CHANGE.applyToBuilder(builder).define("allowModeScroll", true));
        builder.pop();
        MekanismConfigTranslations.CLIENT_SOUNDS.applyToBuilder(builder).push("sounds");
        this.baseSoundVolume = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.CLIENT_BASE_SOUND_VOLUME.applyToBuilder(builder).defineInRange("baseVolume", 1.0, 0.0, 10.0));
        this.enablePlayerSounds = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_PLAYER_SOUNDS_ENABLED.applyToBuilder(builder).define("enablePlayer", true));
        this.enableMachineSounds = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_MACHINE_SOUNDS_ENABLED.applyToBuilder(builder).define("enableMachine", true));
        builder.pop();
        MekanismConfigTranslations.CLIENT_RENDERING.applyToBuilder(builder).push("rendering");
        this.energyColor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_ENERGY_COLOR.applyToBuilder(builder).define("energyColor", (Object)3997338));
        this.berRange = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_BE_RENDER_RANGE.applyToBuilder(builder).defineInRange("berRange", 256, 1, 1024));
        MekanismConfigTranslations.CLIENT_PARTICLE.applyToBuilder(builder).push("particle");
        this.enableMultiblockFormationParticles = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_PARTICLE_MULTIBLOCK_FORMATION.applyToBuilder(builder).define("multiblockFormation", true));
        this.machineEffects = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_PARTICLE_MACHINE_EFFECTS.applyToBuilder(builder).define("machineEffects", true));
        this.radiationParticleRadius = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_PARTICLE_RADIATION_RADIUS.applyToBuilder(builder).defineInRange("radiationParticleRadius", 30, 2, 64));
        this.radiationParticleCount = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_PARTICLE_RADIATION_COUNT.applyToBuilder(builder).defineInRange("radiationParticleCount", 100, 0, 1000));
        this.renderMagneticAttractionParticles = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_PARTICLE_MAGNETIC_ATTRACTION.applyToBuilder(builder).define("magneticAttraction", true));
        this.renderToolAOEParticles = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_PARTICLE_TOOL_AOE.applyToBuilder(builder).define("toolAOE", true));
        builder.pop();
        builder.pop();
        MekanismConfigTranslations.CLIENT_HUD.applyToBuilder(builder).push("hud");
        this.enableHUD = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_HUD_ENABLED.applyToBuilder(builder).define("enabled", true));
        this.hudScale = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.CLIENT_HUD_SCALE.applyToBuilder(builder).defineInRange("scale", 0.6, 0.25, 1.0));
        this.reverseHUD = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_HUD_REVERSE.applyToBuilder(builder).define("reverse", false));
        this.hudOpacity = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.CLIENT_HUD_OPACITY.applyToBuilder(builder).defineInRange("opacity", (double)0.4f, 0.0, 1.0));
        this.hudColor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_HUD_COLOR.applyToBuilder(builder).defineInRange("color", 4257264, 0, 0xFFFFFF));
        this.hudWarningColor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_HUD_COLOR_WARNING.applyToBuilder(builder).defineInRange("warningColor", 0xFFDD4F, 0, 0xFFFFFF));
        this.hudDangerColor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_HUD_COLOR_DANGER.applyToBuilder(builder).defineInRange("dangerColor", 16726076, 0, 0xFFFFFF));
        this.hudJitter = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.CLIENT_HUD_JITTER.applyToBuilder(builder).defineInRange("jitter", 6.0, 1.0, 100.0));
        this.hudCompassEnabled = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_HUD_COMPASS.applyToBuilder(builder).define("mekaSuitHelmetCompass", true));
        builder.pop();
        MekanismConfigTranslations.CLIENT_QIO.applyToBuilder(builder).push("qio");
        this.qioItemViewerSortType = CachedEnumValue.wrap((IMekanismConfig)this, MekanismConfigTranslations.CLIENT_QIO_SORT_TYPE.applyToBuilder(builder).defineEnum("sortType", (Enum)QIOItemViewerContainer.ListSortType.NAME));
        this.qioItemViewerSortDirection = CachedEnumValue.wrap((IMekanismConfig)this, MekanismConfigTranslations.CLIENT_QIO_SORT_DIRECTION.applyToBuilder(builder).defineEnum("sortDirection", (Enum)QIOItemViewerContainer.SortDirection.ASCENDING));
        this.qioItemViewerSlotsX = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_QIO_SLOTS_X.applyToBuilder(builder).defineInRange("slotsWide", 8, 8, 16));
        this.qioItemViewerSlotsY = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_QIO_SLOTS_Y.applyToBuilder(builder).defineInRange("slotsTall", 4, 2, 48));
        this.qioAutoFocusSearchBar = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_QIO_AUTO_FOCUS.applyToBuilder(builder).define("autoFocusSearchBar", true));
        this.qioRejectsToInventory = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_QIO_REJECTS_DESTINATION.applyToBuilder(builder).define("rejectsToInventory", false));
        builder.pop();
        MekanismConfigTranslations.CLIENT_LAST_WINDOW_POSITIONS.applyToBuilder(builder).push("window");
        for (SelectedWindowData.WindowType windowType : SelectedWindowData.WindowType.values()) {
            for (SelectedWindowData.WindowType.ConfigSaveData saveData : windowType.getSavePaths()) {
                saveData.applyToBuilder(builder).push(saveData.savePath());
                this.lastWindowPositions.put(saveData.savePath(), new SelectedWindowData.CachedWindowPosition(CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_LAST_WINDOW_POSITIONS_X.applyToBuilder(builder).define("x", (Object)Integer.MAX_VALUE)), CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.CLIENT_LAST_WINDOW_POSITIONS_Y.applyToBuilder(builder).define("y", (Object)Integer.MAX_VALUE)), windowType.canPin() ? CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.CLIENT_LAST_WINDOW_POSITIONS_PINNED.applyToBuilder(builder).define("pinned", false)) : null));
                builder.pop();
            }
        }
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "client";
    }

    @Override
    public String getTranslation() {
        return "Client Config";
    }

    @Override
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }
}

