/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.function.Predicate;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;

public class ChunkCommand {
    private static final LongSet chunkWatchers = new LongOpenHashSet();

    private ChunkCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        NeoForge.EVENT_BUS.register(ChunkCommand.class);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chunk").requires((Predicate)MekanismPermissions.COMMAND_CHUNK)).then(WatchCommand.register())).then(UnwatchCommand.register())).then(ClearCommand.register())).then(FlushCommand.register());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, MekanismLang.COMMAND_CHUNK_LOADED);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, MekanismLang.COMMAND_CHUNK_UNLOADED);
    }

    private static void handleChunkEvent(ChunkEvent event, ILangEntry direction) {
        if (event.getLevel() == null || event.getLevel().isClientSide()) {
            return;
        }
        ChunkPos pos = event.getChunk().getPos();
        if (chunkWatchers.contains(pos.toLong())) {
            MutableComponent message = direction.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(pos));
            for (Player player : event.getLevel().players()) {
                player.sendSystemMessage((Component)message);
            }
        }
    }

    private static Component getPosition(ChunkPos pos) {
        return MekanismLang.GENERIC_WITH_COMMA.translate(pos.x, pos.z);
    }

    private static class WatchCommand {
        private WatchCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"watch").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_WATCH)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                return WatchCommand.watch(source, new ChunkPos(BlockPos.containing((Position)source.getPosition())));
            })).then(Commands.argument((String)"pos", (ArgumentType)ColumnPosArgument.columnPos()).executes(ctx -> {
                ColumnPos column = ColumnPosArgument.getColumnPos((CommandContext)ctx, (String)"pos");
                return WatchCommand.watch((CommandSourceStack)ctx.getSource(), column.toChunkPos());
            }));
        }

        private static int watch(CommandSourceStack source, ChunkPos chunkPos) {
            chunkWatchers.add(ChunkPos.asLong((int)chunkPos.x, (int)chunkPos.z));
            source.sendSuccess(() -> MekanismLang.COMMAND_CHUNK_WATCH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(chunkPos)), true);
            return 0;
        }
    }

    private static class UnwatchCommand {
        private UnwatchCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unwatch").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_UNWATCH)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                return UnwatchCommand.unwatch(source, new ChunkPos(BlockPos.containing((Position)source.getPosition())));
            })).then(Commands.argument((String)"pos", (ArgumentType)ColumnPosArgument.columnPos()).executes(ctx -> {
                ColumnPos column = ColumnPosArgument.getColumnPos((CommandContext)ctx, (String)"pos");
                return UnwatchCommand.unwatch((CommandSourceStack)ctx.getSource(), column.toChunkPos());
            }));
        }

        private static int unwatch(CommandSourceStack source, ChunkPos chunkPos) {
            chunkWatchers.remove(ChunkPos.asLong((int)chunkPos.x, (int)chunkPos.z));
            source.sendSuccess(() -> MekanismLang.COMMAND_CHUNK_UNWATCH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(chunkPos)), true);
            return 0;
        }
    }

    private static class ClearCommand {
        private ClearCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"clear").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_CLEAR)).executes(ctx -> {
                int count = chunkWatchers.size();
                chunkWatchers.clear();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> MekanismLang.COMMAND_CHUNK_CLEAR.translateColored(EnumColor.GRAY, EnumColor.INDIGO, count), true);
                return 0;
            });
        }
    }

    private static class FlushCommand {
        private FlushCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"flush").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_FLUSH)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerChunkCache sp = source.getLevel().getChunkSource();
                int startCount = sp.getLoadedChunksCount();
                sp.tick(() -> false, false);
                source.sendSuccess(() -> MekanismLang.COMMAND_CHUNK_FLUSH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, startCount - sp.getLoadedChunksCount()), true);
                return 0;
            });
        }
    }
}

