/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.item;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CursedTransporterItemHandler
implements IItemHandler {
    private final Map<GlobalPos, Set<TransporterStack>> simulatedFlowingStacks = new Object2ObjectOpenHashMap();
    private final Set<ItemStack> seenStacks = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<ItemStack> seenExecutedStacks = Collections.newSetFromMap(new IdentityHashMap());
    private final LogisticalTransporterBase transporter;
    private final LongSupplier currentTickSupplier;
    private final BlockPos fromPos;
    private long lastTick;

    public CursedTransporterItemHandler(LogisticalTransporterBase transporter, BlockPos fromPos, LongSupplier currentTickSupplier) {
        this.transporter = transporter;
        this.fromPos = fromPos;
        this.currentTickSupplier = currentTickSupplier;
    }

    public int getSlots() {
        return 9;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.EMPTY;
    }

    private TransitRequest getRequest(int limit, ItemStack stack) {
        if (stack.getCount() <= limit) {
            return TransitRequest.simple(stack);
        }
        return TransitRequest.simple(stack.copyWithCount(limit));
    }

    public LogisticalTransporterBase getTransporter() {
        return this.transporter;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack itemStack, boolean simulate) {
        TransitRequest.TransitResponse response;
        if (itemStack.isEmpty() || !this.transporter.hasTransmitterNetwork()) {
            return itemStack;
        }
        long currentTick = this.currentTickSupplier.getAsLong();
        if (currentTick != this.lastTick) {
            this.seenStacks.clear();
            this.seenExecutedStacks.clear();
            this.simulatedFlowingStacks.clear();
            this.lastTick = currentTick;
        }
        int limit = this.getSlotLimit(slot);
        if (simulate) {
            if (this.seenExecutedStacks.contains(itemStack) || !this.seenStacks.add(itemStack)) {
                return itemStack;
            }
            request = this.getRequest(limit, itemStack);
            TransporterStack stack = this.transporter.createInsertStack(this.fromPos, this.transporter.getColor());
            response = stack.recalculatePath(request, this.transporter, 1, this.simulatedFlowingStacks);
            if (response.isEmpty()) {
                return itemStack;
            }
            stack.itemStack = response.getStack();
            if (stack.getPathType().hasTarget()) {
                this.simulatedFlowingStacks.computeIfAbsent(GlobalPos.of((ResourceKey)this.transporter.getLevel().dimension(), (BlockPos)BlockPos.of((long)stack.getDest())), k -> new ObjectOpenHashSet()).add(stack);
            }
        } else {
            if (!this.seenExecutedStacks.add(itemStack)) {
                return itemStack;
            }
            this.seenStacks.clear();
            this.simulatedFlowingStacks.clear();
            request = this.getRequest(limit, itemStack);
            response = this.transporter.insertUnchecked(this.fromPos, request, this.transporter.getColor(), true, 1);
            if (response.isEmpty()) {
                return itemStack;
            }
        }
        ItemStack remainder = response.getRejected();
        if (itemStack.getCount() > limit) {
            int extra = itemStack.getCount() - limit;
            if (remainder.isEmpty()) {
                remainder = itemStack.copyWithCount(extra);
            } else {
                remainder.grow(extra);
            }
        }
        if (!remainder.isEmpty()) {
            if (simulate) {
                this.seenStacks.add(remainder);
            } else {
                this.seenExecutedStacks.add(remainder);
            }
        }
        return remainder;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return this.transporter.tier.getPullAmount();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }
}

