/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@NothingNullByDefault
public class BasicEnergyContainer
implements IEnergyContainer {
    public static final Predicate<@NotNull AutomationType> alwaysTrue = ConstantPredicates.alwaysTrue();
    public static final Predicate<@NotNull AutomationType> alwaysFalse = ConstantPredicates.alwaysFalse();
    public static final Predicate<@NotNull AutomationType> internalOnly = automationType -> automationType == AutomationType.INTERNAL;
    public static final Predicate<@NotNull AutomationType> manualOnly = automationType -> automationType == AutomationType.MANUAL;
    public static final Predicate<@NotNull AutomationType> notExternal = automationType -> automationType != AutomationType.EXTERNAL;
    private long stored = 0L;
    protected final Predicate<@NotNull AutomationType> canExtract;
    protected final Predicate<@NotNull AutomationType> canInsert;
    private final long maxEnergy;
    @Nullable
    private final IContentsListener listener;

    public static BasicEnergyContainer create(long maxEnergy, @Nullable IContentsListener listener) {
        return new BasicEnergyContainer(maxEnergy, alwaysTrue, alwaysTrue, listener);
    }

    public static BasicEnergyContainer input(long maxEnergy, @Nullable IContentsListener listener) {
        return new BasicEnergyContainer(maxEnergy, notExternal, alwaysTrue, listener);
    }

    public static BasicEnergyContainer output(long maxEnergy, @Nullable IContentsListener listener) {
        return new BasicEnergyContainer(maxEnergy, alwaysTrue, internalOnly, listener);
    }

    public static BasicEnergyContainer create(long maxEnergy, Predicate<@NotNull AutomationType> canExtract, Predicate<@NotNull AutomationType> canInsert, @Nullable IContentsListener listener) {
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        return new BasicEnergyContainer(maxEnergy, canExtract, canInsert, listener);
    }

    protected BasicEnergyContainer(long maxEnergy, Predicate<@NotNull AutomationType> canExtract, Predicate<@NotNull AutomationType> canInsert, @Nullable IContentsListener listener) {
        this.maxEnergy = maxEnergy;
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.listener = listener;
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    public long getEnergy() {
        return this.stored;
    }

    protected long clampEnergy(long energy) {
        return Math.min(energy, this.getMaxEnergy());
    }

    @Override
    public void setEnergy(long energy) {
        Preconditions.checkArgument((energy >= 0L ? 1 : 0) != 0, (Object)"Energy cannot be negative");
        energy = this.clampEnergy(energy);
        if (this.stored != energy) {
            this.stored = energy;
            this.onContentsChanged();
        }
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getInsertRate(@Nullable AutomationType automationType) {
        return Long.MAX_VALUE;
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getExtractRate(@Nullable AutomationType automationType) {
        return Long.MAX_VALUE;
    }

    @Override
    public long insert(long amount, Action action, AutomationType automationType) {
        if (amount <= 0L || !this.canInsert.test(automationType)) {
            return amount;
        }
        long needed = Math.min(this.getInsertRate(automationType), this.getNeeded());
        if (needed == 0L) {
            return amount;
        }
        long toAdd = Math.min(amount, needed);
        if (action.execute()) {
            this.stored += toAdd;
            this.onContentsChanged();
        }
        return amount - toAdd;
    }

    @Override
    public long extract(long amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount <= 0L || !this.canExtract.test(automationType)) {
            return 0L;
        }
        long ret = Math.min(Math.min(this.getExtractRate(automationType), this.getEnergy()), amount);
        if (ret > 0L && action.execute()) {
            this.stored -= ret;
            this.onContentsChanged();
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.stored == 0L;
    }

    @Override
    public long getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.putLong("stored", this.stored);
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setLegacyEnergyIfPresent(nbt, "stored", this::setEnergy);
    }
}

