/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.heat;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.common.attachments.containers.ComponentBackedContainer;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.heat.AttachedHeat;
import mekanism.common.attachments.containers.heat.HeatCapacitorData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public class ComponentBackedHeatCapacitor
extends ComponentBackedContainer<HeatCapacitorData, AttachedHeat>
implements IHeatCapacitor {
    private final double inverseConductionCoefficient;
    private final double inverseInsulationCoefficient;
    private final HeatCapacitorData defaultData;

    public ComponentBackedHeatCapacitor(ItemStack attachedTo, int slotIndex, double inverseConductionCoefficient, double inverseInsulationCoefficient) {
        this(attachedTo, slotIndex, inverseConductionCoefficient, inverseInsulationCoefficient, 1.0);
    }

    public ComponentBackedHeatCapacitor(ItemStack attachedTo, int slotIndex, double inverseConductionCoefficient, double inverseInsulationCoefficient, double defaultHeatCapacity) {
        super(attachedTo, slotIndex);
        this.inverseConductionCoefficient = inverseConductionCoefficient;
        this.inverseInsulationCoefficient = inverseInsulationCoefficient;
        this.defaultData = new HeatCapacitorData(0.0, defaultHeatCapacity);
    }

    @Override
    protected HeatCapacitorData copy(HeatCapacitorData toCopy) {
        return toCopy;
    }

    @Override
    protected boolean isEmpty(HeatCapacitorData value) {
        return value.equals(this.defaultData);
    }

    @Override
    protected ContainerType<?, AttachedHeat, ?> containerType() {
        return ContainerType.HEAT;
    }

    @Override
    protected HeatCapacitorData getContents(AttachedHeat attached) {
        if (this.containerIndex < 0 || this.containerIndex >= attached.size()) {
            return this.defaultData;
        }
        return (HeatCapacitorData)attached.get(this.containerIndex);
    }

    protected HeatCapacitorData getData() {
        return this.getContents((AttachedHeat)this.getAttached());
    }

    @Override
    public double getTemperature() {
        HeatCapacitorData data = this.getData();
        return data.heat() / data.capacity();
    }

    @Override
    public double getInverseConduction() {
        return this.inverseConductionCoefficient;
    }

    @Override
    public double getInverseInsulation() {
        return this.inverseInsulationCoefficient;
    }

    @Override
    public double getHeatCapacity() {
        return this.getData().capacity();
    }

    @Override
    public double getHeat() {
        return this.getData().heat();
    }

    @Override
    public void setHeat(double heat) {
        AttachedHeat attachedHeat = (AttachedHeat)this.getAttached();
        this.setContents(attachedHeat, this.getContents(attachedHeat).withHeat(heat));
    }

    @Override
    protected boolean shouldUpdate(AttachedHeat attached, HeatCapacitorData value) {
        return !this.getContents(attached).equals(value);
    }

    @Override
    public void handleHeat(double transfer) {
        AttachedHeat attachedHeat;
        if (transfer != 0.0 && Math.abs(transfer) > (double)1.0E-6f && !(attachedHeat = (AttachedHeat)this.getAttached()).isEmpty()) {
            HeatCapacitorData stored = this.getContents(attachedHeat);
            this.setContents(attachedHeat, new HeatCapacitorData(stored.heat() + transfer, stored.capacity()));
        }
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        HeatCapacitorData data = this.getData();
        nbt.putDouble("stored", data.heat());
        nbt.putDouble("heat_capacity", data.capacity());
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        double capacity = nbt.contains("heat_capacity", 6) ? nbt.getDouble("heat_capacity") : this.defaultData.capacity();
        this.setContents((AttachedHeat)this.getAttached(), new HeatCapacitorData(nbt.getDouble("stored"), capacity));
    }
}

