/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.ComponentBackedHandler;
import mekanism.common.attachments.containers.IAttachedContainers;
import mekanism.common.attachments.containers.chemical.AttachedChemicals;
import mekanism.common.attachments.containers.chemical.ComponentBackedChemicalHandler;
import mekanism.common.attachments.containers.creator.IContainerCreator;
import mekanism.common.attachments.containers.energy.AttachedEnergy;
import mekanism.common.attachments.containers.energy.ComponentBackedEnergyHandler;
import mekanism.common.attachments.containers.fluid.AttachedFluids;
import mekanism.common.attachments.containers.fluid.ComponentBackedFluidHandler;
import mekanism.common.attachments.containers.heat.AttachedHeat;
import mekanism.common.attachments.containers.heat.ComponentBackedHeatHandler;
import mekanism.common.attachments.containers.item.AttachedItems;
import mekanism.common.attachments.containers.item.ComponentBackedItemHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.IMultiTypeCapability;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ContainerType<CONTAINER extends INBTSerializable<CompoundTag>, ATTACHED extends IAttachedContainers<?, ATTACHED>, HANDLER extends ComponentBackedHandler<?, CONTAINER, ATTACHED>> {
    private static final List<ContainerType<?, ?, ?>> TYPES_INTERNAL = new ArrayList();
    public static final List<ContainerType<?, ?, ?>> TYPES = Collections.unmodifiableList(TYPES_INTERNAL);
    public static final ContainerType<IEnergyContainer, AttachedEnergy, ComponentBackedEnergyHandler> ENERGY = new ContainerType<IEnergyContainer, AttachedEnergy, ComponentBackedEnergyHandler>(MekanismDataComponents.ATTACHED_ENERGY, "energy_containers", "container", ComponentBackedEnergyHandler::new, Capabilities.STRICT_ENERGY, AttachedEnergy.EMPTY, TileEntityMekanism::getEnergyContainers, TileEntityMekanism::collectEnergyContainers, TileEntityMekanism::applyEnergyContainers, TileEntityMekanism::canHandleEnergy){

        @Override
        public void registerItemCapabilities(RegisterCapabilitiesEvent event, Item item, boolean exposeWhenStacked, IMekanismConfig ... requiredConfigs) {
            EnergyCompatUtils.registerItemCapabilities(event, item, this.getCapabilityProvider(exposeWhenStacked, requiredConfigs));
        }
    };
    public static final ContainerType<IInventorySlot, AttachedItems, ComponentBackedItemHandler> ITEM = new ContainerType(MekanismDataComponents.ATTACHED_ITEMS, "items", "slot", ComponentBackedItemHandler::new, Capabilities.ITEM, AttachedItems.EMPTY, TileEntityMekanism::getInventorySlots, TileEntityMekanism::collectInventorySlots, TileEntityMekanism::applyInventorySlots, TileEntityMekanism::hasInventory);
    public static final ContainerType<IExtendedFluidTank, AttachedFluids, ComponentBackedFluidHandler> FLUID = new ContainerType(MekanismDataComponents.ATTACHED_FLUIDS, "fluid_tanks", "tank", ComponentBackedFluidHandler::new, Capabilities.FLUID, AttachedFluids.EMPTY, TileEntityMekanism::getFluidTanks, TileEntityMekanism::collectFluidTanks, TileEntityMekanism::applyFluidTanks, TileEntityMekanism::canHandleFluid);
    public static final ContainerType<IChemicalTank, AttachedChemicals, ComponentBackedChemicalHandler> CHEMICAL = new ContainerType<IChemicalTank, AttachedChemicals, ComponentBackedChemicalHandler>(MekanismDataComponents.ATTACHED_CHEMICALS, "chemical_tanks", "tank", ComponentBackedChemicalHandler::new, Capabilities.CHEMICAL, AttachedChemicals.EMPTY, TileEntityMekanism::getChemicalTanks, TileEntityMekanism::collectChemicalTanks, TileEntityMekanism::applyChemicalTanks, TileEntityMekanism::canHandleChemicals){

        @Override
        public void readFrom(HolderLookup.Provider provider, CompoundTag tag, TileEntityMekanism tile) {
            if (tag.contains(this.getTag(), 9)) {
                super.readFrom(provider, tag, this.getContainers(tile));
            } else {
                if (tag.contains("gas_tanks")) {
                    this.read(provider, tile.getLegacyGasTanks(), tag.getList("gas_tanks", 10));
                }
                if (tag.contains("infusion_tanks")) {
                    this.read(provider, tile.getLegacyInfuseTanks(), tag.getList("infusion_tanks", 10));
                }
                if (tag.contains("pigment_tanks")) {
                    this.read(provider, tile.getLegacyPigmentTanks(), tag.getList("pigment_tanks", 10));
                }
                if (tag.contains("slurry_tanks")) {
                    this.read(provider, tile.getLegacySlurryTanks(), tag.getList("slurry_tanks", 10));
                }
            }
        }

        @Override
        public void readFrom(HolderLookup.Provider provider, CompoundTag tag, List<IChemicalTank> containers) {
            if (tag.contains(this.getTag(), 9)) {
                super.readFrom(provider, tag, containers);
            } else {
                this.read(provider, containers, tag.getList("gas_tanks", 10));
                this.read(provider, containers, tag.getList("infusion_tanks", 10));
                this.read(provider, containers, tag.getList("pigment_tanks", 10));
                this.read(provider, containers, tag.getList("slurry_tanks", 10));
            }
        }
    };
    public static final ContainerType<IHeatCapacitor, AttachedHeat, ComponentBackedHeatHandler> HEAT = new ContainerType(MekanismDataComponents.ATTACHED_HEAT, "heat_capacitors", "container", ComponentBackedHeatHandler::new, null, AttachedHeat.EMPTY, TileEntityMekanism::getHeatCapacitors, TileEntityMekanism::collectHeatCapacitors, TileEntityMekanism::applyHeatCapacitors, TileEntityMekanism::canHandleHeat);
    public static final Codec<ContainerType<?, ?, ?>> CODEC = BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec().comapFlatMap(componentType -> {
        for (ContainerType<?, ?, ?> type : TYPES) {
            if (type.component.value() != componentType) continue;
            return DataResult.success(type);
        }
        return DataResult.error(() -> "Data Component type " + String.valueOf(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(componentType)) + " does not have a corresponding container type");
    }, containerType -> (DataComponentType)containerType.component.get());
    private final Map<Item, Lazy<? extends IContainerCreator<? extends CONTAINER, ATTACHED>>> knownDefaultCreators = new Reference2ObjectOpenHashMap();
    private final HandlerConstructor<HANDLER> handlerConstructor;
    private final BiFunction<TileEntityMekanism, @Nullable Direction, List<CONTAINER>> containersFromTile;
    private final CopyFromTile<CONTAINER, ATTACHED> copyFromTile;
    private final CopyToTile<CONTAINER, ATTACHED> copyToTile;
    private final DeferredHolder<DataComponentType<?>, DataComponentType<ATTACHED>> component;
    @Nullable
    private final IMultiTypeCapability<? super HANDLER, ?> capability;
    private final Predicate<TileEntityMekanism> canHandle;
    private final ATTACHED emptyAttachment;
    private final String containerTag;
    protected final String containerKey;

    private ContainerType(DeferredHolder<DataComponentType<?>, DataComponentType<ATTACHED>> component, String containerTag, String containerKey, HandlerConstructor<HANDLER> handlerConstructor, @Nullable IMultiTypeCapability<? super HANDLER, ?> capability, ATTACHED emptyAttachment, BiFunction<TileEntityMekanism, @Nullable Direction, List<CONTAINER>> containersFromTile, CopyFromTile<CONTAINER, ATTACHED> copyFromTile, CopyToTile<CONTAINER, ATTACHED> copyToTile, Predicate<TileEntityMekanism> canHandle) {
        TYPES_INTERNAL.add(this);
        this.component = component;
        this.containerTag = containerTag;
        this.containerKey = containerKey;
        this.emptyAttachment = emptyAttachment;
        this.handlerConstructor = handlerConstructor;
        this.containersFromTile = containersFromTile;
        this.copyFromTile = copyFromTile;
        this.copyToTile = copyToTile;
        this.capability = capability;
        this.canHandle = canHandle;
    }

    public DeferredHolder<DataComponentType<?>, DataComponentType<ATTACHED>> getComponentType() {
        return this.component;
    }

    @Nullable
    public ResourceLocation getComponentName() {
        return BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)this.component.get()));
    }

    public String getTag() {
        return this.containerTag;
    }

    public void addDefaultCreators(@Nullable IEventBus eventBus, Item item, Supplier<? extends IContainerCreator<? extends CONTAINER, ATTACHED>> defaultCreator, IMekanismConfig ... requiredConfigs) {
        this.knownDefaultCreators.put(item, Lazy.of(defaultCreator));
        if (eventBus != null && this.capability != null) {
            eventBus.addListener(RegisterCapabilitiesEvent.class, event -> this.registerItemCapabilities((RegisterCapabilitiesEvent)event, item, false, requiredConfigs));
        }
    }

    public void registerItemCapabilities(RegisterCapabilitiesEvent event, Item item, boolean exposeWhenStacked, IMekanismConfig ... requiredConfigs) {
        if (this.capability != null) {
            event.registerItem(this.capability.item(), this.getCapabilityProvider(exposeWhenStacked, requiredConfigs), new ItemLike[]{item});
        }
    }

    public List<CONTAINER> getAttachmentContainersIfPresent(ItemStack stack) {
        HANDLER handler = this.createHandlerIfData(stack);
        return handler == null ? Collections.emptyList() : ((ComponentBackedHandler)handler).getContainers();
    }

    public int getContainerCount(ItemStack stack) {
        ATTACHED attached = this.getOrEmpty(stack);
        if (attached.isEmpty()) {
            Lazy<? extends IContainerCreator<? extends CONTAINER, ATTACHED>> containerCreator = this.knownDefaultCreators.get(stack.getItem());
            return containerCreator == null ? 0 : ((IContainerCreator)containerCreator.get()).totalContainers();
        }
        return attached.size();
    }

    @Nullable
    public HANDLER createHandlerIfData(ItemStack stack) {
        ATTACHED attached = this.getOrEmpty(stack);
        return attached.isEmpty() ? null : (HANDLER)this.handlerConstructor.create(stack, attached.size());
    }

    @Nullable
    public HANDLER createHandler(ItemStack stack) {
        int count = this.getContainerCount(stack);
        if (count == 0) {
            return null;
        }
        return this.handlerConstructor.create(stack, count);
    }

    public ATTACHED createNewAttachment(ItemStack stack) {
        Lazy<? extends IContainerCreator<? extends CONTAINER, ATTACHED>> lazy = this.knownDefaultCreators.get(stack.getItem());
        if (lazy == null) {
            return this.emptyAttachment;
        }
        IContainerCreator containerCreator = (IContainerCreator)lazy.get();
        int count = containerCreator.totalContainers();
        if (count == 0) {
            return this.emptyAttachment;
        }
        return containerCreator.initStorage(count);
    }

    public ATTACHED getOrEmpty(ItemStack stack) {
        return (ATTACHED)((IAttachedContainers)stack.getOrDefault(this.component, this.emptyAttachment));
    }

    public CONTAINER createContainer(ItemStack attachedTo, int containerIndex) {
        Lazy<? extends IContainerCreator<? extends CONTAINER, ATTACHED>> creator = this.knownDefaultCreators.get(attachedTo.getItem());
        if (creator != null) {
            return ((IContainerCreator)creator.get()).create(this, attachedTo, containerIndex);
        }
        throw new IllegalArgumentException("No known containers for item " + String.valueOf(attachedTo.getItem()));
    }

    protected ICapabilityProvider<ItemStack, Void, ? super HANDLER> getCapabilityProvider(boolean exposeWhenStacked, IMekanismConfig ... requiredConfigs) {
        if (exposeWhenStacked) {
            return this.getCapabilityProvider(requiredConfigs);
        }
        if (requiredConfigs.length == 0) {
            return (stack, context) -> stack.getCount() == 1 ? (ComponentBackedHandler)this.createHandler((ItemStack)stack) : null;
        }
        return (stack, context) -> stack.getCount() == 1 && ContainerType.hasRequiredConfigs(requiredConfigs) ? (ComponentBackedHandler)this.createHandler((ItemStack)stack) : null;
    }

    protected ICapabilityProvider<ItemStack, Void, ? super HANDLER> getCapabilityProvider(IMekanismConfig ... requiredConfigs) {
        if (requiredConfigs.length == 0) {
            return (stack, context) -> this.createHandler((ItemStack)stack);
        }
        return (stack, context) -> ContainerType.hasRequiredConfigs(requiredConfigs) ? (ComponentBackedHandler)this.createHandler((ItemStack)stack) : null;
    }

    private static boolean hasRequiredConfigs(IMekanismConfig ... requiredConfigs) {
        for (IMekanismConfig requiredConfig : requiredConfigs) {
            if (requiredConfig.isLoaded()) continue;
            return false;
        }
        return true;
    }

    public boolean supports(ItemStack stack) {
        return stack.has(this.component) || this.knownDefaultCreators.containsKey(stack.getItem());
    }

    public void addDefault(ItemLike item, DataComponentPatch.Builder builder) {
        IContainerCreator containerCreator;
        int count;
        Lazy<? extends IContainerCreator<? extends CONTAINER, ATTACHED>> lazy = this.knownDefaultCreators.get(item);
        if (lazy != null && (count = (containerCreator = (IContainerCreator)lazy.get()).totalContainers()) > 0) {
            builder.set((DataComponentType)this.component.get(), containerCreator.initStorage(count));
        }
    }

    public static boolean anySupports(ItemLike itemLike) {
        for (ContainerType<?, ?, ?> type : TYPES) {
            if (!type.knownDefaultCreators.containsKey(itemLike.asItem())) continue;
            return true;
        }
        return false;
    }

    private ListTag save(HolderLookup.Provider provider, List<CONTAINER> containers) {
        return DataHandlerUtils.writeContents(provider, containers, this.containerKey);
    }

    protected void read(HolderLookup.Provider provider, List<CONTAINER> containers, @Nullable ListTag storedContainers) {
        if (storedContainers != null) {
            DataHandlerUtils.readContents(provider, containers, storedContainers, this.containerKey);
        }
    }

    public void saveTo(HolderLookup.Provider provider, CompoundTag tag, TileEntityMekanism tile) {
        this.saveTo(provider, tag, this.getContainers(tile));
    }

    public void saveTo(HolderLookup.Provider provider, CompoundTag tag, List<CONTAINER> containers) {
        ListTag serialized = this.save(provider, containers);
        if (!serialized.isEmpty()) {
            tag.put(this.containerTag, (Tag)serialized);
        }
    }

    public void readFrom(HolderLookup.Provider provider, CompoundTag tag, TileEntityMekanism tile) {
        this.readFrom(provider, tag, this.getContainers(tile));
    }

    public void readFrom(HolderLookup.Provider provider, CompoundTag tag, List<CONTAINER> containers) {
        this.read(provider, containers, tag.getList(this.containerTag, 10));
    }

    public void copyToStack(HolderLookup.Provider provider, List<CONTAINER> containers, ItemStack stack) {
        HANDLER handler = this.createHandler(stack);
        if (handler != null) {
            this.read(provider, ((ComponentBackedHandler)handler).getContainers(), this.save(provider, containers));
            stack.set(this.component, ((ComponentBackedHandler)handler).getAttached());
            if (stack.getCount() > 1) {
                Mekanism.logger.error("Copied {} to a stack ({}). This might lead to duplication of data.", (Object)this.getComponentName(), (Object)stack);
            }
        }
    }

    public void copyToTile(TileEntityMekanism tile, BlockEntity.DataComponentInput input) {
        IAttachedContainers attachedData = (IAttachedContainers)input.get(this.component);
        if (attachedData != null) {
            this.copyToTile.copy(tile, input, this.getContainers(tile), attachedData);
        }
    }

    public void copyFromStack(HolderLookup.Provider provider, ItemStack stack, List<CONTAINER> containers) {
        HANDLER handler = this.createHandler(stack);
        if (handler != null) {
            this.read(provider, containers, this.save(provider, ((ComponentBackedHandler)handler).getContainers()));
        }
    }

    public void copyFromTile(TileEntityMekanism tile, DataComponentMap.Builder builder) {
        ATTACHED attachedData;
        List<CONTAINER> containers = this.getContainers(tile);
        if (!containers.isEmpty() && (attachedData = this.copyFromTile.copy(tile, builder, containers)) != null) {
            builder.set(this.component, attachedData);
        }
    }

    public boolean canHandle(TileEntityMekanism tile) {
        return this.canHandle.test(tile);
    }

    public List<CONTAINER> getContainers(TileEntityMekanism tile) {
        return this.containersFromTile.apply(tile, null);
    }

    @FunctionalInterface
    private static interface HandlerConstructor<HANDLER extends ComponentBackedHandler<?, ?, ?>> {
        public HANDLER create(ItemStack var1, int var2);
    }

    @FunctionalInterface
    public static interface CopyFromTile<CONTAINER extends INBTSerializable<CompoundTag>, ATTACHED extends IAttachedContainers<?, ATTACHED>> {
        @Nullable
        public ATTACHED copy(TileEntityMekanism var1, DataComponentMap.Builder var2, List<CONTAINER> var3);
    }

    @FunctionalInterface
    public static interface CopyToTile<CONTAINER extends INBTSerializable<CompoundTag>, ATTACHED extends IAttachedContainers<?, ATTACHED>> {
        public void copy(TileEntityMekanism var1, BlockEntity.DataComponentInput var2, List<CONTAINER> var3, ATTACHED var4);
    }
}

