/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMaps;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public record OverflowAware(Object2IntSortedMap<HashedItem> overflow) {
    public static final OverflowAware EMPTY = new OverflowAware((Object2IntSortedMap<HashedItem>)Object2IntSortedMaps.emptyMap());
    public static final Codec<OverflowAware> CODEC = Codec.unboundedMap(HashedItem.CODEC, (Codec)ExtraCodecs.POSITIVE_INT).xmap(map -> new OverflowAware((Object2IntSortedMap<HashedItem>)new Object2IntLinkedOpenHashMap(map)), OverflowAware::overflow);
    public static final StreamCodec<RegistryFriendlyByteBuf, OverflowAware> STREAM_CODEC = ByteBufCodecs.map(Object2IntLinkedOpenHashMap::new, HashedItem.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT).map(OverflowAware::new, OverflowAware::overflow);

    public OverflowAware(Object2IntSortedMap<HashedItem> overflow) {
        this.overflow = overflow = Object2IntSortedMaps.unmodifiable(overflow);
    }

    public static ListTag writeOverflow(HolderLookup.Provider provider, Object2IntMap<HashedItem> overflow) {
        ListTag overflowTag = new ListTag();
        for (Object2IntMap.Entry entry : overflow.object2IntEntrySet()) {
            CompoundTag overflowComponent = new CompoundTag();
            overflowComponent.put("type", ((HashedItem)entry.getKey()).internalToNBT(provider));
            overflowComponent.putInt("count", entry.getIntValue());
            overflowTag.add((Object)overflowComponent);
        }
        return overflowTag;
    }

    public static void readOverflow(HolderLookup.Provider provider, Object2IntMap<HashedItem> overflow, ListTag overflowTag) {
        int size = overflowTag.size();
        for (int i = 0; i < size; ++i) {
            ItemStack s;
            CompoundTag overflowComponent = overflowTag.getCompound(i);
            int count = overflowComponent.getInt("count");
            if (count <= 0 || (s = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)overflowComponent.getCompound("type"))).isEmpty()) continue;
            overflow.put((Object)HashedItem.raw(s), count);
        }
    }
}

