/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

@NothingNullByDefault
public enum MekanismLang implements ILangEntry
{
    REPAIR_COST("container.repair.cost"),
    REPAIR_EXPENSIVE("container.repair.expensive"),
    MEKANISM("constants", "mod_name"),
    DEBUG_TITLE("constants", "debug_title"),
    LOG_FORMAT("constants", "log_format"),
    PACK_DESCRIPTION("constants", "pack_description"),
    FORGE("constants", "forge"),
    ERROR("constants", "error"),
    INVALID_PACKET("constants", "error.packet.invalid"),
    ALPHA_WARNING("constants", "alpha_warning"),
    ALPHA_WARNING_HERE("constants", "alpha_warning.here"),
    HEAD("equipment", "head"),
    BODY("equipment", "body"),
    LEGS("equipment", "legs"),
    FEET("equipment", "feet"),
    MAINHAND("equipment", "mainhand"),
    OFFHAND("equipment", "offhand"),
    NORTH_SHORT("direction", "north.short"),
    SOUTH_SHORT("direction", "south.short"),
    WEST_SHORT("direction", "west.short"),
    EAST_SHORT("direction", "east.short"),
    MULTIBLOCK_INVALID_FRAME("multiblock", "invalid_frame"),
    MULTIBLOCK_INVALID_INNER("multiblock", "invalid_inner"),
    MULTIBLOCK_INVALID_CONTROLLER_CONFLICT("multiblock", "invalid_controller_conflict"),
    MULTIBLOCK_INVALID_NO_CONTROLLER("multiblock", "invalid_no_controller"),
    SPS("sps", "sps"),
    SPS_INVALID_DISCONNECTED_COIL("sps", "invalid_disconnected_coil"),
    SPS_PORT_MODE("sps", "port_mode"),
    SPS_ENERGY_INPUT("sps", "energy_input"),
    BOILER_INVALID_AIR_POCKETS("boiler", "invalid_air_pockets"),
    BOILER_INVALID_EXTRA_DISPERSER("boiler", "invalid_extra_disperser"),
    BOILER_INVALID_MISSING_DISPERSER("boiler", "invalid_missing_disperser"),
    BOILER_INVALID_NO_DISPERSER("boiler", "invalid_no_disperser"),
    BOILER_INVALID_SUPERHEATING("boiler", "invalid_superheating"),
    CONVERSION_ENERGY("conversion", "energy"),
    CONVERSION_CHEMICAL("conversion", "chemical"),
    ANCHOR_TYPE_ABSOLUTE("anchor_type", "absolute"),
    ANCHOR_TYPE_ABOVE_BOTTOM("anchor_type", "above_bottom"),
    ANCHOR_TYPE_BELOW_TOP("anchor_type", "below_top"),
    HEIGHT_SHAPE_TRAPEZOID("height_shape", "trapezoid"),
    HEIGHT_SHAPE_UNIFORM("height_shape", "above_bottom"),
    SET_FREQUENCY("qio", "set_frequency"),
    QIO_FREQUENCY_SELECT("qio", "qio_frequency_select"),
    QIO_ITEMS_DETAIL("qio", "items_detail"),
    QIO_TYPES_DETAIL("qio", "types_detail"),
    QIO_ITEMS("qio", "items"),
    QIO_TYPES("qio", "types"),
    QIO_TRIGGER_COUNT("qio", "trigger_count"),
    QIO_STORED_COUNT("qio", "stored_count"),
    QIO_FUZZY_MODE("qio", "fuzzy_mode"),
    QIO_ITEM_TYPE_UNDEFINED("qio", "item_type_undefined"),
    QIO_IMPORT_WITHOUT_FILTER("qio", "import_without_filter"),
    QIO_EXPORT_WITHOUT_FILTER("qio", "export_without_filter"),
    QIO_COMPENSATE_TOOLTIP("qio", "compensate_tooltip"),
    QIO_TRANSFER_TO_FREQUENCY("qio", "transfer.to_frequency"),
    QIO_TRANSFER_TO_WINDOW("qio", "transfer.to_window"),
    QIO_REJECTS_TO_FREQUENCY("qio", "recipe_viewer.to_frequency"),
    QIO_REJECTS_TO_INVENTORY("qio", "recipe_viewer.to_inventory"),
    QIO_SEARCH_AUTO_FOCUS("qio", "search.focus.auto"),
    QIO_SEARCH_MANUAL_FOCUS("qio", "search.focus.manual"),
    QIO_EXPORTER_ROUND_ROBIN("qio", "exporter.round_robin"),
    QIO_EXPORTER_ROUND_ROBIN_DESCRIPTION("qio", "exporter.round_robin.description"),
    LIST_SORT_COUNT("qio", "sort_count"),
    LIST_SORT_NAME("qio", "sort_name"),
    LIST_SORT_MOD("qio", "sort_mod"),
    LIST_SORT_REGISTRY_NAME("qio", "sort_registry_name"),
    LIST_SORT_NAME_DESC("qio", "sort_name_desc"),
    LIST_SORT_COUNT_DESC("qio", "sort_count_desc"),
    LIST_SORT_MOD_DESC("qio", "sort_mod_desc"),
    LIST_SORT_REGISTRY_NAME_DESC("qio", "sort_registry_name.desc"),
    LIST_SORT_ASCENDING("qio", "sort_ascending"),
    LIST_SORT_ASCENDING_DESC("qio", "sort_ascending_desc"),
    LIST_SORT_DESCENDING("qio", "sort_descending"),
    LIST_SORT_DESCENDING_DESC("qio", "sort_descending_desc"),
    LIST_SEARCH("qio", "list_search"),
    LIST_SORT("qio", "list_sort"),
    REDSTONE_ADAPTER_TOGGLE_SIGNAL("redstone_adapter", "toggle_signal"),
    RECIPE_VIEWER_INVENTORY_FULL("tooltip", "recipe_viewer.inventory_full"),
    JEI_AMOUNT_WITH_CAPACITY("tooltip", "jei.amount.with.capacity"),
    RECIPE_VIEWER_INFO_HEAVY_WATER("info", "jei.heavy_water"),
    RECIPE_VIEWER_INFO_MODULE_INSTALLATION("info", "jei.module_installation"),
    JEI_MISSING_ITEMS("jei.tooltip.error.recipe.transfer.missing"),
    JEI_INVENTORY_FULL("jei.tooltip.error.recipe.transfer.inventory.full"),
    JEI_RECIPE_ID("jei.tooltip.recipe.id"),
    KEY_HAND_MODE("key", "mode"),
    KEY_HEAD_MODE("key", "head_mode"),
    KEY_CHEST_MODE("key", "chest_mode"),
    KEY_LEGS_MODE("key", "legs_mode"),
    KEY_FEET_MODE("key", "feet_mode"),
    KEY_DETAILS_MODE("key", "details"),
    KEY_DESCRIPTION_MODE("key", "description"),
    KEY_MODULE_TWEAKER("key", "module_tweaker"),
    KEY_BOOST("key", "key_boost"),
    KEY_HUD("key", "key_hud"),
    HOLIDAY_BORDER("holiday", "border"),
    HOLIDAY_SIGNATURE("holiday", "signature"),
    CHRISTMAS_LINE_ONE("holiday", "christmas.1"),
    CHRISTMAS_LINE_TWO("holiday", "christmas.2"),
    CHRISTMAS_LINE_THREE("holiday", "christmas.3"),
    CHRISTMAS_LINE_FOUR("holiday", "christmas.4"),
    NEW_YEAR_LINE_ONE("holiday", "new_year.1"),
    NEW_YEAR_LINE_TWO("holiday", "new_year.2"),
    NEW_YEAR_LINE_THREE("holiday", "new_year.3"),
    MAY_4_LINE_ONE("holiday", "may_4.1"),
    PRIDE_LINE_ONE("holiday", "pride.1"),
    PRIDE_LINE_TWO("holiday", "pride.2"),
    PRIDE_LINE_THREE("holiday", "pride.3"),
    GENERIC_PERCENT("generic", "percent"),
    GENERIC_WITH_COMMA("generic", "with_comma"),
    GENERIC_STORED("generic", "stored"),
    GENERIC_STORED_MB("generic", "stored.mb"),
    GENERIC_MB("generic", "mb"),
    GENERIC_PRE_COLON("generic", "pre_colon"),
    GENERIC_SQUARE_BRACKET("generic", "square_bracket"),
    GENERIC_PARENTHESIS("generic", "parenthesis"),
    GENERIC_WITH_PARENTHESIS("generic", "with_parenthesis"),
    GENERIC_FRACTION("generic", "fraction"),
    GENERIC_TRANSFER("generic", "transfer"),
    GENERIC_PER_TICK("generic", "per_tick"),
    GENERIC_PER_MB("generic", "per_mb"),
    GENERIC_PRE_STORED("generic", "pre_pre_colon"),
    GENERIC_BLOCK_POS("generic", "block_pos"),
    GENERIC_HEX("generic", "hex"),
    GENERIC_LIST("generic", "list"),
    GENERIC_MINUTES("generic", "minutes"),
    GENERIC_HOURS_MINUTES("generic", "hours_minutes"),
    GENERIC_GREATER_THAN("generic", "greater_than"),
    GENERIC_GREATER_EQUAL("generic", "greater_equal"),
    GENERIC_LESS_THAN("generic", "less_than"),
    GENERIC_LESS_THAN_EQUAL("generic", "less_than_equal"),
    HOLD_FOR_DETAILS("tooltip", "hold_for_details"),
    HOLD_FOR_DESCRIPTION("tooltip", "hold_for_description"),
    HOLD_FOR_MODULES("tooltip", "hold_for_modules"),
    HOLD_FOR_SUPPORTED_ITEMS("tooltip", "hold_for_supported_items"),
    COMMAND_CHUNK_WATCH("command", "chunk.watch"),
    COMMAND_CHUNK_UNWATCH("command", "chunk.unwatch"),
    COMMAND_CHUNK_CLEAR("command", "chunk.clear"),
    COMMAND_CHUNK_FLUSH("command", "chunk.flush"),
    COMMAND_CHUNK_LOADED("command", "chunk.loaded"),
    COMMAND_CHUNK_UNLOADED("command", "chunk.unloaded"),
    COMMAND_DEBUG("command", "debug"),
    COMMAND_TEST_RULES("command", "testrules"),
    COMMAND_TP("command", "tp"),
    COMMAND_TPOP("command", "tpop"),
    COMMAND_ERROR_TPOP_EMPTY("command", "error.tpop.empty"),
    COMMAND_BUILD_REMOVED("command", "build.removed"),
    COMMAND_BUILD_BUILT("command", "build.built"),
    COMMAND_BUILD_BUILT_EMPTY("command", "build.built.empty"),
    COMMAND_ERROR_BUILD_MISS("command", "error.build.miss"),
    COMMAND_RADIATION_ADD("command", "radiation.add"),
    COMMAND_RADIATION_ADD_ENTITY("command", "radiation.add_entity"),
    COMMAND_RADIATION_ADD_ENTITY_TARGET("command", "radiation.add_entity.target"),
    COMMAND_RADIATION_GET("command", "radiation.get"),
    COMMAND_RADIATION_CLEAR("command", "radiation.clear"),
    COMMAND_RADIATION_CLEAR_ENTITY("command", "radiation.clear.entity"),
    COMMAND_RADIATION_REDUCE("command", "radiation.reduce"),
    COMMAND_RADIATION_REDUCE_TARGET("command", "radiation.reduce.target"),
    COMMAND_RADIATION_REMOVE_ALL("command", "radiation.remove_all"),
    COMMAND_RETROGEN_CHUNK_QUEUED("command", "retrogen.chunk_queued"),
    COMMAND_ERROR_RETROGEN_DISABLED("command", "error.retrogen.disabled"),
    COMMAND_ERROR_RETROGEN_FAILURE("command", "error.retrogen.failure"),
    TRANSMISSION_TYPE_ENERGY("transmission", "energy"),
    TRANSMISSION_TYPE_FLUID("transmission", "fluids"),
    TRANSMISSION_TYPE_CHEMICALS("transmission", "chemicals"),
    TRANSMISSION_TYPE_ITEM("transmission", "items"),
    TRANSMISSION_TYPE_HEAT("transmission", "heat"),
    UNKNOWN("tooltip", "unknown"),
    MODE("tooltip", "mode"),
    FIRE_MODE("tooltip", "fire_mode"),
    BUCKET_MODE("tooltip", "bucket_mode"),
    STORED_ENERGY("tooltip", "stored_energy"),
    STORED("tooltip", "stored"),
    STORED_MB_PERCENTAGE("tooltip", "stored_mb_percentage"),
    ITEM_AMOUNT("tooltip", "item_amount"),
    LOCKED("tooltip", "locked"),
    FLOWING("tooltip", "flowing"),
    INVALID("tooltip", "invalid"),
    HAS_INVENTORY("tooltip", "inventory"),
    NO_CHEMICAL("tooltip", "no_chemical"),
    NO_FLUID_TOOLTIP("tooltip", "no_fluid"),
    FREE_RUNNERS_MODE("tooltip", "mode.free_runners"),
    JETPACK_MODE("tooltip", "mode.jetpack"),
    SCUBA_TANK_MODE("tooltip", "mode.scuba_tank"),
    FREE_RUNNERS_STORED("tooltip", "stored.free_runners"),
    FLAMETHROWER_STORED("tooltip", "stored.flamethrower"),
    JETPACK_STORED("tooltip", "stored.jetpack"),
    DECAY_IMMUNE("tooltip", "decay_immune"),
    HEIGHT("gui", "height"),
    WIDTH("gui", "width"),
    BACK("gui", "back"),
    CRAFTING_TAB("gui", "crafting.tab"),
    CRAFTING_WINDOW("gui", "crafting.window"),
    CRAFTING_WINDOW_CLEAR("gui", "crafting.window.clear"),
    PROGRESS("gui", "progress"),
    PROCESS_RATE("gui", "process_rate"),
    PROCESS_RATE_MB("gui", "process_rate_mb"),
    TICKS_REQUIRED("gui", "ticks_required"),
    MIN("gui", "min"),
    MIN_DIGITAL_MINER("gui", "digital_miner.min"),
    MAX("gui", "max"),
    MAX_DIGITAL_MINER("gui", "digital_miner.max"),
    INFINITE("gui", "infinite"),
    NONE("gui", "none"),
    EMPTY("gui", "empty"),
    MAX_OUTPUT("gui", "max_output"),
    STORING("gui", "storing"),
    DISSIPATED_RATE("gui", "dissipated"),
    TRANSFERRED_RATE("gui", "transferred_rate"),
    FUEL("gui", "fuel"),
    VOLUME("gui", "volume"),
    NO_FLUID("gui", "no_fluid"),
    CHEMICAL("gui", "chemical"),
    LIQUID("gui", "liquid"),
    UNIT("gui", "unit"),
    USING("gui", "using"),
    NEEDED("gui", "needed"),
    NEEDED_PER_TICK("gui", "needed_per_tick"),
    FINISHED("gui", "finished"),
    NO_RECIPE("gui", "no_recipe"),
    EJECT("gui", "eject"),
    NO_DELAY("gui", "no_delay"),
    DELAY("gui", "delay"),
    ENERGY("gui", "energy"),
    RESISTIVE_HEATER_USAGE("gui", "usage"),
    DYNAMIC_TANK("gui", "dynamic_tank"),
    MOVE_UP("gui", "move_up"),
    MOVE_DOWN("gui", "move_down"),
    MOVE_TO_TOP("gui", "move_up.shift"),
    MOVE_TO_BOTTOM("gui", "move_down.shift"),
    SET("gui", "set"),
    TRUE("gui", "true"),
    FALSE("gui", "false"),
    CLOSE("gui", "close"),
    PIN("gui", "pin"),
    UNPIN("gui", "unpin"),
    RADIATION_DOSE("gui", "radiation_dose"),
    RADIATION_EXPOSURE("gui", "radiation_exposure"),
    RADIATION_EXPOSURE_ENTITY("gui", "radiation_exposure.entity"),
    RADIATION_DECAY_TIME("gui", "radiation_decay_time"),
    COLOR_PICKER("gui", "color_picker"),
    RGB("gui", "rgb"),
    RGBA("gui", "rgba"),
    HELMET_OPTIONS("gui", "helmet_options"),
    HUD_OVERLAY("gui", "hud_overlay"),
    OPACITY("gui", "opacity"),
    JITTER("gui", "jitter"),
    DEFAULT("gui", "default"),
    WARNING("gui", "warning"),
    DANGER("gui", "danger"),
    COMPASS("gui", "compass"),
    RADIAL_SCREEN("gui", "radial_screen"),
    VISUALS("gui", "visuals"),
    VISUALS_TOO_BIG("gui", "visuals.too_big"),
    NO_COLOR("gui", "no_color"),
    ISSUES("gui", "issues"),
    ISSUE_NOT_ENOUGH_ENERGY("gui", "issues.no_energy"),
    ISSUE_NOT_ENOUGH_ENERGY_REDUCED_RATE("gui", "issues.no_energy.reduced_rate"),
    ISSUE_NO_SPACE_IN_OUTPUT("gui", "issues.no_space"),
    ISSUE_NO_SPACE_IN_OUTPUT_OVERFLOW("gui", "issues.no_space.overflow"),
    ISSUE_NO_MATCHING_RECIPE("gui", "issues.no_recipe"),
    ISSUE_INPUT_DOESNT_PRODUCE_OUTPUT("gui", "issues.input_doesnt_produce_output"),
    ISSUE_INVALID_OREDICTIONIFICATOR_FILTER("gui", "issues.invalid_oredictionificator_filter"),
    ISSUE_FILTER_HAS_BLACKLISTED_ELEMENT("gui", "issues.filter_has_blacklisted_element"),
    ENTITY_DETECTION("laser_amplifier", "entity_detection"),
    ENERGY_CONTENTS("laser_amplifier", "energy_contents"),
    REDSTONE_OUTPUT("laser_amplifier", "redstone_output"),
    FREQUENCY("frequency", "format"),
    NO_FREQUENCY("frequency", "none"),
    FREQUENCY_DELETE_CONFIRM("frequency", "delete_confirm"),
    NOW_OWN("owner", "now_own"),
    OWNER("owner", "format"),
    NO_OWNER("owner", "none"),
    MAIN_TAB("tab", "main"),
    EVAPORATION_HEIGHT("evaporation", "height"),
    FLUID_PRODUCTION("evaporation", "fluid_production"),
    EVAPORATION_PLANT("evaporation", "evaporation_plant"),
    TRANSPORTER_CONFIG("configuration", "transporter"),
    SIDE_CONFIG("configuration", "side"),
    SIDE_CONFIG_CLEAR("configuration", "side.clear"),
    SIDE_CONFIG_CLEAR_ALL("configuration", "side.clear.all"),
    SIDE_CONFIG_INCREMENT("configuration", "side.increment"),
    STRICT_INPUT("configuration", "strict_input"),
    STRICT_INPUT_ENABLED("configuration", "strict_input.enabled"),
    CONFIG_TYPE("configuration", "config_type"),
    NO_EJECT("configuration", "no_eject"),
    CANT_EJECT_TOOLTIP("configuration", "no_eject.tooltip"),
    SLOTS("configuration", "slots"),
    AUTO_PULL("auto", "pull"),
    AUTO_EJECT("auto", "eject"),
    AUTO_SORT("auto", "sort"),
    IDLE("chemical_mode", "idle"),
    DUMPING_EXCESS("chemical_mode", "dumping_excess"),
    DUMPING("chemical_mode", "dumping"),
    DICTIONARY_KEY("dictionary", "key"),
    DICTIONARY_NO_KEY("dictionary", "no_key"),
    DICTIONARY_BLOCK_TAGS_FOUND("dictionary", "tags_found.block"),
    DICTIONARY_FLUID_TAGS_FOUND("dictionary", "tags_found.fluid"),
    DICTIONARY_ENTITY_TYPE_TAGS_FOUND("dictionary", "tags_found.entity_type"),
    DICTIONARY_BLOCK_ENTITY_TYPE_TAGS_FOUND("dictionary", "tags_found.block_entity_type"),
    DICTIONARY_TAG_TYPE("dictionary", "tag_type"),
    DICTIONARY_ITEM("dictionary", "item"),
    DICTIONARY_ITEM_DESC("dictionary", "item.desc"),
    DICTIONARY_BLOCK("dictionary", "block"),
    DICTIONARY_BLOCK_DESC("dictionary", "block.desc"),
    DICTIONARY_FLUID("dictionary", "fluid"),
    DICTIONARY_FLUID_DESC("dictionary", "fluid.desc"),
    DICTIONARY_ENTITY_TYPE("dictionary", "entity_type"),
    DICTIONARY_ENTITY_TYPE_DESC("dictionary", "entity_type.desc"),
    DICTIONARY_ATTRIBUTE("dictionary", "attribute"),
    DICTIONARY_ATTRIBUTE_DESC("dictionary", "attribute.desc"),
    DICTIONARY_POTION("dictionary", "potion"),
    DICTIONARY_POTION_DESC("dictionary", "potion.desc"),
    DICTIONARY_MOB_EFFECT("dictionary", "mob_effect"),
    DICTIONARY_MOB_EFFECT_DESC("dictionary", "mob_effect.desc"),
    DICTIONARY_ENCHANTMENT("dictionary", "enchantment"),
    DICTIONARY_ENCHANTMENT_DESC("dictionary", "enchantment.desc"),
    DICTIONARY_BLOCK_ENTITY_TYPE("dictionary", "block_entity_type"),
    DICTIONARY_BLOCK_ENTITY_TYPE_DESC("dictionary", "block_entity_type.desc"),
    DICTIONARY_CHEMICAL("dictionary", "chemical"),
    DICTIONARY_CHEMICAL_DESC("dictionary", "chemical.desc"),
    LAST_ITEM("oredictionificator", "last_item"),
    NEXT_ITEM("oredictionificator", "next_item"),
    STABILIZER_CENTER("gui", "stabilizer.center"),
    STABILIZER_ENABLE_RADIUS("gui", "stabilizer.radius.enable"),
    STABILIZER_DISABLE_RADIUS("gui", "stabilizer.radius.disable"),
    STABILIZER_TOGGLE_LOADING("gui", "stabilizer.toggle_loading"),
    STATUS("status", "format"),
    STATUS_OK("status", "ok"),
    FLUID_CONTAINER_BOTH("fluid_container", "both"),
    FLUID_CONTAINER_FILL("fluid_container", "fill"),
    FLUID_CONTAINER_EMPTY("fluid_container", "empty"),
    YES("boolean", "yes"),
    NO("boolean", "no"),
    ON("boolean", "on"),
    OFF("boolean", "off"),
    INPUT("boolean", "input"),
    OUTPUT("boolean", "output"),
    ACTIVE("boolean", "active"),
    DISABLED("boolean", "disabled"),
    ON_CAPS("boolean", "on_caps"),
    OFF_CAPS("boolean", "off_caps"),
    CAPACITY("capacity", "generic"),
    CAPACITY_ITEMS("capacity", "items"),
    CAPACITY_MB("capacity", "mb"),
    CAPACITY_PER_TICK("capacity", "per_tick"),
    CAPACITY_MB_PER_TICK("capacity", "mb.per_tick"),
    BLOCK_DATA("cardboard_box", "block_data"),
    BLOCK("cardboard_box", "block"),
    BLOCK_ENTITY("cardboard_box", "block_entity"),
    BLOCK_ENTITY_SPAWN_TYPE("cardboard_box", "block_entity.spawn_type"),
    BLOCK_ENTITY_DECORATION("cardboard_box", "block_entity.decoration"),
    INGREDIENTS("crafting_formula", "ingredients"),
    ENCODED("crafting_formula", "encoded"),
    MULTIBLOCK_INCOMPLETE("multiblock", "incomplete"),
    MULTIBLOCK_FORMED("multiblock", "formed"),
    MULTIBLOCK_CONFLICT("multiblock", "conflict"),
    MULTIBLOCK_FORMED_CHAT("multiblock", "formed.chat"),
    UNIVERSAL("transmitter", "universal"),
    ITEMS("transmitter", "items"),
    BLOCKS("transmitter", "blocks"),
    FLUIDS("transmitter", "fluids"),
    CHEMICALS("transmitter", "chemicals"),
    HEAT("transmitter", "heat"),
    CONDUCTION("transmitter", "conduction"),
    INSULATION("transmitter", "insulation"),
    HEAT_CAPACITY("transmitter", "heat_capacity"),
    CAPABLE_OF_TRANSFERRING("transmitter", "capable_of_transferring"),
    DIVERSION_CONTROL_DISABLED("transmitter", "control.disabled.desc"),
    DIVERSION_CONTROL_HIGH("transmitter", "control.high.desc"),
    DIVERSION_CONTROL_LOW("transmitter", "control.low.desc"),
    TOGGLE_DIVERTER("transmitter", "configurator.toggle_diverter"),
    PUMP_RATE("transmitter", "pump_rate"),
    PUMP_RATE_MB("transmitter", "pump_rate.mb"),
    SPEED("transmitter", "speed"),
    CONDENSENTRATOR_TOGGLE("condensentrator", "toggle"),
    CONDENSENTRATING("condensentrator", "condensentrating"),
    DECONDENSENTRATING("condensentrator", "decondensentrating"),
    UPGRADE_DISPLAY_LEVEL("upgrade", "display.level"),
    UPGRADES_EFFECT("gui", "upgrades.effect"),
    UPGRADES("gui", "upgrades"),
    UPGRADE_NO_SELECTION("gui", "upgrades.no_selection"),
    UPGRADES_SUPPORTED("gui", "upgrades.supported"),
    UPGRADE_COUNT("gui", "upgrades.amount"),
    UPGRADE_TYPE("gui", "upgrade"),
    UPGRADE_NOT_SUPPORTED("gui", "upgrade.not_supported"),
    UPGRADE_UNINSTALL("gui", "upgrade.uninstall"),
    UPGRADE_UNINSTALL_TOOLTIP("gui", "upgrade.uninstall.tooltip"),
    CREATE_FILTER_TITLE("filter", "select.title"),
    FILTERS("filter", "filters"),
    FILTER_COUNT("filter", "filter.count"),
    FILTER_ALLOW_DEFAULT("filter", "allow_default"),
    FILTER("filter", "filter"),
    FILTER_NEW("filter", "new"),
    FILTER_EDIT("filter", "edit"),
    FILTER_STATE("filter", "state"),
    TEXT_FILTER_NO_MATCHES("filter", "no_matches"),
    TAG_FILTER("filter", "tag"),
    TAG_FILTER_NO_TAG("filter", "tag.no_key"),
    TAG_FILTER_SAME_TAG("filter", "tag.same_key"),
    TAG_FILTER_TAG("filter", "tag.key"),
    MODID_FILTER("filter", "modid"),
    MODID_FILTER_NO_ID("filter", "modid.no_id"),
    MODID_FILTER_SAME_ID("filter", "modid.same_id"),
    MODID_FILTER_ID("filter", "modid.id"),
    ITEM_FILTER("filter", "item"),
    ITEM_FILTER_NO_ITEM("filter", "item.no_item"),
    FUZZY_MODE("filter", "fuzzy_mode"),
    SORTER_SIZE_MODE("filter", "sorter.size_mode"),
    SORTER_SIZE_MODE_CONFLICT("filter", "sorter.size_mode.conflict"),
    SORTER_FILTER_SIZE_MODE("filter", "sorter.size_mode.on"),
    SORTER_FILTER_MAX_LESS_THAN_MIN("filter", "sorter.max_less_than_min"),
    SORTER_FILTER_OVER_SIZED("filter", "sorter.over_sized"),
    SORTER_FILTER_SIZE_MISSING("filter", "sorter.size_missing"),
    OREDICTIONIFICATOR_FILTER("filter", "oredictionificator"),
    OREDICTIONIFICATOR_FILTER_INVALID_NAMESPACE("filter", "oredictionificator.invalid_namespace"),
    OREDICTIONIFICATOR_FILTER_INVALID_PATH("filter", "oredictionificator.invalid_path"),
    OREDICTIONIFICATOR_FILTER_UNSUPPORTED_TAG("filter", "oredictionificator.unsupported_tag"),
    WASTE_BARREL_DECAY_RATE("waste_barrel", "decay_rate"),
    WASTE_BARREL_DECAY_RATE_ACTUAL("waste_barrel", "decay_rate.actual"),
    CHUNK("seismic_vibrator", "chunk"),
    VIBRATING("seismic_vibrator", "vibrating"),
    NEEDS_ENERGY("seismic_reader", "needs_energy"),
    NO_VIBRATIONS("seismic_reader", "no_vibrations"),
    ABUNDANCY("seismic_reader", "abundancy"),
    REDSTONE_CONTROL_DISABLED("redstone_control", "disabled"),
    REDSTONE_CONTROL_HIGH("redstone_control", "high"),
    REDSTONE_CONTROL_LOW("redstone_control", "low"),
    REDSTONE_CONTROL_PULSE("redstone_control", "pulse"),
    SECURITY("tooltip", "security"),
    SECURITY_OVERRIDDEN("security", "overridden"),
    SECURITY_OFFLINE("security", "offline"),
    SECURITY_ADD("security", "add"),
    SECURITY_OVERRIDE("security", "override"),
    NO_ACCESS("security", "no_access"),
    TRUSTED_PLAYERS("security", "trusted_players"),
    PUBLIC_MODE("security", "public.mode"),
    TRUSTED_MODE("security", "trusted.mode"),
    PRIVATE_MODE("security", "private.mode"),
    ENCODE_FORMULA("assemblicator", "encode_formula"),
    CRAFT_SINGLE("assemblicator", "craft_single"),
    CRAFT_AVAILABLE("assemblicator", "craft_available"),
    EMPTY_ASSEMBLICATOR("assemblicator", "empty"),
    FILL_ASSEMBLICATOR("assemblicator", "fill"),
    STOCK_CONTROL("assemblicator", "stock_control"),
    AUTO_MODE("assemblicator", "auto_mode_toggle"),
    FACTORY_TYPE("factory", "type"),
    NETWORK_DESCRIPTION("network", "description"),
    INVENTORY_NETWORK("network", "inventory"),
    FLUID_NETWORK("network", "fluid"),
    CHEMICAL_NETWORK("network", "chemical"),
    HEAT_NETWORK("network", "heat"),
    ENERGY_NETWORK("network", "energy"),
    NO_NETWORK("network", "no_network"),
    HEAT_NETWORK_STORED("network", "heat_stored"),
    HEAT_NETWORK_FLOW("network", "heat_flow"),
    HEAT_NETWORK_FLOW_EFFICIENCY("network", "heat_flow.efficiency"),
    FLUID_NETWORK_NEEDED("network", "fluid_needed"),
    NETWORK_MB_PER_TICK("network", "mb_per_tick"),
    NETWORK_MB_STORED("network", "mb_stored"),
    BUTTON_CONFIRM("button", "confirm"),
    BUTTON_START("button", "start"),
    BUTTON_STOP("button", "stop"),
    BUTTON_CONFIG("button", "config"),
    BUTTON_REMOVE("button", "remove"),
    BUTTON_CANCEL("button", "cancel"),
    BUTTON_SAVE("button", "save"),
    BUTTON_SET("button", "set"),
    BUTTON_DELETE("button", "delete"),
    BUTTON_OPTIONS("button", "options"),
    BUTTON_TELEPORT("button", "teleport"),
    BUTTON_NEW_FILTER("button", "new_filter"),
    BUTTON_ITEMSTACK_FILTER("button", "itemstack_filter"),
    BUTTON_TAG_FILTER("button", "tag_filter"),
    BUTTON_MODID_FILTER("button", "modid_filter"),
    CONFIG_CARD_GOT("configuration_card", "got"),
    CONFIG_CARD_SET("configuration_card", "set"),
    CONFIG_CARD_UNEQUAL("configuration_card", "unequal"),
    CONFIG_CARD_HAS_DATA("configuration_card", "has_data"),
    CONFIG_CARD_CLEARED("configuration_card", "cleared"),
    CONNECTION_NORMAL("connection", "normal"),
    CONNECTION_PUSH("connection", "push"),
    CONNECTION_PULL("connection", "pull"),
    CONNECTION_NONE("connection", "none"),
    TELEPORTER_READY("teleporter", "ready"),
    TELEPORTER_NO_FRAME("teleporter", "no_frame"),
    TELEPORTER_NO_LINK("teleporter", "no_link"),
    TELEPORTER_NEEDS_ENERGY("teleporter", "needs_energy"),
    MATRIX("matrix", "induction_matrix"),
    MATRIX_RECEIVING_RATE("matrix", "receiving_rate"),
    MATRIX_OUTPUT_AMOUNT("matrix", "output_amount"),
    MATRIX_OUTPUT_RATE("matrix", "output_rate"),
    MATRIX_OUTPUTTING_RATE("matrix", "outputting_rate"),
    MATRIX_INPUT_AMOUNT("matrix", "input_amount"),
    MATRIX_INPUT_RATE("matrix", "input_rate"),
    MATRIX_CONSTITUENTS("matrix", "constituents"),
    MATRIX_DIMENSIONS("matrix", "dimensions"),
    MATRIX_DIMENSION_REPRESENTATION("matrix", "dimensions.representation"),
    MATRIX_STATS("matrix", "stats"),
    MATRIX_CELLS("matrix", "cells"),
    MATRIX_PROVIDERS("matrix", "providers"),
    INDUCTION_PORT_MODE("matrix", "induction_port.configurator_mode"),
    INDUCTION_PORT_OUTPUT_RATE("matrix", "induction_port.output_rate"),
    MINER_INSUFFICIENT_BUFFER("miner", "insufficient_buffer"),
    MINER_BUFFER_FREE("miner", "buffer_free"),
    MINER_TO_MINE("miner", "to_mine"),
    MINER_SILK_ENABLED("miner", "silk_enabled"),
    MINER_AUTO_PULL("miner", "auto_pull"),
    MINER_RUNNING("miner", "running"),
    MINER_LOW_POWER("miner", "low_power"),
    MINER_ENERGY_CAPACITY("miner", "energy_capacity"),
    MINER_MISSING_BLOCK("miner", "missing_block"),
    MINER_WELL("miner", "well"),
    MINER_CONFIG("miner", "config"),
    MINER_SILK("miner", "silk_touch"),
    MINER_RESET("miner", "reset"),
    MINER_INVERSE("miner", "inverse"),
    MINER_REQUIRE_REPLACE("miner", "require_replace"),
    MINER_REQUIRE_REPLACE_INVERSE("miner", "require_replace.inverse"),
    MINER_RADIUS("miner", "radius"),
    MINER_IDLE("miner", "idle"),
    MINER_SEARCHING("miner", "searching"),
    MINER_PAUSED("miner", "paused"),
    MINER_READY("miner", "ready"),
    BOILER("boiler", "thermoelectric_boiler"),
    BOILER_STATS("boiler", "stats"),
    BOILER_MAX_WATER("boiler", "max_water"),
    BOILER_MAX_STEAM("boiler", "max_steam"),
    BOILER_HEAT_TRANSFER("boiler", "heat_transfer"),
    BOILER_HEATERS("boiler", "heaters"),
    BOILER_CAPACITY("boiler", "capacity"),
    BOIL_RATE("boiler", "boil_rate"),
    MAX_BOIL_RATE("boiler", "max_boil"),
    BOILER_VALVE_MODE_CHANGE("boiler", "valve_mode_change"),
    BOILER_VALVE_MODE_INPUT("boiler", "valve_mode_input"),
    BOILER_VALVE_MODE_OUTPUT_STEAM("boiler", "valve_mode_output_steam"),
    BOILER_VALVE_MODE_OUTPUT_COOLANT("boiler", "valve_mode_output_coolant"),
    BOILER_WATER_TANK("boiler", "water_tank"),
    BOILER_COOLANT_TANK("boiler", "coolant_tank"),
    BOILER_STEAM_TANK("boiler", "steam_tank"),
    BOILER_HEATED_COOLANT_TANK("fission", "heated_coolant_tank"),
    TEMPERATURE("temperature", "short"),
    TEMPERATURE_LONG("temperature", "long"),
    TEMPERATURE_KELVIN("temperature", "kelvin"),
    TEMPERATURE_KELVIN_SHORT("temperature", "kelvin.short"),
    TEMPERATURE_CELSIUS("temperature", "celsius"),
    TEMPERATURE_CELSIUS_SHORT("temperature", "celsius.short"),
    TEMPERATURE_RANKINE("temperature", "rankine"),
    TEMPERATURE_RANKINE_SHORT("temperature", "rankine.short"),
    TEMPERATURE_FAHRENHEIT("temperature", "fahrenheit"),
    TEMPERATURE_FAHRENHEIT_SHORT("temperature", "fahrenheit.short"),
    TEMPERATURE_AMBIENT("temperature", "ambient"),
    TEMPERATURE_AMBIENT_SHORT("temperature", "ambient.short"),
    ENERGY_JOULES("energy", "joules"),
    ENERGY_JOULES_PLURAL("energy", "joules.plural"),
    ENERGY_JOULES_SHORT("energy", "joules.short"),
    ENERGY_FORGE("energy", "forge"),
    ENERGY_FORGE_SHORT("energy", "forge.short"),
    NETWORK_READER_BORDER("network_reader", "border"),
    NETWORK_READER_TEMPERATURE("network_reader", "temperature"),
    NETWORK_READER_TRANSMITTERS("network_reader", "transmitters"),
    NETWORK_READER_ACCEPTORS("network_reader", "acceptors"),
    NETWORK_READER_NEEDED("network_reader", "needed"),
    NETWORK_READER_BUFFER("network_reader", "buffer"),
    NETWORK_READER_THROUGHPUT("network_reader", "throughput"),
    NETWORK_READER_CAPACITY("network_reader", "capacity"),
    NETWORK_READER_CONNECTED_SIDES("network_reader", "connected"),
    SORTER_DEFAULT("logistical_sorter", "default"),
    SORTER_SINGLE_ITEM("logistical_sorter", "single_item"),
    SORTER_ROUND_ROBIN("logistical_sorter", "round_robin"),
    SORTER_AUTO_EJECT("logistical_sorter", "auto_eject"),
    SORTER_SINGLE_ITEM_DESCRIPTION("logistical_sorter", "single_item.description"),
    SORTER_ROUND_ROBIN_DESCRIPTION("logistical_sorter", "round_robin.description"),
    SORTER_AUTO_EJECT_DESCRIPTION("logistical_sorter", "auto_eject.description"),
    SIDE_DATA_NONE("side_data", "none"),
    SIDE_DATA_INPUT("side_data", "input"),
    SIDE_DATA_INPUT_1("side_data", "input_1"),
    SIDE_DATA_INPUT_2("side_data", "input_2"),
    SIDE_DATA_OUTPUT("side_data", "output"),
    SIDE_DATA_OUTPUT_1("side_data", "output_1"),
    SIDE_DATA_OUTPUT_2("side_data", "output_2"),
    SIDE_DATA_INPUT_OUTPUT("side_data", "input_output"),
    SIDE_DATA_ENERGY("side_data", "energy"),
    SIDE_DATA_EXTRA("side_data", "extra"),
    FREE_RUNNER_MODE_CHANGE("free_runner", "mode_change"),
    FREE_RUNNER_NORMAL("free_runner", "normal"),
    FREE_RUNNER_SAFETY("free_runner", "safety"),
    FREE_RUNNER_DISABLED("free_runner", "disabled"),
    JETPACK_MODE_CHANGE("jetpack", "mode_change"),
    JETPACK_NORMAL("jetpack", "normal"),
    JETPACK_HOVER("jetpack", "hover"),
    JETPACK_VECTOR("jetpack", "vector"),
    JETPACK_DISABLED("jetpack", "disabled"),
    DISASSEMBLER_MODE_CHANGE("disassembler", "mode_change"),
    DISASSEMBLER_EFFICIENCY("disassembler", "efficiency"),
    FLAMETHROWER_MODE_CHANGE("flamethrower", "mode_change"),
    FLAMETHROWER_COMBAT("flamethrower", "combat"),
    FLAMETHROWER_HEAT("flamethrower", "heat"),
    FLAMETHROWER_INFERNO("flamethrower", "inferno"),
    CONFIGURE_STATE("configurator", "configure_state"),
    STATE("configurator", "state"),
    TOGGLE_COLOR("configurator", "toggle_color"),
    CURRENT_COLOR("configurator", "view_color"),
    PUMP_RESET("configurator", "pump_reset"),
    PLENISHER_RESET("configurator", "plenisher_reset"),
    REDSTONE_SENSITIVITY("configurator", "redstone_sensitivity"),
    CONNECTION_TYPE("configurator", "mode_change"),
    CONFIGURATOR_VIEW_MODE("configurator", "view_mode"),
    CONFIGURATOR_TOGGLE_MODE("configurator", "toggle_mode"),
    CONFIGURATOR_CONFIGURATE("configurator", "configurate"),
    CONFIGURATOR_EMPTY("configurator", "empty"),
    CONFIGURATOR_ROTATE("configurator", "rotate"),
    CONFIGURATOR_WRENCH("configurator", "wrench"),
    ROBIT("robit", "robit"),
    ROBIT_NAME("robit", "name"),
    ROBIT_SMELTING("robit", "smelting"),
    ROBIT_CRAFTING("robit", "crafting"),
    ROBIT_INVENTORY("robit", "inventory"),
    ROBIT_REPAIR("robit", "repair"),
    ROBIT_TELEPORT("robit", "teleport"),
    ROBIT_TOGGLE_PICKUP("robit", "toggle_pickup"),
    ROBIT_RENAME("robit", "rename"),
    ROBIT_SKIN("robit", "skin"),
    ROBIT_SKIN_SELECT("robit", "skin.select"),
    ROBIT_TOGGLE_FOLLOW("robit", "toggle_follow"),
    ROBIT_GREETING("robit", "greeting"),
    ROBIT_OWNER("robit", "owner"),
    ROBIT_FOLLOWING("robit", "following"),
    ROBIT_DROP_PICKUP("robit", "drop_pickup"),
    DESCRIPTION_DICTIONARY("description", "dictionary"),
    DESCRIPTION_SEISMIC_READER("description", "seismic_reader"),
    DESCRIPTION_BIN("description", "bin"),
    DESCRIPTION_TELEPORTER_FRAME("description", "teleporter_frame"),
    DESCRIPTION_STEEL_CASING("description", "steel_casing"),
    DESCRIPTION_DYNAMIC_TANK("description", "dynamic_tank"),
    DESCRIPTION_STRUCTURAL_GLASS("description", "structural_glass"),
    DESCRIPTION_DYNAMIC_VALVE("description", "dynamic_valve"),
    DESCRIPTION_THERMAL_EVAPORATION_CONTROLLER("description", "thermal_evaporation_controller"),
    DESCRIPTION_THERMAL_EVAPORATION_VALVE("description", "thermal_evaporation_valve"),
    DESCRIPTION_THERMAL_EVAPORATION_BLOCK("description", "thermal_evaporation_block"),
    DESCRIPTION_INDUCTION_CASING("description", "induction_casing"),
    DESCRIPTION_INDUCTION_PORT("description", "induction_port"),
    DESCRIPTION_INDUCTION_CELL("description", "induction_cell"),
    DESCRIPTION_INDUCTION_PROVIDER("description", "induction_provider"),
    DESCRIPTION_SUPERHEATING_ELEMENT("description", "superheating_element"),
    DESCRIPTION_PRESSURE_DISPERSER("description", "pressure_disperser"),
    DESCRIPTION_BOILER_CASING("description", "boiler_casing"),
    DESCRIPTION_BOILER_VALVE("description", "boiler_valve"),
    DESCRIPTION_SECURITY_DESK("description", "security_desk"),
    DESCRIPTION_ENRICHMENT_CHAMBER("description", "enrichment_chamber"),
    DESCRIPTION_OSMIUM_COMPRESSOR("description", "osmium_compressor"),
    DESCRIPTION_COMBINER("description", "combiner"),
    DESCRIPTION_CRUSHER("description", "crusher"),
    DESCRIPTION_DIGITAL_MINER("description", "digital_miner"),
    DESCRIPTION_METALLURGIC_INFUSER("description", "metallurgic_infuser"),
    DESCRIPTION_PURIFICATION_CHAMBER("description", "purification_chamber"),
    DESCRIPTION_ENERGIZED_SMELTER("description", "energized_smelter"),
    DESCRIPTION_TELEPORTER("description", "teleporter"),
    DESCRIPTION_ELECTRIC_PUMP("description", "electric_pump"),
    DESCRIPTION_PERSONAL_BARREL("description", "personal_barrel"),
    DESCRIPTION_PERSONAL_CHEST("description", "personal_chest"),
    DESCRIPTION_CHARGEPAD("description", "chargepad"),
    DESCRIPTION_LOGISTICAL_SORTER("description", "logistical_sorter"),
    DESCRIPTION_ROTARY_CONDENSENTRATOR("description", "rotary_condensentrator"),
    DESCRIPTION_CHEMICAL_INJECTION_CHAMBER("description", "chemical_injection_chamber"),
    DESCRIPTION_ELECTROLYTIC_SEPARATOR("description", "electrolytic_separator"),
    DESCRIPTION_PRECISION_SAWMILL("description", "precision_sawmill"),
    DESCRIPTION_CHEMICAL_DISSOLUTION_CHAMBER("description", "chemical_dissolution_chamber"),
    DESCRIPTION_CHEMICAL_WASHER("description", "chemical_washer"),
    DESCRIPTION_CHEMICAL_CRYSTALLIZER("description", "chemical_crystallizer"),
    DESCRIPTION_CHEMICAL_OXIDIZER("description", "chemical_oxidizer"),
    DESCRIPTION_CHEMICAL_INFUSER("description", "chemical_infuser"),
    DESCRIPTION_SEISMIC_VIBRATOR("description", "seismic_vibrator"),
    DESCRIPTION_PRESSURIZED_REACTION_CHAMBER("description", "pressurized_reaction_chamber"),
    DESCRIPTION_FLUID_TANK("description", "fluid_tank"),
    DESCRIPTION_FLUIDIC_PLENISHER("description", "fluidic_plenisher"),
    DESCRIPTION_LASER("description", "laser"),
    DESCRIPTION_LASER_AMPLIFIER("description", "laser_amplifier"),
    DESCRIPTION_LASER_TRACTOR_BEAM("description", "laser_tractor_beam"),
    DESCRIPTION_SOLAR_NEUTRON_ACTIVATOR("description", "solar_neutron_activator"),
    DESCRIPTION_OREDICTIONIFICATOR("description", "oredictionificator"),
    DESCRIPTION_FACTORY("description", "factory"),
    DESCRIPTION_RESISTIVE_HEATER("description", "resistive_heater"),
    DESCRIPTION_FORMULAIC_ASSEMBLICATOR("description", "formulaic_assemblicator"),
    DESCRIPTION_FUELWOOD_HEATER("description", "fuelwood_heater"),
    DESCRIPTION_MODIFICATION_STATION("description", "modification_station"),
    DESCRIPTION_ISOTOPIC_CENTRIFUGE("description", "isotopic_centrifuge"),
    DESCRIPTION_QUANTUM_ENTANGLOPORTER("description", "quantum_entangloporter"),
    DESCRIPTION_NUTRITIONAL_LIQUIFIER("description", "nutritional_liquifier"),
    DESCRIPTION_ANTIPROTONIC_NUCLEOSYNTHESIZER("description", "antiprotonic_nucleosynthesizer"),
    DESCRIPTION_PIGMENT_EXTRACTOR("description", "pigment_extractor"),
    DESCRIPTION_PIGMENT_MIXER("description", "pigment_mixer"),
    DESCRIPTION_PAINTING_MACHINE("description", "painting_machine"),
    DESCRIPTION_QIO_DRIVE_ARRAY("description", "qio_drive_array"),
    DESCRIPTION_QIO_DASHBOARD("description", "qio_dashboard"),
    DESCRIPTION_QIO_IMPORTER("description", "qio_importer"),
    DESCRIPTION_QIO_EXPORTER("description", "qio_exporter"),
    DESCRIPTION_QIO_REDSTONE_ADAPTER("description", "qio_redstone_adapter"),
    DESCRIPTION_RADIOACTIVE_WASTE_BARREL("description", "radioactive_waste_barrel"),
    DESCRIPTION_INDUSTRIAL_ALARM("description", "industrial_alarm"),
    DESCRIPTION_ENERGY_CUBE("description", "energy_cube"),
    DESCRIPTION_CHEMICAL_TANK("description", "chemical_tank"),
    DESCRIPTION_CABLE("description", "cable"),
    DESCRIPTION_PIPE("description", "pipe"),
    DESCRIPTION_TUBE("description", "tube"),
    DESCRIPTION_TRANSPORTER("description", "transporter"),
    DESCRIPTION_CONDUCTOR("description", "conductor"),
    DESCRIPTION_DIVERSION("description", "diversion"),
    DESCRIPTION_RESTRICTIVE("description", "restrictive"),
    DESCRIPTION_SPS_CASING("description", "sps_casing"),
    DESCRIPTION_SPS_PORT("description", "sps_port"),
    DESCRIPTION_SUPERCHARGED_COIL("description", "supercharged_coil"),
    DESCRIPTION_DIMENSIONAL_STABILIZER("description", "dimensional_stabilizer"),
    SMELTING("factory", "smelting"),
    ENRICHING("factory", "enriching"),
    CRUSHING("factory", "crushing"),
    COMPRESSING("factory", "compressing"),
    COMBINING("factory", "combining"),
    PURIFYING("factory", "purifying"),
    INJECTING("factory", "injecting"),
    INFUSING("factory", "infusing"),
    SAWING("factory", "sawing"),
    RADIAL_VEIN("radial", "vein"),
    RADIAL_VEIN_NORMAL("radial", "vein.normal"),
    RADIAL_VEIN_EXTENDED("radial", "vein.extended"),
    RADIAL_EXCAVATION_SPEED("radial", "excavation_speed"),
    RADIAL_EXCAVATION_SPEED_OFF("radial", "excavation_speed.off"),
    RADIAL_EXCAVATION_SPEED_SLOW("radial", "excavation_speed.slow"),
    RADIAL_EXCAVATION_SPEED_NORMAL("radial", "excavation_speed.normal"),
    RADIAL_EXCAVATION_SPEED_FAST("radial", "excavation_speed.fast"),
    RADIAL_EXCAVATION_SPEED_SUPER("radial", "excavation_speed.super_fast"),
    RADIAL_EXCAVATION_SPEED_EXTREME("radial", "excavation_speed.extreme"),
    RADIAL_BLASTING_POWER("radial", "blasting_power"),
    RADIAL_BLASTING_POWER_OFF("radial", "blasting_power.off"),
    RADIAL_BLASTING_POWER_LOW("radial", "blasting_power.low"),
    RADIAL_BLASTING_POWER_MED("radial", "blasting_power.med"),
    RADIAL_BLASTING_POWER_HIGH("radial", "blasting_power.high"),
    RADIAL_BLASTING_POWER_EXTREME("radial", "blasting_power.extreme"),
    REMOVE_ALL_MODULES_TOOLTIP("gui", "modification.remove.tooltip"),
    MODULE_ENABLED("module", "enabled"),
    MODULE_ENABLED_LOWER("module", "enabled_lower"),
    MODULE_DISABLED_LOWER("module", "disabled_lower"),
    MODULE_DAMAGE("module", "damage"),
    MODULE_TWEAKER("module", "module_tweaker"),
    MODULE_INSTALLED("module", "installed"),
    MODULE_SUPPORTED("module", "supported"),
    MODULE_CONFLICTING("module", "conflicting"),
    MODULE_STACKABLE("module", "stackable"),
    MODULE_EXCLUSIVE("module", "exclusive"),
    MODULE_MODE("module", "mode"),
    MODULE_SPRINT_BOOST("module", "sprint_boost"),
    MODULE_EXTENDED_MODE("module", "extended_mode"),
    MODULE_EXTENDED_ENABLED("module", "extended_enabled"),
    MODULE_BLASTING_ENABLED("module", "blasting_enabled"),
    MODULE_BLAST_AREA("module", "blast_area"),
    MODULE_EFFICIENCY("module", "efficiency"),
    MODULE_JETPACK_MODE("module", "jetpack_mode"),
    MODULE_GRAVITATIONAL_MODULATION("module", "gravitational_modulation"),
    MODULE_MAGNETIC_ATTRACTION("module", "magnetic_attraction"),
    MODULE_MODE_CHANGE("module", "mode_change"),
    MODULE_VISION_ENHANCEMENT("module", "vision_enhancement"),
    FRAMEDBLOCKS_CAMO_HAS_SPECIAL_HANDLING("msg", "compat.framedblocks.camo.has_special_handling");

    private final String key;

    private MekanismLang(String type, String path) {
        this(Util.makeDescriptionId((String)type, (ResourceLocation)Mekanism.rl(path)));
    }

    private MekanismLang(String key) {
        this.key = key;
    }

    @Override
    public String getTranslationKey() {
        return this.key;
    }

    public static ILangEntry get(EquipmentSlot type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.HEAD -> HEAD;
            case EquipmentSlot.CHEST, EquipmentSlot.BODY -> BODY;
            case EquipmentSlot.LEGS -> LEGS;
            case EquipmentSlot.FEET -> FEET;
            case EquipmentSlot.MAINHAND -> MAINHAND;
            case EquipmentSlot.OFFHAND -> OFFHAND;
        };
    }
}

