/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.util.Objects;
import mekanism.client.sound.PlayerSound;
import mekanism.common.lib.radiation.RadiationManager;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class GeigerSound
extends PlayerSound {
    private final RadiationManager.RadiationScale scale;

    public static GeigerSound create(@NotNull Player player, RadiationManager.RadiationScale scale) {
        int subtitleFrequency = switch (scale) {
            default -> throw new MatchException(null, null);
            case RadiationManager.RadiationScale.LOW -> 60;
            case RadiationManager.RadiationScale.MEDIUM -> 50;
            case RadiationManager.RadiationScale.ELEVATED -> 40;
            case RadiationManager.RadiationScale.HIGH -> 30;
            case RadiationManager.RadiationScale.EXTREME -> 20;
            case RadiationManager.RadiationScale.NONE -> throw new IllegalArgumentException("Can't create a GeigerSound with a RadiationScale of NONE.");
        };
        return new GeigerSound(player, scale, subtitleFrequency);
    }

    private GeigerSound(@NotNull Player player, RadiationManager.RadiationScale scale, int subtitleFrequency) {
        super(player, Objects.requireNonNull(scale.getSoundEvent()), subtitleFrequency);
        this.scale = scale;
        this.setFade(1.0f, 1.0f);
    }

    @Override
    public boolean shouldPlaySound(@NotNull Player player) {
        return this.scale == RadiationManager.get().getClientScale();
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 0.05f;
    }
}

