/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item;

import java.util.List;
import java.util.function.Predicate;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.GuiUtils;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChemicalFluidBarDecorator
implements IItemDecorator {
    private final ContainerType<IChemicalTank, ?, ?>[] chemicalContainerTypes;
    private final boolean showFluid;
    private final Predicate<ItemStack> visibleFor;

    @SafeVarargs
    public ChemicalFluidBarDecorator(boolean showFluid, Predicate<ItemStack> visibleFor, ContainerType<IChemicalTank, ?, ?> ... chemicalContainerTypes) {
        this.showFluid = showFluid;
        this.chemicalContainerTypes = chemicalContainerTypes;
        this.visibleFor = visibleFor;
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        if (!this.visibleFor.test(stack)) {
            return false;
        }
        yOffset += 12;
        for (ContainerType<IChemicalTank, ?, ?> chemicalContainerType : this.chemicalContainerTypes) {
            List<IChemicalTank> tanks = chemicalContainerType.getAttachmentContainersIfPresent(stack);
            int tank = ChemicalFluidBarDecorator.getDisplayTank(tanks.size());
            if (tank != -1) {
                ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, tanks.get(tank));
                --yOffset;
                continue;
            }
            if (!tanks.isEmpty()) continue;
            ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, 0L, 1L, -1);
        }
        if (this.showFluid) {
            List<IExtendedFluidTank> tanks = ContainerType.FLUID.getAttachmentContainersIfPresent(stack);
            int tank = ChemicalFluidBarDecorator.getDisplayTank(tanks.size());
            if (tank != -1) {
                ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, tanks.get(tank));
            } else if (tanks.isEmpty()) {
                ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, 0L, 1L, -1);
            }
        }
        return true;
    }

    protected static void renderBar(GuiGraphics guiGraphics, int stackXPos, int yPos, IChemicalTank tank) {
        ChemicalFluidBarDecorator.renderBar(guiGraphics, stackXPos, yPos, tank.getStored(), tank.getCapacity(), tank.getType().getColorRepresentation());
    }

    protected static void renderBar(GuiGraphics guiGraphics, int stackXPos, int yPos, IExtendedFluidTank tank) {
        FluidStack fluid = tank.getFluid();
        ChemicalFluidBarDecorator.renderBar(guiGraphics, stackXPos, yPos, fluid.getAmount(), tank.getCapacity(), FluidUtils.getRGBDurabilityForDisplay(fluid).orElse(-1));
    }

    protected static void renderBar(GuiGraphics guiGraphics, int stackXPos, int yPos, long amount, long capacity, int color) {
        int pixelWidth = ChemicalFluidBarDecorator.convertWidth(StorageUtils.getRatio(amount, capacity));
        GuiUtils.fill(guiGraphics, RenderType.guiOverlay(), stackXPos + 2 + pixelWidth, yPos, 13 - pixelWidth, 1, -16777216);
        GuiUtils.fill(guiGraphics, RenderType.guiOverlay(), stackXPos + 2, yPos, pixelWidth, 1, color | 0xFF000000);
    }

    private static int convertWidth(double width) {
        return MathUtils.clampToInt(Math.round(13.0 * width));
    }

    static int getDisplayTank(int tanks) {
        if (tanks == 0) {
            return -1;
        }
        if (tanks > 1) {
            return Minecraft.getInstance().gui.getGuiTicks() / 20 % tanks;
        }
        return 0;
    }
}

