/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalRenderData
extends RenderData {
    public final Chemical chemical;

    public ChemicalRenderData(BlockPos renderLocation, int width, int height, int length, Chemical chemical) {
        super(renderLocation, width, height, length);
        this.chemical = chemical;
    }

    @Override
    public int getColorARGB(float scale) {
        return MekanismRenderer.getColorARGB(this.chemical, scale);
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return MekanismRenderer.getChemicalTexture(this.chemical);
    }

    @Override
    public boolean isGaseous() {
        return this.chemical.isGaseous();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.chemical);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return this.chemical == ((ChemicalRenderData)o).chemical;
    }
}

