/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.armor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.client.model.BaseModelCache;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.armor.ICustomArmor;
import mekanism.client.render.armor.ISpecialGear;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.QuickHash;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.shared.ModuleColorModulationUnit;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.lib.Color;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekaSuitArmor
implements ICustomArmor,
ISpecialGear {
    private static final String LED_TAG = "led";
    private static final String INACTIVE_TAG = "inactive_";
    private static final String OVERRIDDEN_TAG = "override_";
    private static final String EXCLUSIVE_TAG = "excl_";
    private static final String SHARED_TAG = "shared_";
    private static final String GLASS_TAG = "glass";
    public static final MekaSuitArmor HELMET = new MekaSuitArmor(EquipmentSlot.HEAD, EquipmentSlot.CHEST);
    public static final MekaSuitArmor BODYARMOR = new MekaSuitArmor(EquipmentSlot.CHEST, EquipmentSlot.HEAD);
    public static final MekaSuitArmor PANTS = new MekaSuitArmor(EquipmentSlot.LEGS, EquipmentSlot.FEET);
    public static final MekaSuitArmor BOOTS = new MekaSuitArmor(EquipmentSlot.FEET, EquipmentSlot.LEGS);
    private static final Table<EquipmentSlot, ModuleData<?>, ModuleModelSpec> moduleModelSpec = HashBasedTable.create();
    private static final Map<UUID, BoltRenderer> boltRenderMap = new Object2ObjectOpenHashMap();
    private static final QuadTransformation BASE_TRANSFORM = QuadTransformation.list(QuadTransformation.rotate(0.0, 0.0, 180.0), QuadTransformation.translate(-1.0f, 0.5f, 0.0f));
    private final LoadingCache<QuickHash, ArmorQuads> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<QuickHash, ArmorQuads>(){

        @NotNull
        public ArmorQuads load(@NotNull QuickHash key) {
            return MekaSuitArmor.this.createQuads((Object2BooleanMap<ModuleModelSpec>)((Object2BooleanMap)key.objs()[0]), (Set)key.objs()[1], (Boolean)key.objs()[2], (Boolean)key.objs()[3]);
        }
    });
    private final EquipmentSlot type;
    private final EquipmentSlot adjacentType;

    private MekaSuitArmor(EquipmentSlot type, EquipmentSlot adjacentType) {
        this.type = type;
        this.adjacentType = adjacentType;
        MekanismModelCache.INSTANCE.reloadCallback(() -> this.cache.invalidateAll());
    }

    private static Color getColor(ItemStack stack) {
        IModule<ModuleColorModulationUnit> colorUnit = IModuleHelper.INSTANCE.getModule(stack, MekanismModules.COLOR_MODULATION_UNIT);
        return colorUnit != null ? colorUnit.getCustomInstance().color() : Color.WHITE;
    }

    public void renderArm(HumanoidModel<? extends LivingEntity> baseModel, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, LivingEntity entity, ItemStack stack, boolean rightHand) {
        ModelPos armPos = rightHand ? ModelPos.RIGHT_ARM : ModelPos.LEFT_ARM;
        ArmorQuads armorQuads = (ArmorQuads)this.cache.getUnchecked((Object)this.key(entity));
        boolean hasOpaqueArm = armorQuads.opaqueQuads().containsKey((Object)armPos);
        boolean hasTransparentArm = armorQuads.transparentQuads().containsKey((Object)armPos);
        if (hasOpaqueArm || hasTransparentArm) {
            VertexConsumer builder;
            matrix.pushPose();
            armPos.translate(baseModel, matrix, entity);
            PoseStack.Pose last = matrix.last();
            if (hasOpaqueArm) {
                builder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)renderer, (RenderType)MekanismRenderType.MEKASUIT, (boolean)false, (boolean)stack.hasFoil());
                this.putQuads(armorQuads.opaqueQuads().get((Object)armPos), builder, last, light, overlayLight, MekaSuitArmor.getColor(stack));
            }
            if (hasTransparentArm) {
                builder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)renderer, (RenderType)RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), (boolean)false, (boolean)stack.hasFoil());
                this.putQuads(armorQuads.transparentQuads().get((Object)armPos), builder, last, light, overlayLight, Color.WHITE);
            }
            matrix.popPose();
        }
    }

    @Override
    public void render(HumanoidModel<? extends LivingEntity> baseModel, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, float partialTicks, boolean hasEffect, LivingEntity entity, ItemStack stack) {
        if (baseModel.young) {
            matrix.pushPose();
            float f1 = 1.0f / baseModel.babyBodyScale;
            matrix.scale(f1, f1, f1);
            matrix.translate(0.0, (double)(baseModel.bodyYOffset / 16.0f), 0.0);
            this.renderMekaSuit(baseModel, matrix, renderer, light, overlayLight, MekaSuitArmor.getColor(stack), partialTicks, hasEffect, entity);
            matrix.popPose();
        } else {
            this.renderMekaSuit(baseModel, matrix, renderer, light, overlayLight, MekaSuitArmor.getColor(stack), partialTicks, hasEffect, entity);
        }
    }

    private void renderMekaSuit(HumanoidModel<? extends LivingEntity> baseModel, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, Color color, float partialTicks, boolean hasEffect, LivingEntity entity) {
        ArmorQuads armorQuads = (ArmorQuads)this.cache.getUnchecked((Object)this.key(entity));
        this.render(baseModel, renderer, matrix, light, overlayLight, color, hasEffect, entity, armorQuads.opaqueQuads(), false);
        if (this.type == EquipmentSlot.CHEST) {
            BoltRenderer boltRenderer = boltRenderMap.computeIfAbsent(entity.getUUID(), id -> new BoltRenderer());
            if (IModuleHelper.INSTANCE.isEnabled(entity.getItemBySlot(EquipmentSlot.CHEST), MekanismModules.GRAVITATIONAL_MODULATING_UNIT)) {
                BoltEffect leftBolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, new Vec3(-0.01, 0.35, 0.37), new Vec3(-0.01, 0.15, 0.37), 10).size(0.012f).lifespan(6).spawn(BoltEffect.SpawnFunction.noise(3.0f, 1.0f));
                BoltEffect rightBolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, new Vec3(0.025, 0.35, 0.37), new Vec3(0.025, 0.15, 0.37), 10).size(0.012f).lifespan(6).spawn(BoltEffect.SpawnFunction.noise(3.0f, 1.0f));
                boltRenderer.update(0, leftBolt, partialTicks);
                boltRenderer.update(1, rightBolt, partialTicks);
            }
            matrix.pushPose();
            ModelPos.BODY.translate(baseModel, matrix, entity);
            boltRenderer.render(partialTicks, matrix, renderer);
            matrix.popPose();
        }
        this.render(baseModel, renderer, matrix, light, overlayLight, Color.WHITE, hasEffect, entity, armorQuads.transparentQuads(), true);
    }

    private void render(HumanoidModel<? extends LivingEntity> baseModel, MultiBufferSource renderer, PoseStack matrix, int light, int overlayLight, Color color, boolean hasEffect, LivingEntity entity, Map<ModelPos, List<BakedQuad>> quadMap, boolean transparent) {
        if (!quadMap.isEmpty()) {
            RenderType renderType = transparent ? RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS) : MekanismRenderType.MEKASUIT;
            VertexConsumer builder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)renderer, (RenderType)renderType, (boolean)false, (boolean)hasEffect);
            for (Map.Entry<ModelPos, List<BakedQuad>> entry : quadMap.entrySet()) {
                matrix.pushPose();
                entry.getKey().translate(baseModel, matrix, entity);
                this.putQuads(entry.getValue(), builder, matrix.last(), light, overlayLight, color);
                matrix.popPose();
            }
        }
    }

    private void putQuads(List<BakedQuad> quads, VertexConsumer builder, PoseStack.Pose pose, int light, int overlayLight, Color color) {
        for (BakedQuad quad : quads) {
            builder.putBulkData(pose, quad, color.rf(), color.gf(), color.bf(), color.af(), light, overlayLight, false);
        }
    }

    private static List<BakedQuad> getQuads(BaseModelCache.MekanismModelData data, Set<String> parts, Set<String> ledParts, @Nullable QuadTransformation transform) {
        RandomSource random = Minecraft.getInstance().level.getRandom();
        List<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (!parts.isEmpty()) {
            quads.addAll(data.bake(new MekaSuitModelConfiguration(parts)).getQuads(null, null, random, ModelData.EMPTY, null));
        }
        if (!ledParts.isEmpty()) {
            List ledQuads = data.bake(new MekaSuitModelConfiguration(ledParts)).getQuads(null, null, random, ModelData.EMPTY, null);
            quads.addAll(QuadUtils.transformBakedQuads(ledQuads, QuadTransformation.fullbright));
        }
        if (transform != null) {
            quads = QuadUtils.transformBakedQuads(quads, transform);
        }
        return quads;
    }

    @Override
    @NotNull
    public ICustomArmor gearModel() {
        return this;
    }

    private static void processMekaTool(BaseModelCache.OBJModelData mekaToolModel, Set<String> ignored) {
        for (String name : mekaToolModel.getModel().getRootComponentNames()) {
            if (!name.contains(OVERRIDDEN_TAG)) continue;
            ignored.add(MekaSuitArmor.processOverrideName(name, "mekatool"));
        }
    }

    private ArmorQuads createQuads(Object2BooleanMap<ModuleModelSpec> modules, Set<EquipmentSlot> wornParts, boolean hasMekaToolLeft, boolean hasMekaToolRight) {
        Object2ObjectOpenHashMap specialQuadsToRender = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap specialLEDQuadsToRender = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap overrides = new Object2ObjectOpenHashMap();
        HashSet<String> ignored = new HashSet<String>();
        if (!modules.isEmpty()) {
            Set matchedParts;
            Object2ObjectOpenHashMap allMatchedParts = new Object2ObjectOpenHashMap();
            for (ModuleOBJModelData moduleOBJModelData : MekanismModelCache.INSTANCE.MEKASUIT_MODULES) {
                matchedParts = allMatchedParts.computeIfAbsent(moduleOBJModelData, d -> new HashSet());
                for (Object2BooleanMap.Entry entry : modules.object2BooleanEntrySet()) {
                    ModuleModelSpec spec = (ModuleModelSpec)entry.getKey();
                    for (String name : moduleOBJModelData.getPartsForSpec(spec, entry.getBooleanValue())) {
                        if (name.contains(OVERRIDDEN_TAG)) {
                            overrides.put(spec.processOverrideName(name), new OverrideData(moduleOBJModelData, name));
                        }
                        if (this.type != spec.slotType) continue;
                        matchedParts.add(name);
                    }
                }
            }
            for (Map.Entry entry : allMatchedParts.entrySet()) {
                matchedParts = (Set)entry.getValue();
                if (matchedParts.isEmpty()) continue;
                BaseModelCache.MekanismModelData modelData = (BaseModelCache.MekanismModelData)entry.getKey();
                Map quadsToRender = specialQuadsToRender.computeIfAbsent(modelData, d -> new EnumMap(ModelPos.class));
                Map ledQuadsToRender = specialLEDQuadsToRender.computeIfAbsent(modelData, d -> new EnumMap(ModelPos.class));
                for (String name : matchedParts) {
                    ModelPos modelPos = ModelPos.get(name);
                    if (modelPos == null) {
                        Mekanism.logger.warn("MekaSuit part '{}' is invalid from modules model. Ignoring.", (Object)name);
                        continue;
                    }
                    MekaSuitArmor.addQuadsToRender(modelPos, name, (Map<String, OverrideData>)overrides, quadsToRender, ledQuadsToRender, (Map<BaseModelCache.MekanismModelData, Map<ModelPos, Set<String>>>)specialQuadsToRender, (Map<BaseModelCache.MekanismModelData, Map<ModelPos, Set<String>>>)specialLEDQuadsToRender);
                }
            }
        }
        if (this.type == EquipmentSlot.CHEST) {
            if (hasMekaToolLeft) {
                MekaSuitArmor.processMekaTool(MekanismModelCache.INSTANCE.MEKATOOL_LEFT_HAND, ignored);
            }
            if (hasMekaToolRight) {
                MekaSuitArmor.processMekaTool(MekanismModelCache.INSTANCE.MEKATOOL_RIGHT_HAND, ignored);
            }
        }
        EnumMap<ModelPos, Set<String>> armorQuadsToRender = new EnumMap<ModelPos, Set<String>>(ModelPos.class);
        EnumMap<ModelPos, Set<String>> armorLEDQuadsToRender = new EnumMap<ModelPos, Set<String>>(ModelPos.class);
        for (String name : MekanismModelCache.INSTANCE.MEKASUIT.getModel().getRootComponentNames()) {
            if (!MekaSuitArmor.checkEquipment(this.type, name) || (!name.startsWith(EXCLUSIVE_TAG) ? name.startsWith(SHARED_TAG) && wornParts.contains(this.adjacentType) && this.adjacentType.ordinal() > this.type.ordinal() : wornParts.contains(this.adjacentType))) continue;
            ModelPos pos = ModelPos.get(name);
            if (pos == null) {
                Mekanism.logger.warn("MekaSuit part '{}' is invalid. Ignoring.", (Object)name);
                continue;
            }
            if (ignored.contains(name)) continue;
            MekaSuitArmor.addQuadsToRender(pos, name, (Map<String, OverrideData>)overrides, armorQuadsToRender, armorLEDQuadsToRender, (Map<BaseModelCache.MekanismModelData, Map<ModelPos, Set<String>>>)specialQuadsToRender, (Map<BaseModelCache.MekanismModelData, Map<ModelPos, Set<String>>>)specialLEDQuadsToRender);
        }
        EnumMap<ModelPos, List<BakedQuad>> enumMap = new EnumMap<ModelPos, List<BakedQuad>>(ModelPos.class);
        EnumMap<ModelPos, List<BakedQuad>> transparentMap = new EnumMap<ModelPos, List<BakedQuad>>(ModelPos.class);
        for (ModelPos pos : ModelPos.VALUES) {
            for (BaseModelCache.MekanismModelData mekanismModelData : MekanismModelCache.INSTANCE.MEKASUIT_MODULES) {
                MekaSuitArmor.parseTransparency(mekanismModelData, pos, enumMap, transparentMap, specialQuadsToRender.getOrDefault(mekanismModelData, Collections.emptyMap()), specialLEDQuadsToRender.getOrDefault(mekanismModelData, Collections.emptyMap()));
            }
            MekaSuitArmor.parseTransparency(MekanismModelCache.INSTANCE.MEKASUIT, pos, enumMap, transparentMap, armorQuadsToRender, armorLEDQuadsToRender);
        }
        return new ArmorQuads(enumMap, transparentMap);
    }

    private static void addQuadsToRender(ModelPos pos, String name, Map<String, OverrideData> overrides, Map<ModelPos, Set<String>> quadsToRender, Map<ModelPos, Set<String>> ledQuadsToRender, Map<BaseModelCache.MekanismModelData, Map<ModelPos, Set<String>>> specialQuadsToRender, Map<BaseModelCache.MekanismModelData, Map<ModelPos, Set<String>>> specialLEDQuadsToRender) {
        OverrideData override = overrides.get(name);
        if (override != null) {
            name = override.name();
            BaseModelCache.MekanismModelData overrideData = override.modelData();
            quadsToRender = specialQuadsToRender.computeIfAbsent(overrideData, d -> new EnumMap(ModelPos.class));
            ledQuadsToRender = specialLEDQuadsToRender.computeIfAbsent(overrideData, d -> new EnumMap(ModelPos.class));
        }
        if (name.contains(LED_TAG)) {
            ledQuadsToRender.computeIfAbsent((ModelPos)pos, p -> new HashSet()).add(name);
        } else {
            quadsToRender.computeIfAbsent((ModelPos)pos, p -> new HashSet()).add(name);
        }
    }

    private static void parseTransparency(BaseModelCache.MekanismModelData modelData, ModelPos pos, Map<ModelPos, List<BakedQuad>> opaqueMap, Map<ModelPos, List<BakedQuad>> transparentMap, Map<ModelPos, Set<String>> regularQuads, Map<ModelPos, Set<String>> ledQuads) {
        HashSet<String> opaqueRegularQuads = new HashSet<String>();
        HashSet<String> opaqueLEDQuads = new HashSet<String>();
        HashSet<String> transparentRegularQuads = new HashSet<String>();
        HashSet<String> transparentLEDQuads = new HashSet<String>();
        MekaSuitArmor.parseTransparency(pos, opaqueRegularQuads, transparentRegularQuads, regularQuads);
        MekaSuitArmor.parseTransparency(pos, opaqueLEDQuads, transparentLEDQuads, ledQuads);
        MekaSuitArmor.addParsedQuads(modelData, pos, opaqueMap, opaqueRegularQuads, opaqueLEDQuads);
        MekaSuitArmor.addParsedQuads(modelData, pos, transparentMap, transparentRegularQuads, transparentLEDQuads);
    }

    private static void addParsedQuads(BaseModelCache.MekanismModelData modelData, ModelPos pos, Map<ModelPos, List<BakedQuad>> map, Set<String> quads, Set<String> ledQuads) {
        List<BakedQuad> bakedQuads = MekaSuitArmor.getQuads(modelData, quads, ledQuads, pos.getTransform());
        if (!bakedQuads.isEmpty()) {
            map.computeIfAbsent(pos, p -> new ArrayList()).addAll(bakedQuads);
        }
    }

    private static void parseTransparency(ModelPos pos, Set<String> opaqueQuads, Set<String> transparentQuads, Map<ModelPos, Set<String>> quads) {
        for (String quad : quads.getOrDefault((Object)pos, Collections.emptySet())) {
            if (quad.contains(GLASS_TAG)) {
                transparentQuads.add(quad);
                continue;
            }
            opaqueQuads.add(quad);
        }
    }

    private static boolean checkEquipment(EquipmentSlot type, String text) {
        return switch (type) {
            case EquipmentSlot.HEAD -> text.contains("helmet");
            case EquipmentSlot.CHEST -> text.contains("chest");
            case EquipmentSlot.LEGS -> text.contains("leggings");
            case EquipmentSlot.FEET -> text.contains("boots");
            default -> false;
        };
    }

    private static String processOverrideName(String part, String name) {
        return part.replaceFirst(OVERRIDDEN_TAG, "").replaceFirst(name + "_", "");
    }

    public static void registerModule(String name, IModuleDataProvider<?> moduleDataProvider, EquipmentSlot slotType, Predicate<LivingEntity> isActive) {
        ModuleData<?> module = moduleDataProvider.getModuleData();
        moduleModelSpec.put((Object)slotType, module, (Object)new ModuleModelSpec(module, slotType, name, isActive));
    }

    public QuickHash key(LivingEntity player) {
        Object2BooleanOpenHashMap modules = new Object2BooleanOpenHashMap();
        EnumSet<EquipmentSlot> wornParts = EnumSet.noneOf(EquipmentSlot.class);
        for (EquipmentSlot slotType : EnumUtils.ARMOR_SLOTS) {
            IModuleContainer container;
            ItemStack stack = player.getItemBySlot(slotType);
            if (!(stack.getItem() instanceof ItemMekaSuitArmor) || (container = IModuleHelper.INSTANCE.getModuleContainer(stack)) == null) continue;
            wornParts.add(slotType);
            for (Map.Entry entry : moduleModelSpec.row((Object)slotType).entrySet()) {
                if (!container.hasEnabled((IModuleDataProvider)entry.getKey())) continue;
                ModuleModelSpec spec = (ModuleModelSpec)entry.getValue();
                modules.put((Object)spec, spec.isActive(player));
            }
        }
        return new QuickHash(modules.isEmpty() ? Object2BooleanMaps.emptyMap() : modules, wornParts.isEmpty() ? Collections.emptySet() : wornParts, MekanismUtils.getItemInHand(player, HumanoidArm.LEFT).getItem() instanceof ItemMekaTool, MekanismUtils.getItemInHand(player, HumanoidArm.RIGHT).getItem() instanceof ItemMekaTool);
    }

    public static enum ModelPos {
        HEAD(BASE_TRANSFORM, s -> s.contains("head")),
        BODY(BASE_TRANSFORM, s -> s.contains("body")),
        LEFT_ARM(BASE_TRANSFORM.and(QuadTransformation.translate(-0.3125f, -0.125f, 0.0f)), s -> s.contains("left_arm")),
        RIGHT_ARM(BASE_TRANSFORM.and(QuadTransformation.translate(0.3125f, -0.125f, 0.0f)), s -> s.contains("right_arm")),
        LEFT_LEG(BASE_TRANSFORM.and(QuadTransformation.translate(-0.125f, -0.75f, 0.0f)), s -> s.contains("left_leg")),
        RIGHT_LEG(BASE_TRANSFORM.and(QuadTransformation.translate(0.125f, -0.75f, 0.0f)), s -> s.contains("right_leg")),
        LEFT_WING(BASE_TRANSFORM, s -> s.contains("left_wing")),
        RIGHT_WING(BASE_TRANSFORM, s -> s.contains("right_wing"));

        private static final float EXPANDED_WING_X = 1.0f;
        private static final float EXPANDED_WING_Y = -2.5f;
        private static final float EXPANDED_WING_Z = 5.0f;
        private static final float EXPANDED_WING_Y_ROT = 45.0f;
        private static final float EXPANDED_WING_Z_ROT = 25.0f;
        public static final ModelPos[] VALUES;
        private final QuadTransformation transform;
        private final Predicate<String> modelSpec;

        private ModelPos(QuadTransformation transform, Predicate<String> modelSpec) {
            this.transform = transform;
            this.modelSpec = modelSpec;
        }

        public QuadTransformation getTransform() {
            return this.transform;
        }

        public boolean contains(String s) {
            return this.modelSpec.test(s);
        }

        public static ModelPos get(String name) {
            name = name.toLowerCase(Locale.ROOT);
            for (ModelPos pos : VALUES) {
                if (!pos.contains(name)) continue;
                return pos;
            }
            return null;
        }

        public void translate(HumanoidModel<? extends LivingEntity> baseModel, PoseStack matrix, LivingEntity entity) {
            switch (this.ordinal()) {
                case 0: {
                    baseModel.head.translateAndRotate(matrix);
                    break;
                }
                case 1: {
                    baseModel.body.translateAndRotate(matrix);
                    break;
                }
                case 2: {
                    baseModel.leftArm.translateAndRotate(matrix);
                    break;
                }
                case 3: {
                    baseModel.rightArm.translateAndRotate(matrix);
                    break;
                }
                case 4: {
                    baseModel.leftLeg.translateAndRotate(matrix);
                    break;
                }
                case 5: {
                    baseModel.rightLeg.translateAndRotate(matrix);
                    break;
                }
                case 6: 
                case 7: {
                    this.translateWings(baseModel, matrix, entity);
                }
            }
        }

        private void translateWings(HumanoidModel<? extends LivingEntity> baseModel, PoseStack matrix, LivingEntity entity) {
            baseModel.body.translateAndRotate(matrix);
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            float yRot = 0.0f;
            float zRot = 0.0f;
            if (entity.isFallFlying() && entity.getXRot() < 45.0f) {
                float scale = 0.0f;
                if (entity.getXRot() > -45.0f || entity.getDeltaMovement().y > 1.0) {
                    scale = 1.0f;
                } else if (entity.getDeltaMovement().y > 0.0) {
                    scale = (float)entity.getDeltaMovement().y;
                }
                x = 1.0f * scale;
                y = -2.5f * scale;
                z = 5.0f * scale;
                yRot = 45.0f * scale;
                zRot = 25.0f * scale;
            }
            if (entity instanceof AbstractClientPlayer) {
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                player.elytraRotX = 0.0f;
                player.elytraRotY += (yRot - player.elytraRotY) * 0.01f;
                yRot = player.elytraRotY;
                float scale = player.elytraRotY / 45.0f;
                x = 1.0f * scale;
                y = -2.5f * scale;
                z = 5.0f * scale;
                zRot = player.elytraRotZ = 25.0f * scale;
            }
            if (this == RIGHT_WING) {
                x = -x;
                yRot = -yRot;
                zRot = -zRot;
            }
            matrix.translate(x / 16.0f, y / 16.0f, z / 16.0f);
            if (yRot != 0.0f) {
                matrix.mulPose(Axis.YP.rotationDegrees(yRot));
            }
            if (zRot != 0.0f) {
                matrix.mulPose(Axis.ZP.rotationDegrees(zRot));
            }
        }

        static {
            VALUES = ModelPos.values();
        }
    }

    private record ArmorQuads(Map<ModelPos, List<BakedQuad>> opaqueQuads, Map<ModelPos, List<BakedQuad>> transparentQuads) {
        private ArmorQuads {
            if (opaqueQuads.isEmpty()) {
                opaqueQuads = Collections.emptyMap();
            }
            if (transparentQuads.isEmpty()) {
                transparentQuads = Collections.emptyMap();
            }
        }
    }

    private record MekaSuitModelConfiguration(Set<String> parts) implements IGeometryBakingContext
    {
        private static final Material NO_MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());

        private MekaSuitModelConfiguration {
            parts = parts.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(parts);
        }

        @NotNull
        public String getModelName() {
            return "mekanism:mekasuit";
        }

        public boolean hasMaterial(@NotNull String name) {
            return false;
        }

        @NotNull
        public Material getMaterial(@NotNull String name) {
            return NO_MATERIAL;
        }

        public boolean isGui3d() {
            return false;
        }

        public boolean useBlockLight() {
            return false;
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        @Deprecated
        @NotNull
        public ItemTransforms getTransforms() {
            return ItemTransforms.NO_TRANSFORMS;
        }

        @NotNull
        public Transformation getRootTransform() {
            return Transformation.identity();
        }

        @Nullable
        public ResourceLocation getRenderTypeHint() {
            return null;
        }

        public boolean isComponentVisible(@NotNull String component, boolean fallback) {
            return this.parts.contains(component);
        }
    }

    public static class ModuleOBJModelData
    extends BaseModelCache.OBJModelData {
        private final Map<ModuleModelSpec, SpecData> specParts = new Object2ObjectOpenHashMap();

        public ModuleOBJModelData(ResourceLocation rl) {
            super(rl);
        }

        private Set<String> getPartsForSpec(ModuleModelSpec spec, boolean active) {
            SpecData specData = this.specParts.get(spec);
            if (specData == null) {
                return Collections.emptySet();
            }
            return active ? specData.active() : specData.inactive();
        }

        @Override
        protected void reload(ModelEvent.BakingCompleted evt) {
            super.reload(evt);
            Collection modules = moduleModelSpec.values();
            for (String string : this.getModel().getRootComponentNames()) {
                ModuleModelSpec matchingSpec = null;
                int bestScore = -1;
                for (ModuleModelSpec spec2 : modules) {
                    int score = spec2.score(string);
                    if (score == -1 || bestScore != -1 && score >= bestScore) continue;
                    bestScore = score;
                    matchingSpec = spec2;
                }
                if (matchingSpec == null) continue;
                SpecData specData = this.specParts.computeIfAbsent(matchingSpec, spec -> new SpecData(new HashSet<String>(), new HashSet<String>()));
                if (string.contains(MekaSuitArmor.INACTIVE_TAG + matchingSpec.name + "_")) {
                    specData.inactive().add(string);
                    continue;
                }
                specData.active().add(string);
            }
            for (Map.Entry entry : this.specParts.entrySet()) {
                SpecData specData = (SpecData)entry.getValue();
                if (specData.active().isEmpty()) {
                    entry.setValue(new SpecData(Collections.emptySet(), specData.inactive()));
                    continue;
                }
                if (!specData.inactive().isEmpty()) continue;
                entry.setValue(new SpecData(specData.active(), Collections.emptySet()));
            }
        }

        private record SpecData(Set<String> active, Set<String> inactive) {
        }
    }

    private record ModuleModelSpec(ModuleData<?> module, EquipmentSlot slotType, String name, Predicate<LivingEntity> isActive) {
        public int score(String name) {
            return name.indexOf(this.name + "_");
        }

        public boolean isActive(LivingEntity entity) {
            return this.isActive.test(entity);
        }

        public String processOverrideName(String part) {
            return MekaSuitArmor.processOverrideName(part, this.name);
        }
    }

    private record OverrideData(BaseModelCache.MekanismModelData modelData, String name) {
    }
}

