/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import mekanism.api.recipes.SawmillRecipe;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiUpArrow;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class SawmillRecipeCategory
extends HolderRecipeCategory<SawmillRecipe> {
    private final GuiSlot input;
    private final GuiSlot output;

    public SawmillRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<SawmillRecipe> recipeType) {
        super(helper, recipeType);
        this.addElement(new GuiUpArrow(this, 60, 38));
        this.input = this.addSlot(SlotType.INPUT, 56, 17);
        this.addSlot(SlotType.POWER, 56, 53).with(SlotOverlay.POWER);
        this.output = this.addSlot(SlotType.OUTPUT_WIDE, 112, 31);
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 164, 15));
        this.addSimpleProgress(ProgressType.BAR, 78, 38);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<SawmillRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        SawmillRecipe recipe = (SawmillRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getInput().getRepresentations());
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output.getX() + 4, this.output.getY() + 4, recipe.getMainOutputDefinition());
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output.getX() + 20, this.output.getY() + 4, recipe.getSecondaryOutputDefinition());
    }

    @Override
    public void draw(RecipeHolder<SawmillRecipe> recipeHolder, IRecipeSlotsView recipeSlotView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotView, guiGraphics, mouseX, mouseY);
        double secondaryChance = ((SawmillRecipe)recipeHolder.value()).getSecondaryChance();
        if (secondaryChance > 0.0) {
            guiGraphics.drawString(this.getFont(), TextUtils.getPercent(secondaryChance), 104, 41, SpecialColors.TEXT_TITLE.argb(), false);
        }
    }
}

