/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class MekanismTankEmiWidget
extends SlotWidget {
    private final long capacity;
    @Nullable
    private final GuiGauge<?> gauge;

    public MekanismTankEmiWidget(EmiIngredient stack, GuiElement element, long capacity) {
        super(stack, element.getX(), element.getY());
        GuiGauge g;
        this.bounds = new Bounds(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        this.capacity = capacity;
        this.gauge = element instanceof GuiGauge ? (g = (GuiGauge)element) : null;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void drawStack(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        EmiStack stack;
        EmiIngredient ingredient = this.getStack();
        List stacks = ingredient.getEmiStacks();
        EmiStack emiStack = stack = stacks.isEmpty() ? EmiStack.EMPTY : (EmiStack)RecipeViewerUtils.getCurrent(stacks);
        if (!stack.isEmpty() && ingredient.getAmount() > 0L) {
            TextureAtlasSprite sprite;
            Object object = stack.getKey();
            if (object instanceof Chemical) {
                Chemical chemical = (Chemical)object;
                MekanismRenderer.color(graphics, chemical);
                sprite = MekanismRenderer.getChemicalTexture(chemical);
            } else {
                object = stack.getKey();
                if (object instanceof Fluid) {
                    Fluid fluid = (Fluid)object;
                    FluidStack fluidStack = new FluidStack((Holder)fluid.builtInRegistryHolder(), MathUtils.clampToInt(ingredient.getAmount()), stack.getComponentChanges());
                    MekanismRenderer.color(graphics, fluidStack);
                    sprite = MekanismRenderer.getFluidTexture(fluidStack, MekanismRenderer.FluidTextureType.STILL);
                } else {
                    return;
                }
            }
            int x = this.bounds.x() + 1;
            int y = this.bounds.y() + 1;
            int width = this.bounds.width() - 2;
            int height = this.bounds.height() - 2;
            int desiredHeight = MathUtils.clampToInt((double)height * (double)ingredient.getAmount() / (double)this.capacity);
            if (desiredHeight < 1) {
                desiredHeight = 1;
            }
            if (desiredHeight > height) {
                desiredHeight = height;
            }
            GuiUtils.drawTiledSprite(graphics, x, y, height, width, desiredHeight, sprite, 16, 16, 0, GuiUtils.TilingDirection.UP_RIGHT);
            MekanismRenderer.resetColor(graphics);
        }
        if (this.gauge != null) {
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate((float)this.gauge.getGuiLeft(), (float)this.gauge.getGuiTop(), 0.0f);
            this.gauge.drawBarOverlay(graphics);
            pose.popPose();
        }
    }
}

