/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.recipe;

import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.widget.MekanismEmiWidget;
import mekanism.client.recipe_viewer.emi.widget.MekanismTankEmiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class MekanismEmiRecipe<RECIPE>
extends AbstractContainerEventHandler
implements EmiRecipe,
IGuiWrapper {
    private final List<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
    private final List<EmiIngredient> catalysts = new ArrayList<EmiIngredient>();
    private final List<EmiStack> outputs = new ArrayList<EmiStack>();
    private final List<EmiIngredient> renderOutputs = new ArrayList<EmiIngredient>();
    private final EmiRecipeCategory category;
    private final ResourceLocation id;
    protected final RECIPE recipe;
    private final int xOffset;
    private final int yOffset;
    private final int width;
    private final int height;

    public MekanismEmiRecipe(MekanismEmiRecipeCategory category, ResourceLocation id, RECIPE recipe) {
        this(category, id, recipe, category.xOffset(), category.yOffset(), category.width(), category.height());
    }

    public MekanismEmiRecipe(EmiRecipeCategory category, ResourceLocation id, RECIPE recipe, int xOffset, int yOffset, int width, int height) {
        this.category = category;
        this.recipe = recipe;
        this.id = id;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.width = width;
        this.height = height;
    }

    protected EmiIngredient input(int index) {
        return this.inputs.get(index);
    }

    protected EmiIngredient catalyst(int index) {
        return this.catalysts.get(index);
    }

    protected EmiIngredient output(int index) {
        return this.renderOutputs.get(index);
    }

    protected void addInputDefinition(ItemStackIngredient ingredient) {
        this.inputs.add(this.ingredient(ingredient));
    }

    protected void addInputDefinition(FluidStackIngredient ingredient) {
        this.inputs.add(this.fluidIngredient(ingredient));
    }

    protected void addInputDefinition(ChemicalStackIngredient ingredient) {
        this.inputs.add(this.chemicalIngredient(ingredient));
    }

    protected void addInputDefinition(ChemicalStackIngredient ingredient, int scalar) {
        this.inputs.add(this.chemicalIngredient(ingredient, scalar));
    }

    protected void addEmptyInput() {
        this.inputs.add((EmiIngredient)EmiStack.EMPTY);
    }

    protected void addCatalsyst(ChemicalStackIngredient ingredient) {
        this.catalysts.add(this.ingredient(RecipeViewerUtils.getStacksFor(ingredient, true)));
    }

    protected void addItemOutputDefinition(List<ItemStack> definition) {
        this.addOutputDefinition(definition.stream().map(EmiStack::of).toList());
    }

    protected void addFluidOutputDefinition(List<FluidStack> definition) {
        this.addOutputDefinition(definition.stream().map(NeoForgeEmiStack::of).toList());
    }

    protected void addChemicalOutputDefinition(List<ChemicalStack> definition) {
        this.addOutputDefinition(definition.stream().map(ChemicalEmiStack::create).toList());
    }

    protected void addOutputDefinition(List<EmiStack> stacks) {
        if (stacks.isEmpty()) {
            this.outputs.add(EmiStack.EMPTY);
            this.renderOutputs.add((EmiIngredient)EmiStack.EMPTY);
        } else {
            this.outputs.addAll(stacks);
            this.renderOutputs.add(EmiIngredient.of(stacks));
        }
    }

    @Override
    public int getGuiLeft() {
        return this.xOffset;
    }

    @Override
    public int getGuiTop() {
        return this.yOffset;
    }

    @Override
    public int getXSize() {
        return this.width;
    }

    @Override
    public int getYSize() {
        return this.height;
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public int getDisplayWidth() {
        return this.getXSize();
    }

    public int getDisplayHeight() {
        return this.getYSize();
    }

    @Nullable
    public RecipeHolder<?> getBackingRecipe() {
        return null;
    }

    @Override
    public Font getFont() {
        return Minecraft.getInstance().font;
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    protected static <STACK> Supplier<STACK> getSupplier(List<STACK> stacks, STACK empty) {
        if (stacks.isEmpty()) {
            return () -> empty;
        }
        if (stacks.size() == 1) {
            Object stack = stacks.getFirst();
            return () -> stack;
        }
        return () -> RecipeViewerUtils.getCurrent(stacks);
    }

    protected SlotWidget addSlot(WidgetHolder widgetHolder, SlotType type, int x, int y, EmiIngredient ingredient) {
        GuiSlot slot = this.addSlot(widgetHolder, type, x, y);
        return this.initItem(widgetHolder, slot.getX(), slot.getY(), ingredient);
    }

    protected GuiSlot addSlot(WidgetHolder widgetHolder, SlotType type, int x, int y) {
        return this.addElement(widgetHolder, new GuiSlot(type, this, x - 1, y - 1));
    }

    protected GuiProgress addConstantProgress(WidgetHolder widgetHolder, ProgressType type, int x, int y) {
        return this.addElement(widgetHolder, new GuiProgress(RecipeViewerUtils.CONSTANT_PROGRESS, type, (IGuiWrapper)this, x, y));
    }

    protected GuiProgress addSimpleProgress(WidgetHolder widgetHolder, ProgressType type, int x, int y, int processTime) {
        return this.addElement(widgetHolder, new GuiProgress(RecipeViewerUtils.progressHandler(processTime), type, (IGuiWrapper)this, x, y));
    }

    protected <ELEMENT extends GuiElement> ELEMENT addElement(WidgetHolder widgetHolder, ELEMENT element) {
        return this.addElement(widgetHolder, element, false);
    }

    protected <ELEMENT extends GuiElement> ELEMENT addElement(WidgetHolder widgetHolder, ELEMENT element, boolean forwardClicks) {
        widgetHolder.add((Widget)new MekanismEmiWidget(element, forwardClicks));
        return element;
    }

    protected EmiIngredient ingredient(ItemStackIngredient ingredient) {
        return this.ingredient(ingredient.getRepresentations());
    }

    protected EmiIngredient ingredient(List<ItemStack> representations) {
        return EmiIngredient.of(representations.stream().map(EmiStack::of).toList());
    }

    protected EmiIngredient fluidIngredient(FluidStackIngredient ingredient) {
        return EmiIngredient.of(ingredient.getRepresentations().stream().map(NeoForgeEmiStack::of).toList());
    }

    protected EmiIngredient chemicalIngredient(ChemicalStackIngredient ingredient) {
        return EmiIngredient.of(ingredient.getRepresentations().stream().map(ChemicalEmiStack::create).toList());
    }

    protected EmiIngredient chemicalIngredient(ChemicalStackIngredient ingredient, int scalar) {
        List<ChemicalStack> representations = ingredient.getRepresentations();
        if (representations.isEmpty()) {
            return EmiStack.EMPTY;
        }
        ArrayList<ChemicalEmiStack> list = new ArrayList<ChemicalEmiStack>(representations.size());
        for (ChemicalStack stack : representations) {
            list.add(ChemicalEmiStack.create(stack.getChemical(), stack.getAmount() * (long)scalar));
        }
        return EmiIngredient.of(list);
    }

    protected SlotWidget initItem(WidgetHolder widgetHolder, GuiSlot slot, EmiIngredient ingredient) {
        this.addElement(widgetHolder, slot);
        return this.initItem(widgetHolder, slot.getX(), slot.getY(), ingredient);
    }

    protected SlotWidget initItem(WidgetHolder widgetHolder, int x, int y, EmiIngredient ingredient) {
        return widgetHolder.addSlot(ingredient, x, y).drawBack(false);
    }

    protected SlotWidget initTank(WidgetHolder widgetHolder, GuiElement element, EmiIngredient ingredient) {
        this.addElement(widgetHolder, element);
        return ((MekanismTankEmiWidget)widgetHolder.add((Widget)new MekanismTankEmiWidget(ingredient, element, ingredient.getAmount()))).drawBack(false);
    }
}

