/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiExclusionArea;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IItemProvider;
import mekanism.api.recipes.ItemStackToFluidOptionalItemRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.ChemicalEmiIngredientSerializer;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import mekanism.client.recipe_viewer.emi.EmiExclusionHandler;
import mekanism.client.recipe_viewer.emi.EmiGhostIngredientHandler;
import mekanism.client.recipe_viewer.emi.EmiStackUnderMouseProvider;
import mekanism.client.recipe_viewer.emi.INamedRVRecipe;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.recipe.BoilerEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ChemicalChemicalToChemicalEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ChemicalCrystallizerEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ChemicalDissolutionEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ChemicalToChemicalEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.CombinerEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ElectrolysisEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.FluidChemicalToChemicalEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.FluidToFluidEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ItemStackChemicalToItemStackEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ItemStackToChemicalEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ItemStackToEnergyEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ItemStackToFluidOptionalItemEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.ItemStackToItemStackEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.MekanismEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.MetallurgicInfuserEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.NucleosynthesizingEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.PaintingEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.PigmentExtractingEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.PigmentMixerEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.PressurizedReactionEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.RotaryEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.SPSEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.SawmillEmiRecipe;
import mekanism.client.recipe_viewer.emi.transfer.EmiQIOCraftingTransferHandler;
import mekanism.client.recipe_viewer.emi.transfer.FormulaicAssemblicatorTransferHandler;
import mekanism.client.recipe_viewer.recipe.BoilerRecipeViewerRecipe;
import mekanism.client.recipe_viewer.recipe.SPSRecipeViewerRecipe;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

@EmiEntrypoint
public class MekanismEmi
implements EmiPlugin {
    private static final ChemicalEmiIngredientSerializer CHEMICAL_SERIALIZER = new ChemicalEmiIngredientSerializer();
    private static final EmiRegistryAdapter<Chemical> CHEMICAL_REGISTRY_ADAPTER = EmiRegistryAdapter.simple(Chemical.class, MekanismAPI.CHEMICAL_REGISTRY, ChemicalEmiStack::new);
    private static final Comparison MEKANISM_COMPARISON = Comparison.compareData(emiStack -> {
        HashSet<Object> representation = new HashSet<Object>();
        ItemStack stack = emiStack.getItemStack();
        MekanismEmi.addChemicalComponent(representation, stack);
        MekanismEmi.addFluidComponent(representation, stack);
        MekanismEmi.addEnergyComponent(representation, stack);
        if (!representation.isEmpty()) {
            return representation;
        }
        return null;
    });

    private static void addChemicalComponent(Set<Object> representation, ItemStack stack) {
        IChemicalHandler handler = ContainerType.CHEMICAL.createHandlerIfData(stack);
        if (handler == null) {
            handler = (IChemicalHandler)stack.getCapability(Capabilities.CHEMICAL.item());
        }
        if (handler != null) {
            int tanks = handler.getChemicalTanks();
            if (tanks == 1) {
                ChemicalStack chemicalStack = handler.getChemicalInTank(0);
                if (!chemicalStack.isEmpty()) {
                    representation.add(chemicalStack.getChemical());
                }
            } else if (tanks > 1) {
                ArrayList<Chemical> chemicals = new ArrayList<Chemical>(tanks);
                for (int tank = 0; tank < tanks; ++tank) {
                    chemicals.add(handler.getChemicalInTank(tank).getChemical());
                }
                representation.add(chemicals);
            }
        }
    }

    private static void addFluidComponent(Set<Object> representation, ItemStack stack) {
        IFluidHandler handler = ContainerType.FLUID.createHandlerIfData(stack);
        if (handler == null) {
            handler = (IFluidHandler)Capabilities.FLUID.getCapability(stack);
        }
        if (handler != null) {
            int tanks = handler.getTanks();
            if (tanks == 1) {
                FluidStack fluidStack = handler.getFluidInTank(0);
                if (!fluidStack.isEmpty()) {
                    representation.add(fluidStack);
                }
            } else if (tanks > 1) {
                ArrayList<FluidStack> fluids = new ArrayList<FluidStack>(tanks);
                for (int tank = 0; tank < tanks; ++tank) {
                    fluids.add(handler.getFluidInTank(tank));
                }
                representation.add(fluids);
            }
        }
    }

    private static void addEnergyComponent(Set<Object> representation, ItemStack stack) {
        IStrictEnergyHandler energyHandlerItem = ContainerType.ENERGY.createHandlerIfData(stack);
        if (energyHandlerItem == null) {
            energyHandlerItem = (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapability(stack);
        }
        if (energyHandlerItem != null) {
            int containers = energyHandlerItem.getEnergyContainerCount();
            if (containers == 1) {
                long neededEnergy = energyHandlerItem.getNeededEnergy(0);
                if (neededEnergy == 0L) {
                    representation.add("filled");
                }
            } else if (containers > 1) {
                StringBuilder component = new StringBuilder();
                for (int container = 0; container < containers; ++container) {
                    long neededEnergy = energyHandlerItem.getNeededEnergy(container);
                    if (neededEnergy == 0L) {
                        component.append("filled");
                        continue;
                    }
                    component.append("empty");
                }
                representation.add(component.toString());
            }
        }
    }

    public void initialize(EmiInitRegistry registry) {
        registry.addIngredientSerializer(ChemicalEmiStack.class, (EmiIngredientSerializer)CHEMICAL_SERIALIZER);
        registry.addRegistryAdapter(CHEMICAL_REGISTRY_ADAPTER);
    }

    public void register(EmiRegistry registry) {
        CHEMICAL_SERIALIZER.addEmiStacks(registry);
        registry.addGenericExclusionArea((EmiExclusionArea)new EmiExclusionHandler());
        registry.addGenericDragDropHandler((EmiDragDropHandler)new EmiGhostIngredientHandler());
        registry.addGenericStackProvider((EmiStackProvider)new EmiStackUnderMouseProvider());
        registry.addRecipeHandler((MenuType)MekanismContainerTypes.FORMULAIC_ASSEMBLICATOR.get(), (EmiRecipeHandler)new FormulaicAssemblicatorTransferHandler());
        registry.addRecipeHandler((MenuType)MekanismContainerTypes.QIO_DASHBOARD.get(), new EmiQIOCraftingTransferHandler());
        registry.addRecipeHandler((MenuType)MekanismContainerTypes.PORTABLE_QIO_DASHBOARD.get(), new EmiQIOCraftingTransferHandler());
        this.addCategories(registry);
        MekanismEmi.addWorkstations(registry, VanillaEmiRecipeCategories.SMELTING, RecipeViewerRecipeType.VANILLA_SMELTING.workstations());
        MekanismEmi.addWorkstations(registry, VanillaEmiRecipeCategories.CRAFTING, RecipeViewerRecipeType.VANILLA_CRAFTING.workstations());
        MekanismEmi.addWorkstations(registry, VanillaEmiRecipeCategories.ANVIL_REPAIRING, List.of(MekanismItems.ROBIT));
        MekanismEmi.registerItemSubtypes(registry, MekanismItems.ITEMS.getEntries());
        MekanismEmi.registerItemSubtypes(registry, MekanismBlocks.BLOCKS.getSecondaryEntries());
    }

    public static void registerItemSubtypes(EmiRegistry registry, Collection<? extends Holder<? extends ItemLike>> itemProviders) {
        for (Holder<? extends ItemLike> holder : itemProviders) {
            ItemStack stack = new ItemStack((ItemLike)holder.value());
            if (!Capabilities.STRICT_ENERGY.hasCapability(stack) && !Capabilities.CHEMICAL.hasCapability(stack) && !Capabilities.FLUID.hasCapability(stack)) continue;
            registry.setDefaultComparison((Object)stack.getItem(), MEKANISM_COMPARISON);
        }
    }

    private void addCategories(EmiRegistry registry) {
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.CRYSTALLIZING, ChemicalCrystallizerEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.DISSOLUTION, ChemicalDissolutionEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.CHEMICAL_INFUSING, ChemicalChemicalToChemicalEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.WASHING, FluidChemicalToChemicalEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.SEPARATING, ElectrolysisEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.METALLURGIC_INFUSING, MetallurgicInfuserEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.REACTION, PressurizedReactionEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.PIGMENT_EXTRACTING, PigmentExtractingEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.PIGMENT_MIXING, PigmentMixerEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.PAINTING, PaintingEmiRecipe::new);
        MekanismEmiRecipeCategory condensentratingCategory = MekanismEmi.addCategory(registry, RecipeViewerRecipeType.CONDENSENTRATING);
        MekanismEmiRecipeCategory decondensentratingCategory = MekanismEmi.addCategory(registry, RecipeViewerRecipeType.DECONDENSENTRATING);
        for (RecipeHolder recipeHolder2 : MekanismRecipeType.ROTARY.getRecipes(registry.getRecipeManager(), null)) {
            RotaryRecipe recipe2 = (RotaryRecipe)recipeHolder2.value();
            if (recipe2.hasChemicalToFluid()) {
                if (recipe2.hasFluidToChemical()) {
                    registry.addRecipe((EmiRecipe)new RotaryEmiRecipe(condensentratingCategory, RecipeViewerUtils.synthetic(recipeHolder2.id(), "condensentrating"), (RecipeHolder<RotaryRecipe>)recipeHolder2, true));
                    registry.addRecipe((EmiRecipe)new RotaryEmiRecipe(decondensentratingCategory, RecipeViewerUtils.synthetic(recipeHolder2.id(), "decondensentrating"), (RecipeHolder<RotaryRecipe>)recipeHolder2, false));
                    continue;
                }
                registry.addRecipe((EmiRecipe)new RotaryEmiRecipe(condensentratingCategory, recipeHolder2.id(), (RecipeHolder<RotaryRecipe>)recipeHolder2, true));
                continue;
            }
            if (!recipe2.hasFluidToChemical()) continue;
            registry.addRecipe((EmiRecipe)new RotaryEmiRecipe(decondensentratingCategory, recipeHolder2.id(), (RecipeHolder<RotaryRecipe>)recipeHolder2, false));
        }
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.OXIDIZING, (category, recipeHolder) -> new ItemStackToChemicalEmiRecipe((MekanismEmiRecipeCategory)((Object)category), recipeHolder, 100));
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.NUTRITIONAL_LIQUIFICATION, (MekanismEmiRecipeCategory category, ResourceLocation id, RECIPE recipe) -> new ItemStackToFluidOptionalItemEmiRecipe(category, id, (ItemStackToFluidOptionalItemRecipe)recipe, 100), RecipeViewerUtils.getLiquificationRecipes());
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.ACTIVATING, ChemicalToChemicalEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.CENTRIFUGING, ChemicalToChemicalEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.COMBINING, CombinerEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.PURIFYING, ItemStackChemicalToItemStackEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.COMPRESSING, ItemStackChemicalToItemStackEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.INJECTING, ItemStackChemicalToItemStackEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.NUCLEOSYNTHESIZING, NucleosynthesizingEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.SPS, SPSEmiRecipe::new, SPSRecipeViewerRecipe.getSPSRecipes());
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.BOILER, BoilerEmiRecipe::new, BoilerRecipeViewerRecipe.getBoilerRecipes());
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.SAWING, SawmillEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.ENRICHING, ItemStackToItemStackEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.CRUSHING, ItemStackToItemStackEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.SMELTING, ItemStackToItemStackEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.EVAPORATING, FluidToFluidEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.ENERGY_CONVERSION, ItemStackToEnergyEmiRecipe::new);
        MekanismEmi.addCategoryAndRecipes(registry, RecipeViewerRecipeType.CHEMICAL_CONVERSION, (category, recipeHolder) -> new ItemStackToChemicalEmiRecipe((MekanismEmiRecipeCategory)((Object)category), recipeHolder, 0));
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((Fluid)MekanismFluids.HEAVY_WATER.getFluid())), List.of(MekanismLang.RECIPE_VIEWER_INFO_HEAVY_WATER.translate(MekanismConfig.general.pumpHeavyWaterAmount.get())), Mekanism.rl("info/heavy_water")));
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(MekanismAPI.MODULE_REGISTRY.stream().map(data -> EmiStack.of((ItemLike)data.getItemProvider())).toList(), List.of(MekanismLang.RECIPE_VIEWER_INFO_MODULE_INSTALLATION.translate()), Mekanism.rl("info/module_installation")));
    }

    public static <RECIPE extends MekanismRecipe<?>, TYPE extends IRecipeViewerRecipeType<RECIPE> & IMekanismRecipeTypeProvider<?, RECIPE, ?>> void addCategoryAndRecipes(EmiRegistry registry, TYPE recipeType, BiFunction<MekanismEmiRecipeCategory, RecipeHolder<RECIPE>, MekanismEmiRecipe<RECIPE>> recipeCreator) {
        MekanismEmiRecipeCategory category = MekanismEmi.addCategory(registry, recipeType);
        for (RecipeHolder<RECIPE> recipe : ((IMekanismRecipeTypeProvider<?, RECIPE, ?>)recipeType).getRecipes(registry.getRecipeManager(), null)) {
            registry.addRecipe((EmiRecipe)recipeCreator.apply(category, recipe));
        }
    }

    public static <RECIPE> void addCategoryAndRecipes(EmiRegistry registry, IRecipeViewerRecipeType<RECIPE> recipeType, BasicRecipeCreator<RECIPE> recipeCreator, Map<ResourceLocation, RECIPE> recipes) {
        MekanismEmiRecipeCategory category = MekanismEmi.addCategory(registry, recipeType);
        for (Map.Entry<ResourceLocation, RECIPE> entry : recipes.entrySet()) {
            registry.addRecipe(recipeCreator.create(category, entry.getKey(), entry.getValue()));
        }
    }

    public static <RECIPE extends INamedRVRecipe> void addCategoryAndRecipes(EmiRegistry registry, IRecipeViewerRecipeType<RECIPE> recipeType, BasicRecipeCreator<RECIPE> recipeCreator, List<RECIPE> recipes) {
        MekanismEmiRecipeCategory category = MekanismEmi.addCategory(registry, recipeType);
        for (INamedRVRecipe recipe : recipes) {
            registry.addRecipe(recipeCreator.create(category, recipe.id(), recipe));
        }
    }

    private static MekanismEmiRecipeCategory addCategory(EmiRegistry registry, IRecipeViewerRecipeType<?> recipeType) {
        MekanismEmiRecipeCategory category = MekanismEmiRecipeCategory.create(recipeType);
        registry.addCategory((EmiRecipeCategory)category);
        MekanismEmi.addWorkstations(registry, category, recipeType.workstations());
        return category;
    }

    private static void addWorkstations(EmiRegistry registry, EmiRecipeCategory category, List<IItemProvider> workstations) {
        for (IItemProvider workstation : workstations) {
            IBlockProvider mekanismBlock;
            AttributeFactoryType factoryType;
            registry.addWorkstation(category, (EmiIngredient)EmiStack.of((ItemLike)workstation));
            if (!(workstation instanceof IBlockProvider) || (factoryType = Attribute.get((mekanismBlock = (IBlockProvider)workstation).getBlock(), AttributeFactoryType.class)) == null) continue;
            for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
                registry.addWorkstation(category, (EmiIngredient)EmiStack.of(MekanismBlocks.getFactory(tier, factoryType.getFactoryType())));
            }
        }
    }

    public static interface BasicRecipeCreator<RECIPE> {
        public MekanismEmiRecipe<RECIPE> create(MekanismEmiRecipeCategory var1, ResourceLocation var2, RECIPE var3);
    }
}

