/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

@NothingNullByDefault
public class ChemicalEmiStack
extends EmiStack {
    private final Chemical chemical;

    public ChemicalEmiStack(ChemicalStack stack) {
        this(stack.getChemical(), stack.getAmount());
    }

    public ChemicalEmiStack(Chemical chemical, DataComponentPatch ignored, long amount) {
        this(chemical, amount);
    }

    public ChemicalEmiStack(Chemical chemical, long amount) {
        this.chemical = chemical;
        this.amount = amount;
    }

    public EmiStack copy() {
        ChemicalEmiStack e = new ChemicalEmiStack(this.chemical, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    public void render(GuiGraphics graphics, int x, int y, float delta, int flags) {
        if ((flags & 1) != 0) {
            ResourceLocation texture = this.chemical.getIcon();
            int color = this.chemical.getTint();
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
            float red = MekanismRenderer.getRed(color);
            float green = MekanismRenderer.getGreen(color);
            float blue = MekanismRenderer.getBlue(color);
            graphics.blit(x, y, 0, 16, 16, sprite, red, green, blue, 1.0f);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon((EmiIngredient)this, (GuiGraphics)graphics, (int)x, (int)y);
        }
    }

    public boolean isEmpty() {
        return this.chemical.isEmptyType() || this.amount == 0L;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Chemical getKey() {
        return this.chemical;
    }

    public ResourceLocation getId() {
        return this.chemical.getRegistryName();
    }

    public List<Component> getTooltipText() {
        if (this.chemical.isEmptyType()) {
            return Collections.emptyList();
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add(this.getName());
        ChemicalUtil.addChemicalDataToTooltip(tooltips, this.chemical, false);
        return tooltips;
    }

    public List<ClientTooltipComponent> getTooltip() {
        List<ClientTooltipComponent> tooltips = this.getTooltipText().stream().map(EmiTooltipComponents::of).collect(Collectors.toList());
        if (this.amount > 1L) {
            tooltips.add(EmiTooltipComponents.of((Component)MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, TextUtils.format(this.amount))));
        }
        EmiTooltipComponents.appendModName(tooltips, (String)this.getId().getNamespace());
        tooltips.addAll(super.getTooltip());
        return tooltips;
    }

    public Component getName() {
        return this.chemical.getTextComponent();
    }

    public static ChemicalEmiStack create(ChemicalStack stack) {
        return ChemicalEmiStack.create(stack.getChemical(), stack.getAmount());
    }

    public static ChemicalEmiStack create(IChemicalProvider chemicalProvider, long amount) {
        return new ChemicalEmiStack(chemicalProvider.getChemical(), amount);
    }
}

